/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import se.datadosen.util.Platform;

public class JSmartSeparator
extends JComponent {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private int align = 0;
    private String text = "";
    private Color textColor = SystemColor.textInactiveText;
    private Color lineColor = new Color(0, 0, 0, 60);

    public JSmartSeparator() {
        this("");
    }

    public JSmartSeparator(String text) {
        this(text, 0);
    }

    public JSmartSeparator(String text, int align) {
        this.align = align;
        this.setText(text);
        Font f = new JLabel().getFont();
        if (Platform.isMac()) {
            f = f.deriveFont(f.getSize2D() - 1.0f);
        }
        this.setFont(f);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        Map hints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (hints != null) {
            g.setRenderingHints(hints);
        }
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D b = fm.getStringBounds(this.text, g);
        int space = fm.getAscent() / 3;
        if (this.text.length() == 0) {
            space = 0;
        }
        int x1 = this.align == 0 ? fm.getAscent() : (this.align == 1 ? (int)(((double)w - b.getWidth()) / 2.0 - (double)space) : (int)((double)w - b.getWidth() - (double)(3 * space)));
        int ty = h - fm.getDescent();
        int x2 = (int)((double)x1 + b.getWidth());
        int ly = ty - fm.getDescent() - 1;
        g.setColor(this.isEnabled() ? this.textColor : SystemColor.textInactiveText);
        g.drawString(this.text, x1, ty);
        g.setColor(this.lineColor);
        g.drawLine(0, ly, x1 - space - 1, ly);
        g.drawLine(x2 + space, ly, w, ly);
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        Graphics g = this.getGraphics();
        if (g == null) {
            size.width = 4;
            size.height = 4;
            return size;
        }
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(this.text, g);
        g.dispose();
        size.width = (int)Math.ceil(r.getWidth());
        size.height = (int)Math.ceil(r.getHeight());
        return size;
    }
}

