/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class ChainedDirectory
extends File
implements Serializable {
    private ChainedDirectory backgroundDir;
    private boolean sortFileList;
    private Decider decider;

    public boolean isSortFileList() {
        return this.sortFileList;
    }

    public void setSortFileList(boolean sortFileList) {
        this.sortFileList = sortFileList;
    }

    public ChainedDirectory(File dir) {
        super(dir.getAbsolutePath());
        if (dir == null) {
            throw new NullPointerException();
        }
    }

    public ChainedDirectory(File dir, ChainedDirectory backgroundDir) {
        this(dir, backgroundDir, null);
    }

    public ChainedDirectory(File dir, ChainedDirectory backgroundDir, Decider decider) {
        super(dir.getAbsolutePath());
        this.decider = decider;
        if (dir == null) {
            throw new NullPointerException();
        }
        this.backgroundDir = backgroundDir;
    }

    public File getDirectory() {
        return new File(this.getAbsolutePath());
    }

    public ChainedDirectory getBackgroundDirectory() {
        return this.backgroundDir;
    }

    public File getFile(String name) {
        File f = new File(this, name);
        if (this.backgroundDir != null) {
            File bgFile = this.backgroundDir.getFile(name);
            if (!f.exists() || this.decider != null && bgFile.exists() && this.decider.useBackgroundFile(bgFile, f)) {
                return this.backgroundDir.getFile(name);
            }
        }
        return f;
    }

    public File[] listFiles() {
        return this.listFiles((FileFilter)null);
    }

    public File[] listFiles(FileFilter filter) {
        File[] files = this.doListFiles(filter);
        if (this.sortFileList) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return files;
    }

    private File[] doListFiles(FileFilter filter) {
        int i;
        File[] files = super.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        if (this.backgroundDir == null) {
            return files;
        }
        File[] bgfiles = this.backgroundDir.listFiles(filter);
        HashMap<String, File> allfiles = new HashMap<String, File>();
        for (i = 0; i < files.length; ++i) {
            allfiles.put(files[i].getName(), files[i]);
        }
        for (i = 0; i < bgfiles.length; ++i) {
            if (allfiles.containsKey(bgfiles[i].getName()) && (this.decider == null || !this.decider.useBackgroundFile(bgfiles[i], (File)allfiles.get(bgfiles[i].getName())))) continue;
            allfiles.put(bgfiles[i].getName(), bgfiles[i]);
        }
        return allfiles.values().toArray(new File[0]);
    }

    public static interface Decider {
        public boolean useBackgroundFile(File var1, File var2);
    }
}

