/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumObjectOrderer {
    private static final String ORDERING_KEY = "ordering";
    private static final String REVERSE_ORDERING_KEY = "reverseOrdering";
    private static final String FOLDERS_FIRST_KEY = "foldersFirst";
    private static final String FOLDER_ORDERING_KEY = "folderOrdering";
    private static final String REVERSE_FOLDER_ORDERING_KEY = "reverseFolderOrdering";
    private AlbumObjectImpl currentFolder;
    private AlbumObject.Ordering ordering = null;
    private AlbumObject.Ordering folderOrdering = AlbumObject.Ordering.date;
    private boolean foldersFirst;
    private boolean reverseOrdering;
    private boolean reverseFolderOrdering;

    public AlbumObjectOrderer(AlbumObjectImpl currentFolder) {
        this.currentFolder = currentFolder;
    }

    public AlbumObject.Ordering getFolderOrdering() {
        this.readProperties();
        return this.folderOrdering;
    }

    public void setFolderOrdering(AlbumObject.Ordering folderOrdering) {
        this.folderOrdering = folderOrdering;
    }

    public boolean isFoldersFirst() {
        this.readProperties();
        return this.foldersFirst;
    }

    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.foldersFirst = foldersFirst;
        this.writeProperties();
    }

    public AlbumObject.Ordering getOrdering() {
        this.readProperties();
        return this.ordering;
    }

    public void setOrdering(AlbumObject.Ordering ordering) throws IOException {
        this.ordering = ordering;
        this.writeProperties();
    }

    public boolean isReverseFolderOrdering() {
        this.readProperties();
        return this.reverseFolderOrdering;
    }

    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.reverseFolderOrdering = reverseFolderOrdering;
        this.writeProperties();
    }

    public boolean isReverseOrdering() {
        this.readProperties();
        return this.reverseOrdering;
    }

    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.reverseOrdering = reverseOrdering;
        this.writeProperties();
    }

    private File getMetaFile() {
        return new File(this.currentFolder.getFile(), "meta.properties");
    }

    private File getAlbumFilesFile() {
        return new File(this.currentFolder.getFile(), "albumfiles.txt");
    }

    private AlbumBean getEngine() {
        return this.currentFolder.factory.engine;
    }

    private void readProperties() {
        if (this.ordering == null) {
            Map props = this.getFolderProperties();
            this.ordering = props.containsKey(ORDERING_KEY) ? AlbumObject.Ordering.valueOf((String)props.get(ORDERING_KEY)) : AlbumObject.Ordering.jalbum;
            String s = (String)props.get(FOLDER_ORDERING_KEY);
            if (s != null) {
                this.folderOrdering = AlbumObject.Ordering.valueOf(s);
            }
            this.foldersFirst = this.isTrue(FOLDERS_FIRST_KEY, props);
            this.reverseOrdering = this.isTrue(REVERSE_ORDERING_KEY, props);
            this.reverseFolderOrdering = this.isTrue(REVERSE_FOLDER_ORDERING_KEY, props);
        }
    }

    private void writeProperties() throws IOException {
        Map props = this.getFolderProperties();
        props.put(ORDERING_KEY, this.ordering.name());
        if (this.reverseOrdering) {
            props.put(REVERSE_ORDERING_KEY, "" + this.reverseOrdering);
        } else {
            props.remove(REVERSE_ORDERING_KEY);
        }
        if (this.foldersFirst) {
            props.put(FOLDERS_FIRST_KEY, "" + this.foldersFirst);
            props.put(FOLDER_ORDERING_KEY, this.folderOrdering.name());
            props.put(REVERSE_FOLDER_ORDERING_KEY, "" + this.reverseFolderOrdering);
        } else {
            props.remove(FOLDERS_FIRST_KEY);
        }
        this.setFolderProperties(props);
    }

    private boolean isTrue(String key, Map props) {
        return "true".equals(props.get(key));
    }

    private Map getFolderProperties() {
        try {
            return AlbumBean.getFolderProperties(this.currentFolder.getFile());
        }
        catch (IOException ex) {
            return new HashMap();
        }
    }

    private void setFolderProperties(Map properties) throws IOException {
        IO.writeMapFile(properties, this.getMetaFile());
    }

    private AlbumObject.Ordering toOrdering(String jAlbumOrdering) {
        if (jAlbumOrdering.equals("OrderByDate")) {
            return AlbumObject.Ordering.date;
        }
        if (jAlbumOrdering.equals("OrderByAddedDate")) {
            return AlbumObject.Ordering.addedDate;
        }
        if (jAlbumOrdering.equals("OrderByCameraDate")) {
            return AlbumObject.Ordering.cameraDate;
        }
        if (jAlbumOrdering.equals("OrderByName")) {
            return AlbumObject.Ordering.name;
        }
        return AlbumObject.Ordering.simpleName;
    }

    public AlbumObject[] sort(AlbumObject[] objects) {
        this.readProperties();
        if (this.getOrdering() == AlbumObject.Ordering.jalbum) {
            AlbumObject.Ordering imageOrdering = this.toOrdering(this.getEngine().getImageOrdering());
            boolean reverseOrder = this.getEngine().isReverseOrder();
            boolean directoriesFirst = this.getEngine().isDirectoriesFirst();
            Comparator customImageOrdering = this.getEngine().getCustomImageOrdering();
            CustomComparator fileComparator = customImageOrdering != null ? new CustomComparator(customImageOrdering) : AlbumObjectOrderer.getComparator(imageOrdering, reverseOrder);
            AlbumObjectOrderer.sort2(objects, fileComparator, directoriesFirst ? new NameComparator(false) : null);
        } else if (this.getOrdering() != AlbumObject.Ordering.custom) {
            Comparator<AlbumObject> fileComparator = AlbumObjectOrderer.getComparator(this.getOrdering(), this.isReverseOrdering());
            Comparator<AlbumObject> directoryComparator = null;
            if (this.isFoldersFirst()) {
                directoryComparator = AlbumObjectOrderer.getComparator(this.getFolderOrdering(), this.isReverseFolderOrdering());
            }
            AlbumObjectOrderer.sort2(objects, fileComparator, directoryComparator);
        }
        return objects;
    }

    private static AlbumObject[] sort2(AlbumObject[] objects, Comparator<AlbumObject> objectComparator, Comparator folderComparator) {
        int i;
        if (folderComparator == null) {
            Arrays.sort(objects, objectComparator);
            return objects;
        }
        Arrays.sort(objects, new Comparator<AlbumObject>(){

            @Override
            public int compare(AlbumObject o1, AlbumObject o2) {
                int diff = 0;
                if (o1.isFolder()) {
                    --diff;
                }
                if (o2.isFolder()) {
                    ++diff;
                }
                return diff;
            }
        });
        for (i = 0; i < objects.length && objects[i].isFolder(); ++i) {
        }
        Arrays.sort(objects, 0, i, folderComparator);
        Arrays.sort(objects, i, objects.length, objectComparator);
        return objects;
    }

    private static Comparator<AlbumObject> getComparator(AlbumObject.Ordering ordering, boolean reverse) {
        switch (ordering) {
            case date: {
                return new LastModifiedDateComparator(reverse);
            }
            case name: {
                return new NameComparator(reverse);
            }
            case cameraDate: {
                return new CameraDateComparator(reverse);
            }
            case addedDate: {
                return new AddedDateComparator(reverse);
            }
            case rating: {
                return new RatingComparator(reverse);
            }
            case title: {
                return new TitleComparator(reverse);
            }
            case comment: {
                return new CommentComparator(reverse);
            }
        }
        return new SimpleFileNameComparator(reverse);
    }

    private static String get(String s1, String s2) {
        return s1.length() > 0 ? s1 : s2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public CommentComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = AlbumObjectOrderer.get(o1.getComment(), o1.getName()).compareToIgnoreCase(AlbumObjectOrderer.get(o2.getComment(), o2.getName()));
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TitleComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public TitleComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = AlbumObjectOrderer.get(o1.getTitle(), o1.getName()).compareToIgnoreCase(AlbumObjectOrderer.get(o2.getTitle(), o2.getName()));
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RatingComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public RatingComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = o1.getRating() - o2.getRating();
            return this.reverseOrder ? diff : -diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CameraDateComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public CameraDateComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            long diff;
            long d1 = o1.getMetadata().getCameraDate();
            long d2 = o2.getMetadata().getCameraDate();
            if (d1 == 0L) {
                d1 = o1.getLastModified();
            }
            if (d2 == 0L) {
                d2 = o2.getLastModified();
            }
            if ((diff = d1 - d2) < 0L) {
                diff = -1L;
            }
            if (diff > 0L) {
                diff = 1L;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return (int)diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddedDateComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public AddedDateComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            long diff = o1.getWhenAdded() - o2.getWhenAdded();
            if (diff < 0L) {
                diff = -1L;
            }
            if (diff > 0L) {
                diff = 1L;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return (int)diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LastModifiedDateComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public LastModifiedDateComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            long diff = o1.getFile().lastModified() - o2.getFile().lastModified();
            if (diff < 0L) {
                diff = -1L;
            }
            if (diff > 0L) {
                diff = 1L;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return (int)diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public NameComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            char[] c1 = o1.getName().toUpperCase().toCharArray();
            char[] c2 = o2.getName().toUpperCase().toCharArray();
            int diff = 0;
            int i = 0;
            int j = 0;
            while (i < c1.length && j < c2.length) {
                if (Character.isDigit(c1[i]) && Character.isDigit(c2[j])) {
                    long num2;
                    int startI = i;
                    int startJ = j;
                    while (i < c1.length && Character.isDigit(c1[i])) {
                        ++i;
                    }
                    while (j < c2.length && Character.isDigit(c2[j])) {
                        ++j;
                    }
                    long num1 = Long.parseLong(new String(c1, startI, i - startI));
                    if (num1 < (num2 = Long.parseLong(new String(c2, startJ, j - startJ)))) {
                        diff = -1;
                    } else if (num1 > num2) {
                        diff = 1;
                    }
                    if (diff == 0) continue;
                    break;
                }
                diff = c1[i] - c2[j];
                if (diff != 0) break;
                ++i;
                ++j;
            }
            if (diff == 0) {
                diff = c1.length - c2.length;
            }
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleFileNameComparator
    implements Comparator<AlbumObject> {
        boolean reverseOrder;

        public SimpleFileNameComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            int diff = o1.getName().compareToIgnoreCase(o2.getName());
            if (this.reverseOrder) {
                diff = -diff;
            }
            return diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomComparator
    implements Comparator<AlbumObject> {
        Comparator fileComparator;

        public CustomComparator(Comparator fileComparator) {
            this.fileComparator = fileComparator;
        }

        @Override
        public int compare(AlbumObject o1, AlbumObject o2) {
            return this.fileComparator.compare(o1.getFile(), o2.getFile());
        }
    }
}

