/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import se.datadosen.jalbum.Flag;

public class JFlagSelector
extends JComponent
implements ActionListener {
    protected Flag[] flags = Flag.values();
    protected JRadioButton[] flagButtons = new JRadioButton[this.flags.length];
    protected Vector<ActionListener> listeners;

    public JFlagSelector() {
        this.init();
    }

    public Flag getSelectedFlag() {
        for (int i = 0; i < this.flagButtons.length; ++i) {
            if (!this.flagButtons[i].isSelected()) continue;
            return this.flags[i];
        }
        return null;
    }

    public void setSelectedFlag(Flag flag) {
        this.flagButtons[flag.ordinal()].setSelected(true);
    }

    private void init() {
        this.setLayout(new FlowLayout(0, 0, 3));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.flagButtons.length; ++i) {
            JRadioButton button = new JRadioButton(this.flags[i].getIcon());
            button.setSelectedIcon(this.flags[i].getSelectedIcon());
            button.setBorder(BorderFactory.createEmptyBorder());
            button.setOpaque(false);
            button.setToolTipText(this.flags[i].toString());
            button.addActionListener(this);
            buttonGroup.add(button);
            this.flagButtons[i] = button;
            this.add(button);
        }
        this.validate();
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                this.listeners.elementAt(i).actionPerformed(e);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.fireActionOccured(e);
    }
}

