/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.VideoResolution;
import se.datadosen.util.Debug;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.IO;
import se.datadosen.util.Orientation;
import se.datadosen.util.Platform;
import se.datadosen.util.Replacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoProcessor {
    protected ProgressMonitor monitor;
    protected boolean allowPrompting = true;
    private static boolean enabled = true;
    protected int videoQuality = 50;
    protected VideoResolution videoResolution = VideoResolution.p480;
    protected Map<String, String> videoParameters;
    private boolean aborted = false;

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private VideoProcessor() {
    }

    public static VideoProcessor createInstance() {
        return Config.getConfig().isVideoSupported() && enabled ? new FfmpegVideoProcessor() : new VideoProcessor();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        VideoProcessor.enabled = enabled;
    }

    public boolean isFormatSupported(File inputVideo) {
        return this.isFormatSupported(IO.extensionOf(inputVideo).toLowerCase());
    }

    public boolean isFormatSupported(String ext) {
        return false;
    }

    public boolean isProcessing() {
        return false;
    }

    public Map<String, String> getVideoParameters() {
        if (this.videoParameters == null) {
            this.videoParameters = new LinkedHashMap<String, String>();
        }
        return this.videoParameters;
    }

    public void setVideoParameters(Map<String, String> videoParameters) {
        this.videoParameters = videoParameters;
    }

    public String getVideoSettingsHash() {
        return "";
    }

    public int getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(int videoQuality) {
        this.videoQuality = videoQuality;
    }

    public VideoResolution getVideoResolution() {
        return this.videoResolution;
    }

    public void setVideoResolution(VideoResolution videoResolution) {
        this.videoResolution = videoResolution;
    }

    public File getOutputVideoFile(File inputVideo, File outputDir) {
        return new File(outputDir, inputVideo.getName());
    }

    public File processVideo(File inputVideo, Orientation orientation, File outputDir) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File processVideo(File inputVideo, Orientation orientation, TimeCode clipStart, TimeCode clipLength, File outputDir) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VideoInfo createThumbnailFile(File inputVideo, File outputFile) throws IOException, OperationAbortedException {
        return this.createThumbnailFile(inputVideo, outputFile, 1);
    }

    public VideoInfo createThumbnailFile(File inputVideo, File outputFile, int secsFromStart) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VideoInfo createThumbnailFile(File inputVideo, File outputFile, TimeCode timeFromStart) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void abortProcessing() {
        this.aborted = true;
    }

    public void resetAbortedState() {
        this.aborted = false;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isAllowPrompting() {
        return this.allowPrompting;
    }

    public void setAllowPrompting(boolean allowPrompting) {
        this.allowPrompting = allowPrompting;
    }

    private static class AsyncStreamReader
    extends Thread {
        private StringWriter buffer;
        String lastLine;
        private InputStream inputStream;
        private String threadId;
        private boolean aborted = false;
        private ProgressMonitor monitor;

        public ProgressMonitor getMonitor() {
            return this.monitor;
        }

        public void setMonitor(ProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public AsyncStreamReader(InputStream inputStream, String threadId) {
            super(threadId);
            this.inputStream = inputStream;
            this.buffer = new StringWriter();
            this.threadId = threadId;
        }

        public String getBuffer() {
            return this.buffer.toString();
        }

        public String getErrorLine() {
            return this.lastLine;
        }

        public void run() {
            try {
                this.readCommandOutput();
            }
            catch (Exception ex) {
                if (ex instanceof OperationAbortedException) {
                    this.aborted = true;
                }
                System.err.println("Could not read command output: " + ex);
            }
        }

        private void readCommandOutput() throws IOException {
            BufferedReader bufOut = new BufferedReader(new InputStreamReader(this.inputStream));
            PrintWriter out = new PrintWriter(this.buffer);
            String line = null;
            long durationMillis = -1L;
            while (!this.aborted && (line = bufOut.readLine()) != null) {
                this.lastLine = line;
                out.println(line);
                Debug.log(line);
                line = line.trim();
                if (line.startsWith("Duration:")) {
                    durationMillis = this.toMillis(line.split(" |,")[1]);
                }
                if (!line.startsWith("frame=")) continue;
                try {
                    StringTokenizer tokens = new StringTokenizer(line);
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        if (!token.startsWith("time=")) continue;
                        long progressMillis = this.toMillis(token.substring("time=".length()));
                        if (this.monitor == null) continue;
                        if (progressMillis > durationMillis) {
                            progressMillis = durationMillis;
                        }
                        this.monitor.progress(progressMillis, durationMillis);
                    }
                }
                catch (NumberFormatException ex) {
                    System.err.println("Can't parse ffmpeg status line: " + line);
                }
            }
            bufOut.close();
            out.close();
        }

        private long toMillis(String hhmmssdd) {
            StringTokenizer tokens = new StringTokenizer(hhmmssdd, ":");
            long millis = 3600000 * Integer.parseInt(tokens.nextToken());
            millis += (long)(60000 * Integer.parseInt(tokens.nextToken()));
            return millis += (long)(1000.0f * Float.parseFloat(tokens.nextToken()));
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void abort() {
            this.aborted = true;
        }
    }

    private static class DisabledException
    extends RuntimeException {
        private DisabledException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FfmpegVideoProcessor
    extends VideoProcessor {
        private static final Map<String, String> supportedFormats = new HashMap<String, String>();
        private Process process;
        private static final int MIN_KEYFRAME_INTERVAL = 15;
        UserDecision userDecision;

        FfmpegVideoProcessor() {
        }

        @Override
        public boolean isFormatSupported(String ext) {
            if (!FfmpegVideoProcessor.isEnabled()) {
                return false;
            }
            boolean supported = Config.getConfig().getSupportedVideoFormats().contains(ext);
            return supported && this.isExecutableInstalled();
        }

        @Override
        public boolean isProcessing() {
            return this.process != null;
        }

        @Override
        public void abortProcessing() {
            super.abortProcessing();
            if (this.process != null) {
                this.process.destroy();
            }
        }

        @Override
        public File getOutputVideoFile(File inputVideo, File outputDir) {
            return new File(outputDir, IO.baseName(inputVideo) + ".mp4");
        }

        private Orientation getOrientationFromOutput(String output) {
            Orientation o = null;
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split(":");
                    if (tokens.length != 2 || !tokens[0].trim().equals("rotate")) continue;
                    int degrees = Integer.parseInt(tokens[1].trim());
                    switch (degrees) {
                        case 0: {
                            return Orientation.normal;
                        }
                        case 90: {
                            return Orientation.left;
                        }
                        case 180: {
                            return Orientation.upsideDown;
                        }
                        case 270: {
                            return Orientation.right;
                        }
                    }
                    return null;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return o;
        }

        private TimeCode getDurationFromOutput(String output) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("Duration:")) continue;
                    return new TimeCode(line.substring("Duration:".length()));
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            return null;
        }

        private Integer getgetFPSFromOutput(String output) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int start;
                    if (!(line = line.trim()).startsWith("Stream") || !line.contains("fps")) continue;
                    int fpsIndex = line.indexOf("fps");
                    for (start = fpsIndex - 1; start > 0 && (Character.isWhitespace(line.charAt(start)) || Character.isDigit(line.charAt(start))); --start) {
                    }
                    return Integer.valueOf(line.substring(start + 1, fpsIndex).trim());
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            return null;
        }

        private Dimension getDimensionFromOutput(String output) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("Stream")) continue;
                    String[] dim = line.split(",")[2].trim().split(" ")[0].split("x");
                    return new Dimension(Integer.parseInt(dim[0]), Integer.parseInt(dim[1]));
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            return null;
        }

        @Override
        public VideoInfo createThumbnailFile(File inputVideo, File outputFile, int secsFromStart) throws IOException, OperationAbortedException {
            return this.createThumbnailFile(inputVideo, outputFile, new TimeCode(secsFromStart));
        }

        @Override
        public synchronized VideoInfo createThumbnailFile(File inputVideo, File outputFile, TimeCode timeFromStart) throws IOException {
            try {
                return this.doCreateThumbnailFile(inputVideo, outputFile, timeFromStart);
            }
            catch (IOException ex) {
                return this.doCreateThumbnailFile(inputVideo, outputFile, new TimeCode(0));
            }
        }

        private VideoInfo doCreateThumbnailFile(File inputVideo, File outputFile, TimeCode timeFromStart) throws IOException {
            if (timeFromStart == null) {
                timeFromStart = new TimeCode(1);
            }
            File tmpOut = new File(outputFile.getParentFile(), IO.baseName(outputFile) + ".jpg");
            File exe = this.getExecutable();
            ArrayList<String> args = new ArrayList<String>();
            args.add(exe.getAbsolutePath());
            if (timeFromStart.getSecs() > 15) {
                args.add("-ss");
                TimeCode earlier = new TimeCode(timeFromStart.getSecs() - 15);
                args.add(earlier.toString());
                timeFromStart.setSecs(timeFromStart.getSecs() - earlier.getSecs());
            }
            args.add("-i");
            args.add(inputVideo.getAbsolutePath());
            args.add("-an");
            args.add("-ss");
            args.add(timeFromStart.toString());
            args.add("-vframes");
            args.add("1");
            args.add(tmpOut.getAbsolutePath());
            Debug.log("Executing " + FfmpegVideoProcessor.toCommandLine(args));
            this.process = new ProcessBuilder(new String[0]).command(args).start();
            AsyncStreamReader stdOutReader = new AsyncStreamReader(this.process.getInputStream(), "StdOut");
            AsyncStreamReader stdErrReader = new AsyncStreamReader(this.process.getErrorStream(), "StdErr");
            try {
                stdOutReader.start();
                stdErrReader.start();
                this.process.waitFor();
                if (this.process.exitValue() != 0) {
                    throw new IOException("Error during video thumbnail creation for " + inputVideo + ".\nffmpeg process terminated abnormally with code " + this.process.exitValue() + ":\n" + stdErrReader.getBuffer());
                }
                if (!tmpOut.exists()) {
                    throw new IOException("Error during video thumbnail creation for " + inputVideo + ".\nffmpeg process reports: " + stdErrReader.getErrorLine());
                }
                Tracer.getInstance().trace("processed video thumbnail");
                Orientation o = this.getOrientationFromOutput(stdErrReader.getBuffer());
                Integer fps = this.getgetFPSFromOutput(stdErrReader.getBuffer());
                TimeCode duration = this.getDurationFromOutput(stdErrReader.getBuffer());
                if (o == null) {
                    o = Orientation.normal;
                }
                Dimension dim = this.getDimensionFromOutput(stdErrReader.getBuffer());
                VideoInfo videoInfo = new VideoInfo(o, duration, fps, dim);
                Object var15_15 = null;
                this.process = null;
                stdOutReader.abort();
                stdErrReader.abort();
                return videoInfo;
            }
            catch (InterruptedException t) {
                try {
                    throw new IOException(t);
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    this.process = null;
                    stdOutReader.abort();
                    stdErrReader.abort();
                    throw throwable;
                }
            }
        }

        @Override
        public Map<String, String> getVideoParameters() {
            LinkedHashMap<String, String> vp = this.videoParameters;
            if (vp == null) {
                vp = this.videoParameters = new LinkedHashMap<String, String>();
                vp.put("-y", "");
                vp.put("-i", "$inputPath");
                if (this.videoResolution != VideoResolution.original) {
                    vp.put("-vf", "hqdn3d=1.5:1.5:6:6,scale=min(iw\\,trunc(iw*min($videoWidth/iw\\,$videoHeight/ih)*0.5)*2):min(ih\\,trunc(ih*min($videoWidth/iw\\,$videoHeight/ih)*0.5)*2),unsharp=3:3:1.0:3:3:0.0,$normalizeOrientation");
                } else {
                    vp.put("-vf", "$normalizeOrientation");
                }
                vp.put("-ss", "$clipStart");
                vp.put("-t", "$clipLength");
                vp.put("-threads", "0");
                vp.put("-acodec", "libvo_aacenc");
                vp.put("-b:a", "96k");
                vp.put("-ac", "2");
                vp.put("-ar", "44100");
                vp.put("-vcodec", "libx264");
                vp.put("-crf", "$videoQuality");
                vp.put("-metadata:s:v:0", "rotate=0");
                vp.put("-movflags", "faststart");
                vp.put("-pix_fmt", "yuv420p");
                vp.put("$outputPath", "");
            }
            return vp;
        }

        @Override
        public void setVideoParameters(Map<String, String> videoParameters) {
            if (videoParameters != null && videoParameters.isEmpty()) {
                videoParameters = null;
            }
            this.videoParameters = videoParameters;
        }

        @Override
        public File processVideo(File inputVideo, Orientation orientation, File outputDir) throws IOException, OperationAbortedException {
            return this.processVideo(inputVideo, orientation, null, null, outputDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File processVideo(File inputVideo, Orientation orientation, TimeCode clipStart, TimeCode clipLength, File outputDir) throws IOException, OperationAbortedException {
            Class<FfmpegVideoProcessor> clazz = FfmpegVideoProcessor.class;
            synchronized (FfmpegVideoProcessor.class) {
                if (this.isAborted()) {
                    throw new OperationAbortedException();
                }
                File outputVideo = this.getOutputVideoFile(inputVideo, outputDir);
                if (outputVideo.equals(inputVideo)) {
                    System.err.println("Skipping processing of " + inputVideo.getName() + ". Processing would overwrite original video. Don't output to image directory.");
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return outputVideo;
                }
                File exe = this.getExecutable();
                List<String> args = this.prepareArguments(exe, inputVideo, orientation, clipStart, clipLength, outputVideo);
                Debug.log("Executing " + FfmpegVideoProcessor.toCommandLine(args));
                Process myProcess = this.process = new ProcessBuilder(new String[0]).command(args).start();
                AsyncStreamReader stdOutReader = new AsyncStreamReader(this.process.getInputStream(), "StdOut");
                AsyncStreamReader stdErrReader = new AsyncStreamReader(this.process.getErrorStream(), "StdErr");
                stdErrReader.setMonitor(this.monitor);
                try {
                    try {
                        stdOutReader.start();
                        stdErrReader.start();
                        myProcess.waitFor();
                        if (myProcess.exitValue() != 0) {
                            outputVideo.delete();
                            if (!stdErrReader.isAborted()) {
                                System.err.println("Error during ffmpeg video processing:\n" + stdErrReader.getBuffer());
                                throw new IOException("Error during video creation. Please review video settings. \nffmpeg process terminated abnormally with code " + this.process.exitValue() + ":\n" + stdErrReader.getErrorLine());
                            }
                        }
                        if (stdErrReader.isAborted()) {
                            throw new OperationAbortedException();
                        }
                        Tracer.getInstance().trace("processed video");
                    }
                    catch (InterruptedException t) {
                        t.printStackTrace(System.out);
                        Object var15_14 = null;
                        this.process = null;
                        stdOutReader.abort();
                        stdErrReader.abort();
                    }
                    Object var15_13 = null;
                    this.process = null;
                    stdOutReader.abort();
                    stdErrReader.abort();
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    this.process = null;
                    stdOutReader.abort();
                    stdErrReader.abort();
                    throw throwable;
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return outputVideo;
            }
        }

        @Override
        public String getVideoSettingsHash() {
            return DigestUtil.md5(this.getVideoParametersAsString());
        }

        private String getVideoParametersAsString() {
            List<String> args = this.prepareArguments(null, null, Orientation.normal, null, null, null);
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
                builder.append(' ');
            }
            return builder.toString().trim();
        }

        private static String toCommandLine(List<String> args) {
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
                builder.append(' ');
            }
            return builder.toString().trim();
        }

        private List<String> prepareArguments(File executable, File inputVideo, Orientation orientation, TimeCode clipStart, TimeCode clipLength, File outputVideo) {
            String inputPath = "";
            String outputPath = "";
            ArrayList<String> args = new ArrayList<String>();
            Replacer r = new Replacer();
            if (inputVideo != null && outputVideo != null) {
                inputPath = inputVideo.getAbsolutePath();
                outputPath = outputVideo.getAbsolutePath();
                r.add("$fileName", inputVideo.getName());
                r.add("$label", IO.baseName(inputVideo));
            }
            r.add("$inputPath", inputPath);
            r.add("$outputPath", outputPath);
            r.add("$videoQuality", "" + (40 - 24 * this.videoQuality / 100));
            boolean rotated = orientation == Orientation.left || orientation == Orientation.right;
            r.add("$videoWidth", "" + (rotated ? this.videoResolution.getHeight() : this.videoResolution.getWidth()));
            r.add("$videoHeight", "" + (rotated ? this.videoResolution.getWidth() : this.videoResolution.getHeight()));
            r.add("$normalizeOrientation", this.normalize(orientation));
            r.add("$clipStart", clipStart != null ? clipStart.toString() : "");
            r.add("$clipLength", clipLength != null ? clipLength.toString() : "");
            if (executable != null) {
                args.add(executable.getAbsolutePath());
            }
            for (Map.Entry<String, String> e : this.getVideoParameters().entrySet()) {
                String key = r.replace(e.getKey()).trim();
                String value = r.replace(e.getValue()).trim();
                if ("-vf".equals(key) || "-ss".equals(key) || "-t".equals(key)) {
                    if (value.length() == 0) continue;
                    if (value.endsWith(",")) {
                        value = value.substring(0, value.length() - 1);
                    }
                }
                if (key.length() > 0) {
                    args.add(key);
                }
                if (value.length() <= 0) continue;
                args.add(value);
            }
            return args;
        }

        private String normalize(Orientation orientation) {
            switch (orientation) {
                case left: {
                    return "transpose=1";
                }
                case right: {
                    return "transpose=2";
                }
                case upsideDown: {
                    return "hflip,vflip";
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private File getExecutable() throws IOException, OperationAbortedException, DisabledException {
            final File exe = new File(MiniConfig.getMiniConfig().configDir, "bin/" + (Platform.isWindows() ? "ffmpeg.exe" : "ffmpeg"));
            if (exe.exists()) return exe;
            Class<FfmpegVideoProcessor> clazz = FfmpegVideoProcessor.class;
            synchronized (FfmpegVideoProcessor.class) {
                if (exe.exists()) return exe;
                final JAlbumFrame window = JAlbumContext.getInstance().getFrame();
                if (window == null || !this.isAllowPrompting()) {
                    throw new OperationAbortedException();
                }
                try {
                    Runnable r = new Runnable(){

                        public void run() {
                            int res = JOptionPane.showOptionDialog(window, Msg.get("ui.videoSupportInfo"), Msg.get("prefs.videoSupport"), 0, 1, null, new Object[]{Msg.get("add"), Msg.get("ui.disable")}, Msg.get("add"));
                            switch (res) {
                                case -1: {
                                    FfmpegVideoProcessor.this.userDecision = UserDecision.closed;
                                    break;
                                }
                                case 0: {
                                    FfmpegVideoProcessor.this.userDecision = UserDecision.add;
                                    break;
                                }
                                case 1: {
                                    FfmpegVideoProcessor.this.userDecision = UserDecision.disabled;
                                    VideoProcessor.setEnabled(false);
                                    window.preferencesWindow.videoSupported.setSelected(false);
                                    window.preferencesWindow.savePreferences();
                                    JOptionPane.showMessageDialog(window, Msg.get("ui.videoSupportDisabledInfo"), Msg.get("prefs.videoSupport"), 1);
                                }
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r.run();
                    } else {
                        this.userDecision = UserDecision.add;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                switch (this.userDecision) {
                    case closed: {
                        FfmpegVideoProcessor.setEnabled(false);
                        throw new OperationAbortedException();
                    }
                    case disabled: {
                        throw new DisabledException();
                    }
                    case add: {
                        String statusText = Msg.get("ui.downloadingVideoSupport", "jalbum.net");
                        System.out.println(statusText);
                        exe.getParentFile().mkdir();
                        if (SwingUtilities.isEventDispatchThread()) {
                            SlowOperation so = new SlowOperation(){

                                public void operation() throws Throwable {
                                    FfmpegVideoProcessor.this.downloadExecutable(exe);
                                }

                                public void abort() {
                                    this.interrupt();
                                    this.dialog.setVisible(enabled);
                                }
                            };
                            try {
                                so.launch(window, Msg.get("ui.downloadingVideoSupport", "jalbum.net"), Msg.get("prefs.videoSupport"));
                                break;
                            }
                            catch (Throwable ex) {
                                if (!(ex instanceof IOException)) throw new RuntimeException(ex);
                                throw (IOException)ex;
                            }
                        }
                        if (window != null) {
                            window.progressSpinner.workStarted();
                            window.statusBar.pushText(statusText);
                        }
                        try {
                            this.downloadExecutable(exe);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    window.albumExplorer.refreshAction.actionPerformed(null);
                                }
                            });
                            Object var8_8 = null;
                            if (window == null) return exe;
                            window.progressSpinner.workDone();
                            window.statusBar.popText(statusText);
                            break;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            if (window == null) throw throwable;
                            window.progressSpinner.workDone();
                            window.statusBar.popText(statusText);
                            throw throwable;
                        }
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return exe;
            }
        }

        private void downloadExecutable(File exe) throws IOException {
            try {
                IO.downloadZipFile(this.getExecutableURL("ffmpeg.zip"), exe.getParentFile());
            }
            catch (IOException ex) {
                try {
                    IO.downloadFile(this.getExecutableURL(Platform.isWindows() ? "ffmpeg.exe" : "ffmpeg"), exe.getParentFile());
                }
                catch (IOException ex2) {
                    exe.delete();
                    throw ex2;
                }
            }
            if (exe.length() < 0x500000L) {
                exe.delete();
                throw new IOException("Problem downloading video support from jalbum.net. Please try again later");
            }
            exe.setExecutable(true);
        }

        private URL getExecutableURL(String fileName) {
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            StringTokenizer tokens = new StringTokenizer(os);
            os = tokens.nextToken();
            try {
                return new URL(JAlbumSite.getInstance().getBinariesUrl() + "/" + os + "/" + arch + "/" + fileName);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private boolean isExecutableInstalled() {
            try {
                this.getExecutable();
                return true;
            }
            catch (IOException ex) {
                FfmpegVideoProcessor.setEnabled(false);
                Debug.showErrorDialog(null, ex);
                ex.printStackTrace(System.err);
            }
            catch (OperationAbortedException ex) {
            }
            catch (DisabledException disabledException) {
                // empty catch block
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum UserDecision {
            closed,
            disabled,
            add;

        }
    }

    public static interface ProgressMonitor {
        public void progress(long var1, long var3);
    }

    public static class VideoInfo {
        public Orientation orientation;
        public TimeCode duration;
        Integer fps;
        Dimension dim;

        public VideoInfo(Orientation orientation, TimeCode duration, Integer fps, Dimension dim) {
            this.orientation = orientation;
            this.duration = duration;
            this.fps = fps;
            this.dim = dim;
        }
    }
}

