/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AggDescriptor;
import borland.jbcl.dataset.CalcType;
import borland.jbcl.dataset.ColumnChangeListener;
import borland.jbcl.dataset.ColumnList;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.LookupDescriptor;
import borland.jbcl.dataset.PickListDescriptor;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.dataset.ValidationException;
import borland.jbcl.model.BigDecimalFormatter;
import borland.jbcl.model.BinaryFormatter;
import borland.jbcl.model.BooleanFormatter;
import borland.jbcl.model.ByteFormatter;
import borland.jbcl.model.DateFormatter;
import borland.jbcl.model.DoubleFormatter;
import borland.jbcl.model.IntegerFormatter;
import borland.jbcl.model.ItemEditMask;
import borland.jbcl.model.ItemEditMaskStr;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.model.LongFormatter;
import borland.jbcl.model.ShortFormatter;
import borland.jbcl.model.StringFormatter;
import borland.jbcl.model.TimeFormatter;
import borland.jbcl.model.TimestampFormatter;
import borland.jbcl.model.VariantFormatStr;
import borland.jbcl.model.VariantFormatter;
import borland.jbcl.util.Alignment;
import borland.jbcl.util.ErrorResponse;
import borland.jbcl.util.LocaleUtil;
import borland.jbcl.util.Variant;
import java.awt.Color;
import java.awt.Font;
import java.beans.Beans;
import java.util.Locale;
import java.util.TooManyListenersException;

public class Column
implements Cloneable {
    boolean rowId;
    int ordinal = -1;
    int dataType = 1;
    private StorageDataSet dataSet;
    boolean readOnly;
    boolean editable = true;
    private String tableName;
    private String name = "";
    private boolean required;
    private boolean nowDefault;
    private String defaultString;
    private String minString;
    private String maxString;
    private Variant defaultValue;
    private Variant minValue;
    private Variant maxValue;
    private int sqlType;
    private boolean persist;
    private int visible = -1;
    private int calcType;
    boolean currency;
    private PickListDescriptor pickListDescriptor;
    private LookupDescriptor lookupDescriptor;
    private ItemEditor itemEditor;
    private ItemPainter itemPainter;
    private Font font;
    private int alignment;
    private Color background;
    private Color foreground;
    private String caption;
    private String displayMask;
    private String exportDisplayMask;
    VariantFormatter formatter;
    VariantFormatter exportFormatter;
    private String editMask;
    private ItemEditMask editMasker;
    private String localeName = "";
    Locale locale;
    private int precision = -1;
    private int scale = -1;
    private int width = 0;
    private boolean fixedPrecision;
    private boolean hidden;
    private boolean searchable = true;
    private boolean resolvable = true;
    private AggDescriptor aggDescriptor;
    ColumnChangeListener changeListener;

    public Column() {
    }

    public Column(String string, String string2, int n) throws DataSetException {
        this();
        this.setCaption(string2);
        this.setColumnName(string);
        this.setDataType(n);
    }

    public final void setColumnName(String string) throws DataSetException {
        ColumnList columnList;
        this.structuralChange();
        if (this.dataSet != null && (columnList = this.dataSet.columnList) != null) {
            columnList.clearCache();
        }
        this.name = string;
    }

    public final String getColumnName() {
        return this.name;
    }

    public final void setTableName(String string) {
        this.tableName = string;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void setSqlType(int n) {
        this.sqlType = n;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public void setSearchable(boolean bl) {
        this.searchable = bl;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setResolvable(boolean bl) {
        this.resolvable = bl;
    }

    public boolean isResolvable() {
        return this.resolvable;
    }

    public final void setCalcType(int n) throws DataSetException {
        this.structuralChange();
        if (this.pickListDescriptor != null || !CalcType.valid(n)) {
            DataSetException.throwSetCalculatedFailure();
        }
        this.calcType = n;
        if (n != 0) {
            this.persist = true;
        }
    }

    public final int getCalcType() {
        return this.calcType;
    }

    public final void setAgg(AggDescriptor aggDescriptor) {
        this.aggDescriptor = aggDescriptor;
    }

    public final AggDescriptor getAgg() {
        return this.aggDescriptor;
    }

    public final void setReadOnly(boolean bl) throws DataSetException {
        this.structuralChange();
        this.readOnly = bl;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setEditable(boolean bl) throws DataSetException {
        this.structuralChange();
        this.editable = bl;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setRowId(boolean bl) {
        this.rowId = bl;
    }

    public final boolean isRowId() {
        return this.rowId;
    }

    private final Variant parsePropertyValue(Variant variant, String string) throws DataSetException {
        if (string == null) {
            return null;
        }
        if (string.length() > 0) {
            if (this.defaultString != null && this.defaultString == string && (this.defaultString.equalsIgnoreCase("now") || this.defaultString.equalsIgnoreCase("today")) && (this.dataType == 14 || this.dataType == 15 || this.dataType == 13)) {
                this.nowDefault = true;
                return null;
            }
            try {
                if (this.formatter != null) {
                    if (variant == null) {
                        variant = new Variant(this.dataType);
                    }
                    this.formatter.parse(string, variant);
                    Variant variant2 = variant;
                    return variant2;
                }
            }
            catch (Exception exception) {
                DataSetException.throwInvalidFormat(exception, this.name);
            }
        }
        return variant;
    }

    public final String getDefault() {
        return this.defaultString;
    }

    public final void setDefault(String string) throws DataSetException {
        this.structuralChange();
        this.defaultString = string;
        this.defaultValue = this.parsePropertyValue(this.defaultValue, string);
    }

    public final Variant getDefaultValue() {
        return this.defaultValue;
    }

    public final void setDefaultValue(Variant variant) throws DataSetException {
        this.structuralChange();
        this.defaultValue = (Variant)variant.clone();
    }

    public final void getDefault(Variant variant) {
        if (this.nowDefault) {
            switch (this.dataType) {
                case 13: {
                    variant.setDate(System.currentTimeMillis());
                    break;
                }
                case 14: {
                    variant.setTime(System.currentTimeMillis());
                    break;
                }
                case 15: {
                    variant.setTimestamp(System.currentTimeMillis());
                    break;
                }
            }
        } else if (this.defaultValue == null) {
            variant.setUnassignedNull();
        } else {
            variant.setVariant(this.defaultValue);
        }
    }

    public final void setDataType(int n) throws DataSetException {
        Column column = this;
        if (this.dataType != n || this.formatter == null) {
            if (this.dataSet != null) {
                if (!Beans.isDesignTime()) {
                    DataSetException.throwCannotChangeColumnDataType();
                }
                this.dataType = n;
                this.dataSet.changeColumn(this.getOrdinal(), this);
                try {
                    column = this.dataSet.getColumn(this.getColumnName());
                    if (column == null) {
                        column = this;
                    }
                }
                catch (Exception exception) {}
            } else {
                this.dataType = n;
            }
            column.initColumn();
            if (n >= 2 && n <= 10) {
                column.setAlignment(35);
            } else {
                column.setAlignment(33);
            }
        }
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final void setPickList(PickListDescriptor pickListDescriptor) {
        this.pickListDescriptor = pickListDescriptor;
    }

    public final PickListDescriptor getPickList() {
        return this.pickListDescriptor;
    }

    public final void setPersist(boolean bl) {
        this.persist = bl;
    }

    public final boolean isPersist() {
        return this.persist;
    }

    public final void setVisible(int n) {
        this.visible = n;
    }

    public final int getVisible() {
        return this.visible;
    }

    public final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    final void initColumn() throws DataSetException {
        this.formatter = null;
        this.editMasker = null;
        this.nowDefault = false;
        if (this.displayMask != null && this.displayMask.length() != 0) {
            this.formatter = new VariantFormatStr(this.displayMask, this.dataType, this.getLocale(), this.getScale(), this.getPrecision(), this.isCurrency());
        }
        switch (this.dataType) {
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                if (this.formatter != null) break;
                this.formatter = new VariantFormatStr(null, this.dataType, this.getLocale(), this.getScale(), this.getPrecision(), this.isCurrency());
                break;
            }
            case 16: {
                if (this.formatter != null) break;
                this.formatter = new StringFormatter();
                break;
            }
            case 4: {
                if (this.formatter != null) break;
                this.formatter = new IntegerFormatter(this.dataType);
                break;
            }
            case 3: {
                if (this.formatter != null) break;
                this.formatter = new ShortFormatter(this.dataType);
                break;
            }
            case 2: {
                if (this.formatter != null) break;
                this.formatter = new ByteFormatter(this.dataType);
                break;
            }
            case 5: {
                if (this.formatter != null) break;
                this.formatter = new LongFormatter();
                break;
            }
            case 11: {
                if (this.formatter == null) {
                    this.formatter = new BooleanFormatter();
                }
            }
            case 12: {
                if (this.formatter != null) break;
                this.formatter = new BinaryFormatter();
                break;
            }
            case 1: 
            case 17: 
            case 18: {
                break;
            }
        }
        this.setDefault(this.defaultString);
        this.setMin(this.minString);
        this.setMax(this.maxString);
        if (this.editMasker == null && this.editMask != null && this.editMask.length() != 0) {
            this.setEditMask(this.editMask);
        }
    }

    private final void createExportFormatter() {
        VariantFormatter variantFormatter = null;
        switch (this.dataType) {
            case 13: {
                variantFormatter = new DateFormatter();
                break;
            }
            case 14: {
                variantFormatter = new TimeFormatter();
                break;
            }
            case 15: {
                variantFormatter = new TimestampFormatter();
                break;
            }
            case 16: {
                variantFormatter = new StringFormatter();
                break;
            }
            case 10: {
                variantFormatter = new BigDecimalFormatter(this.getScale());
                break;
            }
            case 4: {
                variantFormatter = new IntegerFormatter(this.dataType);
                break;
            }
            case 2: {
                variantFormatter = new ByteFormatter(this.dataType);
                break;
            }
            case 3: {
                variantFormatter = new ShortFormatter(this.dataType);
                break;
            }
            case 11: {
                variantFormatter = new BooleanFormatter();
                break;
            }
            case 5: {
                variantFormatter = new LongFormatter();
                break;
            }
            case 6: 
            case 7: {
                variantFormatter = new DoubleFormatter(this.dataType);
                break;
            }
            case 12: {
                variantFormatter = new BinaryFormatter();
                break;
            }
            case 17: {
                variantFormatter = null;
                break;
            }
        }
        this.setExportFormatter(variantFormatter);
    }

    public final boolean isSortable() {
        return this.dataType != 12;
    }

    public final boolean isTextual() {
        switch (this.dataType) {
            case 12: 
            case 17: {
                return false;
            }
        }
        return true;
    }

    public final void setRequired(boolean bl) throws DataSetException {
        this.structuralChange();
        this.required = bl;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final String getMin() {
        return this.minString;
    }

    public final void setMin(String string) throws DataSetException {
        this.structuralChange();
        this.minString = string;
        this.minValue = this.parsePropertyValue(this.minValue, string);
    }

    public final String getMax() {
        return this.maxString;
    }

    public final void setMax(String string) throws DataSetException {
        this.structuralChange();
        this.maxString = string;
        this.maxValue = this.parsePropertyValue(this.maxValue, string);
    }

    public final Variant getMinValue() {
        return this.minValue;
    }

    public final void setMinValue(Variant variant) throws DataSetException {
        this.structuralChange();
        this.minValue = (Variant)variant.clone();
    }

    public final Variant getMaxValue() {
        return this.maxValue;
    }

    public final void setMaxValue(Variant variant) throws DataSetException {
        this.structuralChange();
        this.maxValue = (Variant)variant.clone();
    }

    public final void setCurrency(boolean bl) throws DataSetException {
        this.currency = bl;
        this.initColumn();
    }

    public final boolean isCurrency() {
        return this.currency;
    }

    public final void setItemEditor(ItemEditor itemEditor) {
        this.itemEditor = itemEditor;
    }

    public final ItemEditor getItemEditor() {
        return this.itemEditor;
    }

    public final void setItemPainter(ItemPainter itemPainter) {
        this.itemPainter = itemPainter;
    }

    public final ItemPainter getItemPainter() {
        return this.itemPainter;
    }

    public final Font getFont() {
        return this.font;
    }

    public final void setFont(Font font) {
        this.font = font;
    }

    public final int getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(int n) {
        if (!Alignment.valid(n)) {
            this.invalidArgument();
        }
        this.alignment = n;
    }

    public final Color getBackground() {
        return this.background;
    }

    public final void setBackground(Color color) {
        this.background = color;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    public final void setForeground(Color color) {
        this.foreground = color;
    }

    public final String getCaption() {
        return this.caption == null ? this.name : this.caption;
    }

    public final void setCaption(String string) {
        this.caption = string;
    }

    public final String getDisplayMask() {
        return this.displayMask;
    }

    public final void setDisplayMask(String string) {
        this.displayMask = string;
        this.setFormatter(new VariantFormatStr(string, this.dataType, this.getLocale(), this.getScale(), this.getPrecision(), this.isCurrency()));
    }

    public final void setDisplayMask() throws DataSetException {
        this.displayMask = null;
        this.initColumn();
    }

    public final String getExportDisplayMask() {
        return this.exportDisplayMask;
    }

    public final void setExportDisplayMask(String string) {
        this.exportDisplayMask = string;
        this.setExportFormatter(new VariantFormatStr(string, this.dataType, this.getLocale(), this.getScale(), this.getPrecision(), this.isCurrency()));
    }

    public final void setExportDisplayMask() throws DataSetException {
        this.exportDisplayMask = null;
        this.initColumn();
    }

    public final VariantFormatter getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(VariantFormatter variantFormatter) {
        this.formatter = variantFormatter;
    }

    public final VariantFormatter getExportFormatter() {
        if (this.exportFormatter == null) {
            this.createExportFormatter();
        }
        return this.exportFormatter;
    }

    public final void setExportFormatter(VariantFormatter variantFormatter) {
        this.exportFormatter = variantFormatter;
    }

    public final String getEditMask() {
        return this.editMask;
    }

    public void setEditMask(String string) {
        this.editMask = string;
        this.setEditMasker(new ItemEditMaskStr(string, new VariantFormatStr(string, this.dataType, this.getLocale(), this.getScale(), this.getPrecision(), this.isCurrency()), this.dataType, this.locale));
    }

    public final void setEditMask() throws DataSetException {
        this.editMask = null;
        this.initColumn();
    }

    public final ItemEditMask getEditMasker() {
        return this.editMasker;
    }

    public void setEditMasker(ItemEditMask itemEditMask) {
        this.editMasker = itemEditMask;
    }

    public final String getLocaleName() {
        return this.localeName;
    }

    public final void setLocaleName(String string) throws DataSetException {
        this.localeName = string;
        Locale locale = LocaleUtil.getLocale(string);
        this.setLocale(locale);
    }

    public final void setLocaleName() throws DataSetException {
        this.setLocaleName(null);
    }

    public final Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.dataSet != null) {
            return this.dataSet.getLocale();
        }
        return null;
    }

    public final void setLocale(Locale locale) throws DataSetException {
        this.locale = locale;
        this.localeName = locale != null ? locale.toString() : null;
        this.initColumn();
    }

    public final void setLocale(String string) throws DataSetException {
        this.setLocaleName(string);
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int n) throws DataSetException {
        this.structuralChange();
        if (n < -1) {
            this.invalidArgument();
        }
        this.precision = n;
    }

    public final int getScale() {
        return this.scale;
    }

    public final void setScale(int n) throws DataSetException {
        if (this.scale != n) {
            this.scale = n;
            if (n < -1) {
                this.invalidArgument();
            }
            this.initColumn();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        if (n < 0) {
            this.invalidArgument();
        }
        this.width = n;
    }

    public boolean isFixedPrecision() {
        return this.fixedPrecision;
    }

    public void setFixedPrecision(boolean bl) {
        this.fixedPrecision = bl;
    }

    public Object clone() {
        try {
            Column column = (Column)super.clone();
            column.dataSet = null;
            Column column2 = column;
            return column2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Object var2_4 = null;
            return var2_4;
        }
    }

    public Column copy() {
        try {
            Column column;
            Column column2 = column = (Column)super.clone();
            return column2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Column column = null;
            return column;
        }
    }

    final void bindDataSet(StorageDataSet storageDataSet) {
        this.dataSet = storageDataSet;
    }

    private final void structuralChange() throws DataSetException {
        if (this.dataSet != null) {
            this.dataSet.columnStructuralChange();
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean hasValidations() {
        return this.changeListener != null || this.readOnly || this.minValue != null || this.maxValue != null || this.calcType != 0 || this.dataType == 16 && this.precision > 0;
    }

    public void validate(DataSet dataSet, Variant variant) throws DataSetException {
        if (dataSet != null && dataSet.getStorageDataSet().editListener != null) {
            while (true) {
                try {
                    this.performValidation(dataSet, variant);
                }
                catch (DataSetException dataSetException) {
                    ErrorResponse errorResponse;
                    if ((errorResponse = dataSet.getStorageDataSet().processEditError(dataSet, this, variant, dataSetException)).isRetry()) continue;
                    if (errorResponse.isAbort()) {
                        throw dataSetException;
                    }
                    return;
                }
                break;
            }
            return;
        }
        this.performValidation(dataSet, variant);
    }

    public final String format(Variant variant) {
        if (this.formatter != null) {
            return this.formatter.format(variant);
        }
        return variant.toString();
    }

    private void performValidation(DataSet dataSet, Variant variant) throws DataSetException {
        String string;
        if (this.changeListener != null) {
            try {
                this.changeListener.validate(dataSet, this, variant);
            }
            catch (Exception exception) {
                ValidationException.throwInvalidColumnValue(exception.getMessage());
            }
        }
        this.startEdit(false);
        if (this.minValue != null && this.minValue.compareTo(variant) > 0) {
            ValidationException.throwLessThanMin(this, this.format(variant), this.format(this.minValue));
        }
        if (this.maxValue != null && this.maxValue.compareTo(variant) < 0) {
            ValidationException.throwGreaterThanMax(this, this.format(variant), this.format(this.maxValue));
        }
        if (this.dataType == 16 && this.precision > 0 && (string = variant.getString()) != null && string.length() > this.precision) {
            ValidationException.throwInvalidPrecision(this);
        }
    }

    void startEdit(boolean bl) throws ValidationException {
        if (this.readOnly || this.calcType != 0 || bl && !this.editable) {
            ValidationException.throwReadOnlyColumn(this);
        }
    }

    public void addColumnChangeListener(ColumnChangeListener columnChangeListener) throws DataSetException, TooManyListenersException {
        this.structuralChange();
        if (columnChangeListener == null) {
            this.invalidArgument();
        }
        if (this.changeListener != null) {
            throw new TooManyListenersException();
        }
        this.changeListener = columnChangeListener;
    }

    public synchronized void removeColumnChangeListener(ColumnChangeListener columnChangeListener) {
        if (this.changeListener != columnChangeListener) {
            throw new IllegalArgumentException();
        }
        this.changeListener = null;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Column [").concat(String.valueOf(this.name))).concat(String.valueOf("] is type "))).concat(String.valueOf(Variant.typeName(this.dataType)))).concat(String.valueOf(", sqlType "))).concat(String.valueOf(this.sqlType))).concat(String.valueOf(", ordinal "))).concat(String.valueOf(this.ordinal))).concat(String.valueOf(" in dataset "))).concat(String.valueOf(this.dataSet))).concat(String.valueOf("\r\n"))).concat(String.valueOf(super.toString()));
    }

    void reconcile(Column column, boolean bl) throws DataSetException {
        this.dataType = column.dataType;
        if (bl) {
            this.precision = column.precision;
            this.scale = column.scale;
            this.searchable = column.searchable;
        } else {
            if (this.precision == -1) {
                this.precision = column.precision;
            }
            if (this.scale == -1) {
                this.scale = column.scale;
            }
        }
        this.setSqlType(column.sqlType);
        this.initColumn();
    }

    private void invalidArgument() {
        throw new IllegalArgumentException();
    }
}

