/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.Index;
import borland.jbcl.dataset.MatrixData;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.util.Variant;

public abstract class DirectIndex
extends Index {
    protected Column[] locateColumns;
    protected int locateColumnCount;
    protected int locatePartialIndex;
    protected boolean locateCaseInsensitive;
    int visibleMask;
    int invisibleMask;
    SortDescriptor descriptor;
    RowFilterListener rowFilterListener;
    MatrixData data;

    public DirectIndex(MatrixData matrixData) {
        this.data = matrixData;
    }

    public abstract void delete(int var1) throws DataSetException;

    public abstract boolean add(int var1) throws DataSetException;

    public abstract void load(int var1) throws DataSetException;

    public abstract void prepareReplace(int var1);

    public abstract void replace(int var1) throws DataSetException;

    public abstract void loadSearchValues(Variant[] var1) throws DataSetException;

    public abstract int locate(int var1, int var2) throws DataSetException;

    public int locate(int n, Column[] columnArray, Variant[] variantArray, int n2) throws DataSetException {
        if (this.lastRow() < 0) {
            return -1;
        }
        if ((n2 & 0x100) == 0) {
            if ((n2 & 0x20) != 0) {
                n = 0;
            } else if ((n2 & 0x40) != 0) {
                n = this.lastRow();
            }
        }
        Column[] columnArray2 = columnArray;
        boolean bl = (n2 & 0x80) != 0 && this.locateColumns == columnArray2;
        this.locateColumns = columnArray2;
        this.locateColumnCount = this.locateColumns.length;
        if (!bl) {
            this.loadSearchValues(variantArray);
        }
        int n3 = this.locateColumnCount - 1;
        if ((1 & n2) != 0) {
            if (this.locateColumns[n3].getDataType() != 16) {
                DataSetException.throwPartialSearchForString();
            }
            this.locatePartialIndex = n3;
        } else {
            this.locatePartialIndex = -1;
        }
        this.locateCaseInsensitive = (8 & n2) != 0;
        return this.locate(n, n2);
    }

    void sort() {
    }

    public void markStatus(int n, int n2, boolean bl) throws DataSetException {
        int n3 = this.internalRow(n);
        if (bl) {
            this.data.setStatus(n3, this.data.getStatus(n3) | n2);
        } else {
            this.data.setStatus(n3, this.data.getStatus(n3) & ~n2);
        }
    }

    public void resolvePending(boolean bl, int n) throws DataSetException {
        int n2 = this.lastRow() + 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.internalRow(i);
            int n4 = this.data.getStatus(n3);
            if ((n4 & 0x200) == 0) continue;
            n4 &= 0xFFFFFDFF;
            if (bl) {
                n4 |= n;
            }
            this.data.setStatus(n3, n4);
        }
    }

    public boolean isMaintained() {
        return true;
    }
}

