/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.NullState;
import borland.jbcl.dataset.StringColumn;
import borland.jbcl.util.Variant;
import java.text.CollationKey;
import java.text.Collator;
import java.text.RuleBasedCollator;

class LocaleStringColumn
extends StringColumn {
    RuleBasedCollator collator;
    CollationKey[] secKeys;
    CollationKey[] terKeys;
    int pivotDataRow;

    public LocaleStringColumn(NullState nullState, Column column) {
        super(nullState);
        this.collator = (RuleBasedCollator)Collator.getInstance(column.getLocale());
        this.collator.setDecomposition(2);
        this.secKeys = null;
        this.terKeys = null;
    }

    final int compare(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        return this.terKeys[n].compareTo(this.terKeys[n2]);
    }

    final int compareIgnoreCase(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        return this.secKeys[n].compareTo(this.secKeys[n2]);
    }

    void setPivot(int[] nArray, int n) {
        this.indexVector = nArray;
        this.pivotValue = this.vector[n];
        this.pivotDataRow = n;
    }

    int forwardCompare(int n, boolean bl) {
        if (bl) {
            while ((this.comp = this.secKeys[this.indexVector[++n]].compareTo(this.secKeys[this.pivotDataRow])) < 0) {
            }
        } else {
            while ((this.comp = this.terKeys[this.indexVector[++n]].compareTo(this.terKeys[this.pivotDataRow])) < 0) {
            }
        }
        return n;
    }

    int reverseCompare(int n, boolean bl) {
        if (bl) {
            while ((this.comp = this.secKeys[this.indexVector[--n]].compareTo(this.secKeys[this.pivotDataRow])) > 0) {
            }
        } else {
            while ((this.comp = this.terKeys[this.indexVector[--n]].compareTo(this.terKeys[this.pivotDataRow])) > 0) {
            }
        }
        return n;
    }

    protected void grow(int n) {
        int n2 = this.vectorLength;
        super.grow(n);
        if (this.secKeys != null) {
            CollationKey[] collationKeyArray = new CollationKey[n];
            CollationKey[] collationKeyArray2 = new CollationKey[n];
            System.arraycopy(this.secKeys, 0, collationKeyArray, 0, n2);
            System.arraycopy(this.terKeys, 0, collationKeyArray2, 0, n2);
            this.secKeys = collationKeyArray;
            this.terKeys = collationKeyArray2;
        }
    }

    void setVariant(int n, Variant variant) {
        super.setVariant(n, variant);
        if (this.secKeys != null) {
            this.collator.setStrength(1);
            this.secKeys[n] = this.collator.getCollationKey(this.vector[n]);
            this.collator.setStrength(2);
            this.terKeys[n] = this.collator.getCollationKey(this.vector[n]);
        }
    }

    void createCollationKeys() {
        if (this.secKeys == null) {
            int n;
            this.secKeys = new CollationKey[this.vectorLength];
            this.terKeys = new CollationKey[this.vectorLength];
            this.collator.setStrength(1);
            for (n = 1; n < this.vectorLength; ++n) {
                this.secKeys[n] = this.collator.getCollationKey(this.vector[n]);
            }
            this.collator.setStrength(2);
            for (n = 1; n < this.vectorLength; ++n) {
                this.terKeys[n] = this.collator.getCollationKey(this.vector[n]);
            }
        }
    }
}

