/*
Copyright (c) 2003 by Radim HSN Kolar (hsn@cybermail.net)

You may copy or modify this file in any manner you wish, provided
that this notice is always included, and that you hold the author
harmless for any loss or damage resulting from the installation or
use of this software.

		     This is a free software.  Be creative. 
		    Let me know of any bugs and suggestions.

Version 1.0rc3
*/
import java.net.URLStreamHandlerFactory;
import java.net.URLStreamHandler;
import java.net.URLConnection;
import java.net.URL;
import java.io.IOException;

/** 
 * @author Radim Kolar
 * @version 1.0 
 */
public class FSPStreamHandler extends URLStreamHandler implements URLStreamHandlerFactory 
{
    /* factory interface */
    /**  creates URLStreamHandler instance for FSP protocol.
     * <p>
     * @param protocol requested protocol. Only FSP is supported.
     * @return  FSPStreamHandler instance or null if protocol is not FSP.
     * @since 1.0
     */
    public  URLStreamHandler createURLStreamHandler(String protocol)
    {
	if(protocol==null) return  null;
	if(protocol.equalsIgnoreCase("fsp"))
	    return new FSPStreamHandler();
	return null;
    }

    /** opens a FSP connection.
     *
     * @since 1.0
     * @param u url to be opened
     * @return null
     */
     protected URLConnection openConnection(URL u) throws IOException
     {
	 return null;
     }
}
