import java.io.*;
import java.net.*;
import java.util.*;

public class ftpfactory extends downloadfactory
{
public static boolean nopasv; // disable ftp passive mode?

/* control connection to server */
private DataInputStream is;
private DataOutputStream os;
private Socket s;

/* public constructor */
ftpfactory(String URL,qfile qf,boolean dirc) throws java.net.MalformedURLException
{
    super(URL,qf,dirc);
}

/* this procedure should modify protected variables as result */
protected void processRequest(InetAddress server,int port,boolean nocache) throws IOException,java.net.MalformedURLException
{
 /* connect to server */
 connect(server,port);  
 /* precist httprc */
 if(!login(null,null)) { this.rc=DOWNLOAD_BUSY;return;}
 System.out.println("[INFO] FTP login ok");
 
 setBinary(true);
 
 /* setting whole filesize to contentSize is okay, we will reduce it
  * later if server supports resume */
 contentSize=getFilesize(url.getFile());

 if(contentSize>0) fileSize=contentSize;

 FTPfileTransfer(url.getFile());
}

private final long getFilesize(String filename) throws IOException
{
 long sz=0;
 String line;
 sendCommand("SIZE "+filename);
 line=getReply();
 if(line.startsWith("213 "))
    sz=Long.valueOf(line.substring(4).trim()).longValue();
 return sz;
}

private final void FTPfileTransfer(String filename) throws IOException
{
 // data socket
 Socket data=null;
 ServerSocket portdata=null;
 datain=null;
 int rc;
 String line;

 /* establish a data connection */
 /* 1. PASV command */
 if(nopasv==true)
     line="NOPASV";
 else
   {
     sendCommand("PASV");
     line=getReply();
   }
   
 if(line.startsWith("227 "))
  {
   int l;
   int r;
   
   l=line.lastIndexOf('(');
   r=line.lastIndexOf(')');
   
   if(l>=4 && r>=16 && r>l )
    {
      StringTokenizer st=new StringTokenizer(line.substring(l+1,r),", ");
      if(st.countTokens()!=6) dmachine.log_err("Not 6 tokens in PASV reply.");
      else
      {
       String ha="";
       for(int i=1;i<=3;i++)
        {
	  ha+=st.nextToken()+".";
	}
       ha+=st.nextToken();
       try
       {
        data=new Socket(InetAddress.getByName(ha),Integer.valueOf(st.nextToken()).intValue()*256+Integer.valueOf(st.nextToken()).intValue());
       }
       catch (IOException ignore) { dmachine.log_err("Connect to FTP server data socket failed");data=null;}
      }
    } else dmachine.log_err("Malformed PASV reply: "+line);
  }
  
  if(data==null)
  {
    /* port mode */
    portdata=new ServerSocket(0);
    InetAddress me=s.getLocalAddress();
    int p1=portdata.getLocalPort()/256;
    int p2=portdata.getLocalPort()-256*p1;
    sendCommand("PORT "+me.getHostAddress().replace('.',',')+","+p1+","+p2);
    p2=getResponse();
    if(p2>300 || p2<200) { 
          this.rc=DOWNLOAD_ERR;
	  throw new EOFException("PORT COMMAND failed. rc="+p2);
    }
  }
 /* 2. REST command */
 if(havebytes>0)
  {
     sendCommand("REST "+havebytes);
     rc=getResponse();
     if(rc<400) { 
                              /* continue OK */
                              this.rc=DOWNLOAD_RESUME;
			      if(contentSize>0) contentSize-=havebytes;
			      }
  }
 /* 3. RETR COMMAND */
 sendCommand("RETR "+filename);
 rc=getResponse();
 if(rc>299)
 {
   this.rc=DOWNLOAD_FATAL;
   dmachine.log_fatal("FTP RETR Error "+rc+" when loading "+qf.getName()); 
   data.close();
   os.close(); 
   return;
 }
   
 /* OPEN DATAINPUT CONNECTION */
 if(portdata!=null) { 
   /* listen on socket */
   data=portdata.accept();
   portdata.close();
 }
 
 if(data!=null) datain=new DataInputStream(data.getInputStream());
}

private final void connect(String hostname) throws IOException
{
 connect(InetAddress.getByName(hostname),21);
}

private final void connect(InetAddress hostname,int port) throws IOException
{
 close();
 s=new Socket(hostname,port);
 is=new DataInputStream(new BufferedInputStream(s.getInputStream(),4096));
 os=new DataOutputStream(new BufferedOutputStream(s.getOutputStream(),4096));
 if(getResponse()>299)
  {
   close();
   this.rc=DOWNLOAD_ERR;
   throw new EOFException("No or bad welcome banner");
  }
}

private final boolean login(String username,String password) throws IOException
{
 int rc;
 if(username==null) username="anonymous";
 if(password==null) password="dmachine@";

 /* username */
 sendCommand("USER "+username);
 rc=getResponse();
 if(rc>=400) {
   dmachine.log_err("FTP USER login failed, rc="+rc);
   return false;
 }
 if(rc==230) return true;
 if(rc!=331) return false;
 
 /* password */
 sendCommand("PASS "+password);
 rc=getResponse();
 if(rc>299) {
   dmachine.log_err("FTP PASS login failed, rc="+rc);
   return false;
 }
 
 return true;
}

private final void setBinary(boolean binary) throws IOException
{
 if(binary) sendCommand("TYPE I"); else
  sendCommand("TYPE A");
 int rc=getResponse();
 if(rc>=200 && rc<300) return;
 close();
 throw new EOFException("Can not set binary transfer mode to "+binary+". rc="+rc);
}

private final void sendCommand(String command) throws IOException
{
  os.writeBytes(command);
  os.writeBytes("\r\n");
  os.flush();
}

private final String getReply() throws IOException
{
 String line;
 
 line=is.readLine();
 if(line==null) throw new EOFException();
 return line;
}

private final int getResponse() throws IOException
{
 String line;
 String code=null;
 int err;
 
 while(true)
 {
 
  line=is.readLine();
  if(line==null) throw new EOFException();
  if(code!=null) 
    if(!line.startsWith(code)) continue;
  if(line.charAt(3)=='-') { code=line.substring(0,3)+" ";continue; }
  try
  {
    err=Integer.valueOf(line.substring(0,3)).intValue();
  }
  catch (Exception e) { throw new EOFException(e.toString());}
  return err;
 }
}
 
protected synchronized void close()
{
 super.close(); // close data connection
 if(s!=null) 
     try
     {
       sendCommand("QUIT");
       s.close();
     }
     catch (IOException ignore) {};
 s=null;
 is=null;
 os=null;
}

/*
public static void main(String argv[]) throws IOException
{
 ftpfactory f;
 qfile qf;
 f=new ftpfactory();
 qf=new qfile("mailcap","/etc/Zmailcap");
 f.connect("127.0.0.1");
 if(f.login("hsn","ZZZZZZZZ")) System.out.println("LOGIN OK.");
 f.setBinary(true);
 f.sendCommand("STAT");
 f.getResponse();
 System.out.println("filesize="+f.getFilesize("/etc/mailcap"));
 f.fileTransfer("/etc/mailcap",0,qf);
 f.close();
}
*/

} /* class */
