/*
Copyright (c) 2003 by Radim HSN Kolar (hsn@cybermail.net)

You may copy or modify this file in any manner you wish, provided
that this notice is always included, and that you hold the author
harmless for any loss or damage resulting from the installation or
use of this software.

		     This is a free software.  Be creative. 
		    Let me know of any bugs and suggestions.

Version 1.0rc3
*/
import  java.net.URL;
import  java.io.IOException;
import  java.util.Date;

/** class for read-only operations on FSP URL.
 *
 * @version 1.0
 * @author Radim Kolar
 */ 
public class FSPURLConnection extends java.net.URLConnection
{
   /* FSP session */
   private FSPsession ses;
   private FSPstat stat;

   /** creates a new URL connection with FSP protocol.
    * 
    * @since 1.0
    */
   FSPURLConnection(URL u)
   {
       super(u);
   }
   
   /** gets file status from FSP server. 
    *
    * @since 1.0
    */
   public void connect() throws IOException
   {
       if(connected) return;
       ses=new FSPsession(url.getHost(),url.getPort());
       stat=FSPutil.stat(ses,url.getFile());
       connected=true;
       return;
   }

   /** returns value of specified header field.
    * <p>
    * Only "last-modified" and "Content-length" are supported now.
    *
    * @since 1.0
    */ 
   public String getHeaderField(String name)
   {
       if(!connected) return null;
       if(stat==null) return null;
       if(name.equalsIgnoreCase("last-modified"))
       {
	   return new Date(stat.lastmod).toString();
       }
       if(name.equalsIgnoreCase("content-length"))
       {
	   return ""+stat.length;
       }
       return null;
   }

   /** returns input stream of file from FSPserver.
    *
    * @since 1.0
    */
   public java.io.InputStream getInputStream() throws IOException 
   {
       if(!connected) throw new IOException("Not connected");
       if(stat==null) throw new IOException("File not found");
       if(stat.type==FSPstat.RDTYPE_DIR)
	   throw new IOException("Is a directory");

       return new FSPInputStream(ses,url.getFile());
   }
       
	
}
