/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import net.fsp.Handler;

public class dmachine {
    public static final String VERSION = "0.23";
    public static final String NAME = "Download Machine";
    public static final String COPYRIGHT = "Copyright (c) 1999-2009 Radim Kolar. Open Source Software; There is NO warranty.\nSee the GNU General Public Licence version 2 or later for copying conditions.";
    public static final Object startmon = new Object();
    public static InetAddress http_proxyserver;
    public static String http_auth;
    public static int http_proxyport;
    public static boolean http_proxydefined;
    public static int http_resume;
    public static InetAddress ftp_proxyserver;
    public static String ftp_auth;
    public static int ftp_proxyport;
    public static boolean ftp_proxydefined;
    public static int ftp_resume;
    public static int exitonempty;
    public static boolean keepemptyqueues;
    public static boolean removefromqueues;
    public static queuefile[] queue_files;
    public static queuefile dropdir_queue;
    public static String alive_flag;
    public static String download_dir;
    public static String tmp_dir;
    public static String attic_dir;
    public static String drop_dir;
    public static boolean case_sensitive;
    public static short threads;
    public static short retry;
    public static short uretry;
    public static int timeout;
    public static long qchecktime;
    public static long reptime;
    public static String auto_prefix;
    public static String auto_suffix;
    public static String log_fatal;
    public static String log_ok;
    public static String log_err;
    public static Hashtable files;
    public static Vector queue;
    public static int qhead;
    public static ThreadGroup runners;

    public static final void main(String[] argv) {
        System.out.println("Download Machine 0.23\nCopyright (c) 1999-2009 Radim Kolar. Open Source Software; There is NO warranty.\nSee the GNU General Public Licence version 2 or later for copying conditions.\n");
        files = new Hashtable();
        queue = new Vector();
        qhead = -1;
        queue_files = new queuefile[0];
        auto_suffix = "";
        auto_prefix = "";
        runners = new ThreadGroup("Download Machine-workers");
        URL.setURLStreamHandlerFactory(new Handler());
        dmachine.defaultinit();
        try {
            dmachine.configure("dmachine.cnf");
        }
        catch (IOException i) {
            dmachine.addQueueFile("queue");
        }
        new File(download_dir).mkdirs();
        new File(tmp_dir).mkdirs();
        dmachine.watchQueue();
    }

    private static final void checkQueueFiles() {
        for (int i = queue_files.length - 1; i >= 0; --i) {
            queuefile q = queue_files[i];
            if (!q.isModified()) continue;
            q.loadfile();
            if (!q.exists()) continue;
            System.out.println("[QUEUE] Loaded queue file: " + q.getName());
            dmachine.parseQueue(q);
        }
    }

    private static final void checkDropDirectory() {
        if (drop_dir == null) {
            return;
        }
        File dropdir = new File(drop_dir);
        if (!dropdir.isDirectory()) {
            return;
        }
        String[] filez = dropdir.list();
        if (filez == null) {
            return;
        }
        if (filez.length == 0) {
            return;
        }
        for (int i = filez.length - 1; i >= 0; --i) {
            File f = new File(dropdir, filez[i]);
            queuefile q = dropdir_queue != null ? dropdir_queue : new queuefile(f.toString(), false, false);
            q.appendFile(f.toString());
            System.out.println("[QUEUE] Loaded drop directory file: " + f.toString());
            dmachine.parseQueue(q);
            q.savefile();
            f.delete();
        }
    }

    private static final void watchQueue() {
        boolean empty = false;
        long timerstart = System.currentTimeMillis();
        while (true) {
            dmachine.checkQueueFiles();
            dmachine.checkDropDirectory();
            dmachine.touch_flag(alive_flag);
            if (!dmachine.startThreads()) {
                if (exitonempty > 0 && (exitonempty == 1 || System.currentTimeMillis() - timerstart > (long)exitonempty * 1000L)) {
                    System.out.println("[QUEUE] Ending operation, because queue is empty.");
                    dmachine.check_flag(alive_flag);
                    return;
                }
                if (!empty) {
                    System.out.print("[QUEUE] Download Machine is idle.");
                    if (exitonempty > 0) {
                        System.out.print(" DM will stop after " + exitonempty + "s.");
                    }
                    System.out.println("");
                    empty = true;
                }
            } else {
                timerstart = System.currentTimeMillis();
                empty = false;
            }
            try {
                Thread.sleep(qchecktime);
            }
            catch (InterruptedException intr) {
                System.out.println("[YUP!] GOT INTR, QueueWatch ended.");
                return;
            }
        }
    }

    private static final void defaultinit() {
        keepemptyqueues = true;
        removefromqueues = true;
        http_proxydefined = false;
        ftp_proxydefined = false;
        download_dir = "files";
        tmp_dir = download_dir + File.separatorChar + "tmp";
        attic_dir = download_dir + File.separatorChar + "attic";
        drop_dir = "drop";
        case_sensitive = true;
        threads = (short)2;
        retry = (short)15;
        uretry = (short)5;
        timeout = 180000;
        qchecktime = 15000L;
        reptime = 45000L;
        downloadfactory.useragent = "Download Machine/0.23 (Java Virtual Machine)";
        ftpfactory.nopasv = false;
        log_fatal = "fatal.log";
        log_ok = "download.log";
        alive_flag = null;
        exitonempty = 0;
        downloadfactory.send_useragent = true;
        downloadfactory.send_referer = true;
    }

    private static final void configure(String cfgfile) throws IOException {
        String line;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(cfgfile)));
        int lineno = 0;
        while ((line = dis.readLine()) != null) {
            StringTokenizer st;
            ++lineno;
            if (line.startsWith("#") || !(st = new StringTokenizer(line)).hasMoreTokens()) continue;
            String token = st.nextToken();
            token = token.toLowerCase();
            try {
                if (token.equals("http_proxy")) {
                    try {
                        http_proxyserver = InetAddress.getByName(st.nextToken());
                        http_proxyport = Integer.valueOf(st.nextToken());
                        http_proxydefined = true;
                        if (st.countTokens() <= 0) continue;
                        http_auth = "Proxy-authorization: Basic " + HTUU.encode_string(st.nextToken()) + "\r\n";
                    }
                    catch (UnknownHostException hnf) {
                        System.err.println("[CONFIG_ERROR] " + cfgfile + ":" + lineno + " http_proxy " + hnf.getMessage() + ": Host not found.");
                    }
                    continue;
                }
                if (token.equals("ftp_proxy")) {
                    try {
                        ftp_proxyserver = InetAddress.getByName(st.nextToken());
                        ftp_proxyport = Integer.valueOf(st.nextToken());
                        ftp_proxydefined = true;
                        if (st.countTokens() <= 0) continue;
                        ftp_auth = "Proxy-authorization: Basic " + HTUU.encode_string(st.nextToken()) + "\r\n";
                    }
                    catch (UnknownHostException hnf) {
                        System.err.println("[CONFIG_ERROR] " + cfgfile + ":" + lineno + " ftp_proxy " + hnf.getMessage() + ":Host not found.");
                    }
                    continue;
                }
                if (token.equals("ftp_proxy_resume")) {
                    ftp_resume = dmachine.decoderesumekw(st.nextToken());
                    continue;
                }
                if (token.equals("alive_flag")) {
                    alive_flag = st.nextToken();
                    continue;
                }
                if (token.equals("http_proxy_resume")) {
                    http_resume = dmachine.decoderesumekw(st.nextToken());
                    continue;
                }
                if (token.equals("queue_file")) {
                    dmachine.addQueueFile(st.nextToken());
                    continue;
                }
                if (token.equals("drop_directory_queue")) {
                    dropdir_queue = new queuefile(st.nextToken(), true, false);
                    queue_files = util.addQFToArray(dropdir_queue, queue_files);
                    continue;
                }
                if (token.equals("auto_prefix")) {
                    auto_prefix = st.nextToken();
                    continue;
                }
                if (token.equals("user_agent")) {
                    downloadfactory.useragent = st.nextToken("\n").trim();
                    continue;
                }
                if (token.equals("keep_empty_queue_file")) {
                    keepemptyqueues = dmachine.getYesNo(st.nextToken());
                    continue;
                }
                if (token.equals("remove_downloads_from_queue_file")) {
                    removefromqueues = dmachine.getYesNo(st.nextToken());
                    continue;
                }
                if (token.equals("send_user_agent")) {
                    downloadfactory.send_useragent = dmachine.getYesNo(st.nextToken());
                    continue;
                }
                if (token.equals("send_referer")) {
                    downloadfactory.send_referer = dmachine.getYesNo(st.nextToken());
                    continue;
                }
                if (token.equals("log_fatal") || token.equals("fatal_log")) {
                    log_fatal = st.nextToken();
                    continue;
                }
                if (token.equals("log_ok") || token.equals("ok_log")) {
                    log_ok = st.nextToken();
                    continue;
                }
                if (token.equals("log_err") || token.equals("err_log")) {
                    log_err = st.nextToken();
                    continue;
                }
                if (token.equals("auto_suffix")) {
                    auto_suffix = st.nextToken();
                    continue;
                }
                if (token.equals("download_directory")) {
                    download_dir = dmachine.kill_end_slash(st.nextToken());
                    continue;
                }
                if (token.equals("temporary_directory")) {
                    tmp_dir = dmachine.kill_end_slash(st.nextToken());
                    continue;
                }
                if (token.equals("attic_directory")) {
                    attic_dir = dmachine.kill_end_slash(st.nextToken());
                    continue;
                }
                if (token.equals("drop_directory")) {
                    drop_dir = dmachine.kill_end_slash(st.nextToken());
                    continue;
                }
                if (token.equals("case_sensitive_filenames")) {
                    case_sensitive = dmachine.getYesNo(st.nextToken());
                    continue;
                }
                if (token.equals("ftp_nopasv")) {
                    ftpfactory.nopasv = dmachine.getYesNo(st.nextToken());
                    continue;
                }
                if (token.equals("download_threads")) {
                    threads = (short)Integer.valueOf(st.nextToken()).intValue();
                    continue;
                }
                if (token.equals("file_retry_count")) {
                    retry = (short)Integer.valueOf(st.nextToken()).intValue();
                    continue;
                }
                if (token.equals("url_retry_count")) {
                    uretry = (short)Integer.valueOf(st.nextToken()).intValue();
                    continue;
                }
                if (token.equals("download_timeout")) {
                    timeout = 1000 * Integer.valueOf(st.nextToken());
                    continue;
                }
                if (token.equals("fsp_delay")) {
                    fspfactory.delay = Integer.valueOf(st.nextToken());
                    continue;
                }
                if (token.equals("fsp_maxdelay")) {
                    fspfactory.maxdelay = Integer.valueOf(st.nextToken());
                    continue;
                }
                if (token.equals("report_time")) {
                    reptime = 1000 * Integer.valueOf(st.nextToken());
                    continue;
                }
                if (token.equals("queue_check_time")) {
                    qchecktime = 1000L * (long)Integer.valueOf(st.nextToken()).intValue();
                    continue;
                }
                if (token.equals("exit_on_empty_queue")) {
                    int rc = Integer.valueOf(st.nextToken());
                    if (rc > 0) {
                        exitonempty = rc;
                        continue;
                    }
                    exitonempty = 0;
                    continue;
                }
                System.err.println("[CONFIG_ERROR] " + cfgfile + ":" + lineno + " Unknown keyword: " + token);
            }
            catch (NoSuchElementException nse) {
                System.err.println("[CONFIG_ERROR] " + cfgfile + ":" + lineno + " Missing arguent(s).");
            }
        }
        dis.close();
    }

    private static final void parseQueue(queuefile q) {
        int lineno = 0;
        Vector lines = q.getLines();
        int ln = lines.size();
        for (int i = 0; i < ln; ++i) {
            String line = (String)lines.elementAt(i);
            ++lineno;
            if (line.startsWith("#")) continue;
            try {
                StringTokenizer st = new StringTokenizer(line);
                line = st.nextToken();
                if (line.indexOf("://") == -1) {
                    String f1;
                    if ((line = line.toLowerCase()).equals("referer")) {
                        f1 = st.nextToken();
                        String f2 = st.nextToken();
                        downloadfactory.addReferer(f1, f2);
                        continue;
                    }
                    if (line.equals("cookie")) {
                        f1 = st.nextToken();
                        String f2 = st.nextToken("\n").trim();
                        downloadfactory.addCookie(f1, f2);
                        continue;
                    }
                    if (line.equals("check_also") || line.equals("checkalso")) {
                        f1 = st.nextToken().trim();
                        String f2 = st.nextToken("\n").trim();
                        f2 = dmachine.kill_end_slash(f2);
                        qfile.addCheckAlso(f1, f2);
                        continue;
                    }
                    if (line.equals("save_to") || line.equals("saveto")) {
                        f1 = st.nextToken().trim();
                        String f2 = st.nextToken("\n").trim();
                        f2 = dmachine.kill_end_slash(f2);
                        qfile.addSaveto(f1, f2);
                        continue;
                    }
                    if (line.equals("end")) break;
                    System.out.println("[QUEUE] Bad command '" + line + "' at line " + lineno);
                }
            }
            catch (NoSuchElementException kurva) {}
            continue;
            try {
                qfile qf;
                String fn = null;
                if (line.indexOf(35) > -1) {
                    int z = line.indexOf(35);
                    fn = line.substring(z + 1);
                    line = line.substring(0, z);
                }
                URL url = new URL(line);
                if (fn == null) {
                    fn = dmachine.getFilename(url.getFile());
                }
                if (fn != null && fn.length() != 0) {
                    if (!case_sensitive) {
                        fn = fn.toLowerCase();
                    }
                } else {
                    fn = line;
                }
                if ((qf = (qfile)files.get(fn)) == null) {
                    qf = new qfile(fn, line);
                    if (qf.needsDownload()) {
                        System.out.println("[QUEUE] New file " + fn + " added. url=" + line);
                    }
                    files.put(fn, qf);
                    queue.addElement(qf);
                    continue;
                }
                qf.addURL(line);
                continue;
            }
            catch (MalformedURLException grr) {
                System.out.println(grr + "\n[QUEUE] Bad URL=" + line + " at line " + lineno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized boolean startThreads() {
        int ac = runners.activeCount();
        boolean active = false;
        boolean rotated = false;
        int qs = queue.size();
        if (ac > 0) {
            active = true;
        }
        if (ac >= threads) {
            return true;
        }
        if (qs == 0) {
            return active;
        }
        while (true) {
            qfile qf;
            if (++qhead >= qs) {
                if (rotated) {
                    return active;
                }
                qhead = 0;
                rotated = true;
            }
            if (!(qf = (qfile)queue.elementAt(qhead)).needsDownload()) continue;
            active = true;
            Thread t = new Thread(runners, qf);
            Object object = startmon;
            synchronized (object) {
                t.start();
                try {
                    startmon.wait();
                }
                catch (InterruptedException e) {
                    Thread.yield();
                }
            }
            if (++ac >= threads) break;
        }
        return true;
    }

    public static final String getFilename(String fileurl) {
        int j = fileurl.length();
        byte[] v = new byte[j];
        fileurl.getBytes(0, j, v, 0);
        for (int zz = 0; zz < j; ++zz) {
            switch (v[zz]) {
                case 58: 
                case 59: 
                case 61: 
                case 63: 
                case 124: {
                    return null;
                }
            }
        }
        if (fileurl.length() < 2) {
            return "";
        }
        j = fileurl.lastIndexOf(47, j);
        int i = fileurl.indexOf(126);
        if (i != -1 && j < i) {
            return "";
        }
        return fileurl.substring(j + 1);
    }

    private static final void log_write(String fname, String msg) throws IOException {
        if (fname == null) {
            return;
        }
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fname, true)));
        dos.writeBytes(new Date().toString());
        dos.writeBytes(" ");
        dos.writeBytes(msg);
        dos.writeBytes("\n");
        dos.close();
    }

    public static synchronized void log_fatal(String msg) {
        System.out.println("[FATAL_ERR] " + msg);
        try {
            dmachine.log_write(log_fatal, msg);
        }
        catch (IOException i) {
            log_fatal = null;
        }
    }

    public static synchronized void log_err(String msg) {
        System.out.println("[ERR] " + msg);
        try {
            dmachine.log_write(log_err, msg);
        }
        catch (IOException i) {
            log_err = null;
        }
    }

    public static synchronized void log_ok(String msg) {
        System.out.println("[OK] " + msg);
        try {
            dmachine.log_write(log_ok, msg);
        }
        catch (IOException i) {
            log_ok = null;
        }
    }

    private static final void addQueueFile(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        for (int i = queue_files.length - 1; i >= 0; --i) {
            if (!queue_files[i].getName().equals(name)) continue;
            return;
        }
        queue_files = util.addQFToArray(new queuefile(name), queue_files);
    }

    private static final int decoderesumekw(String kw) {
        int res = 0;
        if ((kw = kw.toLowerCase()).equals("none") || kw.equals("normal") || kw.equals("standard")) {
            res = 3;
        } else if (kw.equals("pragma") || kw.equals("nocache")) {
            res = 1;
        } else if (kw.equals("direct")) {
            res = 2;
        } else {
            System.err.println("[CONFIG_ERROR] Unknown resume option " + kw);
        }
        return res;
    }

    private static final String kill_end_slash(String str) {
        if (str.endsWith(File.separator)) {
            str = download_dir.substring(0, download_dir.length() - 1);
        }
        return str;
    }

    private static final void touch_flag(String s) {
        if (s == null) {
            return;
        }
        try {
            FileOutputStream f = new FileOutputStream(s);
            f.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final boolean check_flag(String f) {
        if (f == null) {
            return false;
        }
        File fl = new File(f);
        if (fl.canRead()) {
            fl.delete();
            return true;
        }
        return false;
    }

    private static final boolean getYesNo(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        if ((s = s.toLowerCase()).equals("off") || s.equals("no") || s.equals("0") || s.equals("false")) {
            return false;
        }
        if (s.equals("on") || s.equals("yes") || s.equals("1") || s.equals("true")) {
            return true;
        }
        System.err.println("[CONFIG_ERROR] Can not determine if `" + s + "` means yes or no.");
        return false;
    }
}

