/*
 * Decompiled with CFR 0.152.
 */
package net.fsp;

import java.io.IOException;
import java.io.OutputStream;
import net.fsp.FSPpacket;
import net.fsp.FSPsession;
import net.fsp.FSPutil;

public class FSPOutputStream
extends OutputStream {
    private FSPsession ses;
    private byte[] fname;
    private byte[] buf = new byte[1024];
    private int bufpos;
    private long pos;

    public FSPOutputStream(FSPsession session, String filename) {
        this.ses = session;
        this.fname = FSPutil.stringToASCIIZ(filename);
        this.bufpos = 0;
        this.pos = 0L;
        session.lockWriter(this, true);
    }

    public void flush() throws IOException {
        FSPpacket pkt = this.ses.interact((byte)67, this.pos, this.buf, 0, this.bufpos, null, 0, 0);
        pkt.expect((byte)67);
        this.pos += (long)this.bufpos;
        this.bufpos = 0;
    }

    public void write(int b) throws IOException {
        if (this.bufpos < 1024) {
            this.buf[this.bufpos++] = (byte)b;
        } else {
            this.flush();
            this.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.bufpos >= 1024) {
                this.flush();
            }
            int frag = Math.min(1024 - this.bufpos, len);
            System.arraycopy(b, off, this.buf, this.bufpos, frag);
            len -= frag;
            off += frag;
            this.bufpos += frag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
            FSPpacket pkt = this.ses.interact((byte)68, 0L, this.fname, 0, this.fname.length, null, 0, 0);
            pkt.expect((byte)68);
        }
        finally {
            this.ses.unlockWriter(this);
            this.buf = null;
            this.fname = null;
            this.ses = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Exception {
        if (this.fname != null) {
            try {
                int tm = this.ses.getTimeout();
                this.ses.setTimeout(7000);
                this.ses.interact((byte)68, 0L, null, 0, 0, null, 0, 0);
                this.ses.setTimeout(tm);
            }
            finally {
                this.ses.unlockWriter(this);
            }
        }
    }
}

