/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceMailbox;
import com.jthomas.javafaces.FaceMailboxIMAP;
import com.jthomas.javafaces.FaceMailboxPop;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceProperties;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.javafaces.PromptLogin;
import com.jthomas.util.Debug;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FaceServer {
    private static FaceServer[] _ServerList;
    private static int _ServerCount;
    private String _Type;
    private String _Host;
    private String _User;
    private String _Pass;
    private boolean _Respecify;
    private FaceProperties _Properties;

    public FaceServer(String mailServer) {
        String[] tokens = this.parseServerInfo(mailServer);
        if (tokens[0] != null) {
            this._Type = tokens[0].toUpperCase();
        }
        this._Host = tokens[1];
        this._User = tokens[2];
        this._Pass = tokens[3];
        this._Properties = FaceProperties.getRef();
    }

    private String[] parseServerInfo(String mailServer) {
        StringTokenizer st = new StringTokenizer(mailServer);
        String[] tokens = new String[4];
        int i = 0;
        while (st.hasMoreTokens() && i < 4) {
            tokens[i] = st.nextToken();
            if (tokens[i].toUpperCase().equals("*PROMPT*")) {
                tokens[i] = "";
            }
            ++i;
        }
        return tokens;
    }

    public static void createList() {
        String[] list = FaceOptions.getRef().getList("MailServer");
        if (list.length == 0) {
            Debug.out("No Mail Servers found");
            list = new String[]{""};
        }
        _ServerCount = list.length;
        _ServerList = new FaceServer[_ServerCount];
        int i = 0;
        while (i < _ServerCount) {
            FaceServer._ServerList[i] = new FaceServer(list[i]);
            Debug.out("Server " + i + ": " + _ServerList[i].toString());
            ++i;
        }
    }

    public static FaceServer[] getList() {
        return _ServerList;
    }

    public static int getCount() {
        return _ServerCount;
    }

    public FaceMailbox createMailbox() {
        FaceMailbox mailbox = null;
        if (this._Type.equals("POP3") || this._Type.equals("APOP")) {
            mailbox = new FaceMailboxPop(this);
        } else if (this._Type.equalsIgnoreCase("IMAP")) {
            try {
                mailbox = new FaceMailboxIMAP(this);
            }
            catch (Throwable e) {
                Debug.out("Unable to create FaceMailboxIMAP object", e);
                MsgDialog.create("Unable to create FaceMailboxIMAP object");
                return null;
            }
        }
        return mailbox;
    }

    public String getType() {
        return this._Type;
    }

    public String getHost() {
        return this._Host;
    }

    public String getUser() {
        return this._User;
    }

    public String getPass() {
        return this._Pass;
    }

    public String getName() {
        return String.valueOf(this._User) + "@" + this._Host;
    }

    public boolean getLoginInfo() {
        boolean ok = this.verifyLoginInfo();
        if (ok) {
            return true;
        }
        PromptLogin p = (PromptLogin)PromptLogin.create();
        p.setLoginDefaults(this._Type, this._Host, this._User, this._Pass);
        p.show();
        int status = p.getStatus();
        if (status == 3) {
            Debug.out("User pressed Cancel");
            return false;
        }
        this._Type = p.getType();
        this._Host = p.getHost();
        this._User = p.getUser();
        this._Pass = p.getPass();
        Debug.out("getLoginInfo: result= " + this.toString());
        Debug.out("getLoginInfo: Status= " + p._Status);
        this._Respecify = false;
        ((Hashtable)this._Properties).put("FaceServer", String.valueOf(this._Type) + " " + this._Host + " " + this._User);
        this._Properties.save();
        return true;
    }

    public void setRespecify(boolean flag) {
        this._Respecify = flag;
    }

    public boolean verifyLoginInfo() {
        if (this._Respecify) {
            return false;
        }
        if (this._Type == null) {
            String mailServer = this._Properties.getProperty("FaceServer", null);
            if (mailServer == null) {
                return false;
            }
            String[] tokens = this.parseServerInfo(mailServer);
            this._Type = tokens[0].toUpperCase();
            this._Host = tokens[1];
            this._User = tokens[2];
            this._Pass = tokens[3];
            if (this._Type == null) {
                return false;
            }
        }
        if (!(this._Type.equals("POP3") || this._Type.equals("APOP") || this._Type.equals("IMAP"))) {
            Debug.out("Required Mail Server information not specified.\nMailServerType=" + this._Type);
            return false;
        }
        if (this._Host == null || this._User == null) {
            Debug.out("Required Mail Server information not specified.\nMailHost=" + this._Host + "\n" + "MailUserid=" + this._User);
            return false;
        }
        if (this._Pass == null || this._Pass.length() == 0 || this._Pass.toUpperCase().equals("*PROMPT*")) {
            Debug.out("Password not specified");
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this._Type) + "," + this._Host + "," + this._User + "," + (this._Pass == null ? "null" : "suppressed");
    }
}

