/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.util.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class PiconDBServer {
    private String _DbUrl;
    private String _DbTypes;
    private String _DbProxy;
    private int _DbPort;
    private String _DbHost;

    public PiconDBServer() {
        this._DbUrl = "http://www.cs.indiana.edu:800/piconsearch";
        this._DbTypes = "users+domains";
        Debug.out("PicondbServer() - Default to " + this._DbUrl + " , " + this._DbTypes + " )");
    }

    public PiconDBServer(String url, String types) {
        this._DbUrl = url;
        this._DbTypes = types;
        Debug.out("PicondbServer() - Settings: " + this._DbUrl + " , " + this._DbTypes);
    }

    public PiconDBServer(String url, String types, String proxy, int port) {
        this._DbUrl = url;
        this._DbTypes = types;
        this._DbProxy = proxy;
        this._DbPort = port;
        Debug.out("PicondbServer() - Settings: " + this._DbUrl + " , " + this._DbTypes + " Proxy: " + this._DbProxy + ":" + this._DbPort);
    }

    public String getHost() {
        if (this._DbHost == null) {
            try {
                this._DbHost = new URL(this._DbUrl).getHost();
            }
            catch (Exception exception) {}
            Debug.out("PicondDB.getHost():" + this._DbHost);
        }
        return this._DbHost;
    }

    public String getProxy() {
        return this._DbProxy;
    }

    public int getPort() {
        return this._DbPort;
    }

    public String search(String mailhost, String mailuserid) throws IOException {
        int end;
        StringBuffer buffer;
        String urlstr = String.valueOf(this._DbUrl) + "/" + mailhost + "/" + mailuserid + "/" + this._DbTypes + "/up/on";
        Debug.out("PIconDB Search URL='" + urlstr + "'");
        try {
            String data;
            InputStream istream = this.getInputStream(urlstr);
            if (istream == null) {
                System.out.println("PIcondDB Failure: Failed in getInputStream");
                throw new IOException("Failed in getInputStream");
            }
            BufferedReader url_data = new BufferedReader(new InputStreamReader(istream));
            buffer = new StringBuffer();
            while ((data = url_data.readLine()) != null) {
                buffer.append(data);
            }
        }
        catch (IOException e) {
            System.out.println("PIcondDB Failure: " + e.getMessage());
            throw e;
        }
        String bufstr = buffer.toString();
        if (bufstr.indexOf("Picons Search - Results") == -1) {
            System.out.println("Unexpected Message from PiconSearch");
            System.out.println("PiconDB returned:" + bufstr.length() + "\n" + bufstr);
            return null;
        }
        int gif = bufstr.indexOf(".gif\">");
        int xbm = bufstr.indexOf(".xbm\">");
        if (gif == -1) {
            if (xbm == -1) {
                Debug.out("PiconDB: No image found");
                return null;
            }
            end = xbm;
        } else {
            end = gif;
            if (xbm >= 0 && xbm < gif) {
                end = xbm;
            }
        }
        int start = bufstr.lastIndexOf("href=\"", end += 4);
        String gifurl = bufstr.substring(start += 6, end);
        Debug.out("gifurl=" + gifurl);
        return gifurl;
    }

    public InputStream getInputStream(String urlstr) throws IOException, MalformedURLException {
        URL url = null;
        URLConnection urlcon = null;
        InputStream istream = null;
        try {
            if (this._DbProxy != null) {
                Debug.out("Access via " + this._DbProxy + ":" + this._DbPort);
                url = new URL("http", this._DbProxy, this._DbPort, urlstr);
            } else {
                url = new URL(urlstr);
            }
            urlcon = url.openConnection();
            if (urlcon != null) {
                urlcon.connect();
                istream = urlcon.getInputStream();
            }
        }
        catch (MalformedURLException e) {
            Debug.out("PiconDB.MalformedURLException: " + e.getMessage());
            Debug.out("PiconDB.getInputStream: MalformedURL - " + urlstr);
            throw e;
        }
        catch (IOException e) {
            Debug.out("PiconDB.getInputStream: " + e.getMessage());
            Debug.out("PiconDB.getInputStream: Can not connect to server - " + urlstr);
            throw e;
        }
        return istream;
    }
}

