/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.layout.XYLayout;
import borland.jbcl.view.BorderItemPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class BevelPanel
extends Panel {
    public static final int FLAT = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    private Image canvas;
    private int bevelInner = 1;
    private int bevelOuter = 0;
    private boolean soft = false;
    private boolean doubleBuffer = false;
    private BorderItemPainter border;
    private Insets margins = new Insets(0, 0, 0, 0);

    public BevelPanel() {
        super.setLayout(new XYLayout());
        super.setBackground(SystemColor.control);
        this.resetEdges();
    }

    public BevelPanel(int n, int n2) {
        super.setLayout(new XYLayout());
        super.setBackground(SystemColor.control);
        if (n >= 0 && n <= 2) {
            this.bevelInner = n;
        }
        if (n2 >= 0 && n2 <= 2) {
            this.bevelOuter = n2;
        }
        this.resetEdges();
    }

    public void setBevelInner(int n) {
        if (n >= 0 && n <= 2 && n != this.bevelInner) {
            this.bevelInner = n;
            this.resetEdges();
        }
    }

    public int getBevelInner() {
        return this.bevelInner;
    }

    public void setBevelOuter(int n) {
        if ((n == 0 || n == 1 || n == 2) && n != this.bevelOuter) {
            this.bevelOuter = n;
            this.resetEdges();
        }
    }

    public int getBevelOuter() {
        return this.bevelOuter;
    }

    public void setSoft(boolean bl) {
        if (bl != this.soft) {
            this.soft = bl;
            this.resetEdges();
        }
    }

    public boolean isSoft() {
        return this.soft;
    }

    public void setDoubleBuffer(boolean bl) {
        this.doubleBuffer = bl;
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setMargins(Insets insets) {
        if (!this.margins.equals(insets)) {
            this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
            this.invalidate();
            this.repaint(100L);
        }
    }

    public Insets getMargins() {
        return this.margins;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        Insets insets2 = this.border != null ? this.border.getInsets() : new Insets(0, 0, 0, 0);
        return new Insets(insets.top + insets2.top + this.margins.top, insets.left + insets2.left + this.margins.left, insets.bottom + insets2.bottom + this.margins.bottom, insets.right + insets2.right + this.margins.right);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width <= 10) {
            dimension.width = 200;
        }
        if (dimension.height <= 10) {
            dimension.height = 150;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        Graphics graphics2;
        Dimension dimension = this.getSize();
        if (this.doubleBuffer) {
            if (this.canvas == null || this.canvas.getWidth(null) != dimension.width || this.canvas.getHeight(null) != dimension.height) {
                this.canvas = this.createImage(dimension.width, dimension.height);
            }
            graphics2 = this.canvas.getGraphics();
            rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
            graphics2.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics2 = graphics;
            this.canvas = null;
        }
        super.paint(graphics2);
        if (this.border != null) {
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            this.border.paint(null, graphics2, rectangle, 0, null);
        }
        if (this.doubleBuffer) {
            graphics.drawImage(this.canvas, 0, 0, null);
            graphics2.dispose();
        }
    }

    protected void resetEdges() {
        if (this.bevelInner == 0 && this.bevelOuter == 0) {
            this.border = null;
        } else {
            int n = 0;
            switch (this.bevelInner) {
                case 0: {
                    break;
                }
                case 1: {
                    n |= 0x400;
                    break;
                }
                case 2: {
                    n |= 0x800;
                }
            }
            switch (this.bevelOuter) {
                case 0: {
                    break;
                }
                case 1: {
                    n |= 0x100;
                    break;
                }
                case 2: {
                    n |= 0x200;
                }
            }
            this.border = new BorderItemPainter(n, 15, this.soft ? 4096 : 0);
        }
        this.invalidate();
        this.repaint(100L);
    }
}

