/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.ButtonDialog;
import borland.jbcl.control.FieldControl;
import borland.jbcl.control.TextAreaControl;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.util.ChainedException;
import borland.jbcl.util.ExceptionChain;
import borland.jbcl.view.WrappedTextItemPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class ExceptionDialog
extends ButtonDialog
implements ActionListener {
    private FieldControl message = new FieldControl();
    private TextAreaControl details = new TextAreaControl();
    private Panel centerPanel = new Panel();
    private boolean showDetails = false;
    private int detailHeight = 200;
    private int position;
    private Vector exceptionVector;
    private Exception ex;
    private static int showCount;

    private static int makeButtonSet(Exception exception) {
        if (exception instanceof ChainedException && ((ChainedException)((Object)exception)).getExceptionChain() != null) {
            return 897;
        }
        return 513;
    }

    public ExceptionDialog(Frame frame, String string, Exception exception, boolean bl) {
        super(frame, string, bl, null, null, ButtonDialog.buttonSetToButtonDescriptors(ExceptionDialog.makeButtonSet(exception)));
        this.ex = exception;
        this.details.setEditable(false);
        ((Component)this.details).setBackground(SystemColor.window);
        this.details.setPreferredHeight(200);
        this.message.setPreferredHeight(100);
        this.message.setPreferredWidth(400);
        this.message.setModel(new BasicSingletonContainer());
        this.message.setAlignment(1);
        this.message.setViewManager(new BasicViewManager(new WrappedTextItemPainter(null, 1, 0), null));
        this.makeExceptionList(exception);
        this.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.message, "Center");
        this.centerPanel.add((Component)this.buttonPanel, "South");
        this.add((Component)this.centerPanel, "Center");
        ((Component)this).setBackground(SystemColor.control);
        this.setEnterOK(true);
        this.displayException(0);
        ++showCount;
    }

    public ExceptionDialog(Frame frame, String string, Exception exception) {
        this(frame, string, exception, false);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        super.processActionEvent(actionEvent);
        if (this.result != null) {
            if (this.result.closeDialog) {
                --showCount;
            }
            if (this.result.command.equals("next") && this.position < this.exceptionVector.size() - 1) {
                this.displayException(++this.position);
            }
            if (this.result.command.equals("previous") && this.position > 0) {
                this.displayException(--this.position);
            }
            if (this.result.command.equals("details")) {
                if (!this.showDetails) {
                    Dimension dimension = this.getSize();
                    Rectangle rectangle = this.centerPanel.getBounds();
                    this.remove(this.centerPanel);
                    this.add((Component)this.centerPanel, "North");
                    this.add((Component)this.details, "Center");
                    this.details.setBounds(rectangle.x, rectangle.y + rectangle.height, rectangle.width, this.detailHeight);
                    ((Component)this).setSize(dimension.width, dimension.height + this.detailHeight);
                } else {
                    Dimension dimension = this.getSize();
                    this.detailHeight = this.details.getSize().height;
                    this.remove(this.details);
                    this.remove(this.centerPanel);
                    this.add((Component)this.centerPanel, "Center");
                    ((Component)this).setSize(dimension.width, dimension.height - this.detailHeight);
                }
                this.showDetails = !this.showDetails;
            }
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, "ok"));
        }
    }

    private void displayException(int n) {
        this.enableButton("previous", this.position > 0);
        this.enableButton("next", this.position < this.exceptionVector.size() - 1);
        Exception exception = (Exception)this.exceptionVector.elementAt(n);
        String string = exception.getMessage();
        if (string == null || string.length() < 1) {
            string = exception.getClass().getName();
        }
        this.message.setText(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        this.details.setText(byteArrayOutputStream.toString());
    }

    private void makeExceptionList(Exception exception) {
        this.exceptionVector = new Vector();
        this.exceptionVector.addElement(exception);
        if (exception instanceof ChainedException) {
            for (ExceptionChain exceptionChain = ((ChainedException)((Object)exception)).getExceptionChain(); exceptionChain != null; exceptionChain = exceptionChain.getNext()) {
                exception = exceptionChain.getException();
                this.exceptionVector.addElement(exception);
            }
        }
        this.position = 0;
    }

    public static int getShowCount() {
        return showCount;
    }
}

