/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.model;

import borland.jbcl.model.VariantFormatter;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;

public class IntegerFormatter
extends VariantFormatter {
    protected int type;

    public IntegerFormatter(int n) {
        this.type = n;
    }

    public final String format(Variant variant) {
        return variant == null || variant.isNull() ? "" : new Integer(variant.getAsInt()).toString();
    }

    public void parse(String string, Variant variant) throws InvalidFormatException {
        if (string == null || string.length() == 0) {
            variant.setUnassignedNull();
            return;
        }
        variant.setAsInt(this.type, new Integer(string));
    }

    public void parse(Variant variant, char[] cArray, int n, int n2) throws InvalidFormatException {
        if (cArray == null || n2 == 0 || cArray.length == 0) {
            variant.setUnassignedNull();
            return;
        }
        boolean bl = cArray[n] == '-';
        int n3 = 0;
        if (bl) {
            ++n;
            --n2;
        }
        int n4 = n;
        while (n2 > 0) {
            int n5 = cArray[n4];
            if (n5 >= 48 && n5 <= 57) {
                n5 -= 48;
            } else if ((n5 = Character.digit((char)n5, 10)) < 0) {
                throw new InvalidFormatException(new String(cArray, n, n2));
            }
            n3 = n3 * 10 + n5;
            ++n4;
            --n2;
        }
        variant.setAsInt(this.type, bl ? -n3 : n3);
    }

    public int getVariantType() {
        return this.type;
    }
}

