/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonModelMulticaster;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.view.SingletonView;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ChoiceView
extends Choice
implements SingletonView,
SingletonModelListener,
KeyListener {
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModelMulticaster modelAdapter = new SingletonModelMulticaster();
    private boolean readOnly;

    public ChoiceView() {
        this.enableEvents(512L);
        this.addKeyListener(this);
    }

    public synchronized String[] getItems() {
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public synchronized void setItems(String[] stringArray) {
        this.removeAll();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                super.addItem(stringArray[i]);
            }
        }
        if (this.model.get() != null) {
            this.updateSelection();
        } else if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            this.writeModel.set(stringArray[0]);
        }
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = singletonModel;
        WritableSingletonModel writableSingletonModel = this.writeModel = singletonModel instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.modelContentChanged(null);
        }
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.model.addModelListener(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.model.removeModelListener(singletonModelListener);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.setEnabled(!this.readOnly);
    }

    public SingletonViewManager getViewManager() {
        return null;
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.updateSelection();
    }

    public void select(String string) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            super.select(string);
            String string2 = this.getSelectedItem();
            this.writeModel.set(string2);
        }
    }

    protected void updateSelection() {
        Object object = this.model.get();
        String string = object != null ? object.toString() : "";
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!string.equals(this.getItem(i))) continue;
            super.select(string);
            return;
        }
        if (object != null) {
            super.addItem(string);
            super.select(string);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            String string = this.getSelectedItem();
            this.writeModel.set(string);
        }
        super.processItemEvent(itemEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isReadOnly() || !this.writeModel.canSet(false) || keyEvent.isAltDown()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        int n2 = this.getSelectedIndex();
        switch (n) {
            case 40: {
                if (n2 < this.getItemCount() - 1) {
                    this.select(n2 + 1);
                }
                keyEvent.consume();
                break;
            }
            case 38: {
                if (n2 > 0) {
                    this.select(n2 - 1);
                }
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.isReadOnly() || !this.writeModel.canSet(false) || keyEvent.isAltDown()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        String string = this.getSelectedItem().toLowerCase();
        char c2 = string.length() > 0 ? string.charAt(0) : (char)'\u0000';
        int[] nArray = new int[]{};
        if (c != '\u0000') {
            for (int i = 0; i < this.getItemCount(); ++i) {
                String string2 = this.getItem(i).toLowerCase();
                if (string2.length() <= 0 || string2.charAt(0) != c) continue;
                if (c2 != c) {
                    this.writeModel.set(this.getItem(i));
                    return;
                }
                int[] nArray2 = nArray;
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray.length - 1] = i;
            }
            if (nArray.length > 0) {
                int n = this.getSelectedIndex();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] > n) {
                        this.writeModel.set(this.getItem(nArray[i]));
                        return;
                    }
                    if (i != nArray.length - 1 || nArray[i] != n) continue;
                    this.writeModel.set(this.getItem(nArray[0]));
                    return;
                }
            }
        }
    }
}

