/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class FocusableItemPainter
implements ItemPainter {
    protected ItemPainter painter;
    protected boolean showRollover = true;
    protected Color rollColor = SystemColor.textHighlight;

    public FocusableItemPainter() {
        this.painter = null;
    }

    public FocusableItemPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public FocusableItemPainter(ItemPainter itemPainter, boolean bl) {
        this.painter = itemPainter;
        this.showRollover = bl;
    }

    public void setPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setRolloverColor(Color color) {
        this.rollColor = color;
    }

    public Color getRollColor() {
        return this.rollColor;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        return this.painter != null ? this.painter.getPreferredSize(object, graphics, n, itemPaintSite) : new Dimension(0, 0);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        if (this.painter != null) {
            this.painter.paint(object, graphics, rectangle, n, itemPaintSite);
        }
        if ((n & 2) != 0) {
            this.drawFocusRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (this.showRollover && (n & 0x40) != 0) {
            this.drawRollover(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void drawDottedHLine(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = (n2 + 1) / 2 * 2; i <= n3; i += n4) {
            graphics.drawLine(i, n, i, n);
        }
    }

    protected void drawDottedVLine(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = (n2 + 1) / 2 * 2; i <= n3; i += n4) {
            graphics.drawLine(n, i, n, i);
        }
    }

    protected void drawFocusRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        this.drawDottedHLine(graphics, n2, n, n + n3 - 1, 2);
        this.drawDottedVLine(graphics, n + n3 - 1, n2, n2 + n4 - 1, 2);
        this.drawDottedHLine(graphics, n2 + n4 - 1, n, n + n3 - 1, 2);
        this.drawDottedVLine(graphics, n, n2, n2 + n4 - 1, 2);
        graphics.setColor(color);
    }

    protected void drawRollover(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.rollColor);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }
}

