/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserClassLoader;
import ice.htmlbrowser.BrowserSecurityException;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

class BrowserSecurityManager
extends SecurityManager {
    private Class classLoaderClass = null;
    private static boolean debug = false;

    public BrowserSecurityManager() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            this.classLoaderClass = classLoader.getClass();
        }
    }

    public Object getSecurityContext() {
        ClassLoader cl = this.currentClassLoader();
        if (cl instanceof BrowserClassLoader) {
            return BrowserClassLoader.getSecurityContext(this.currentClassLoader());
        }
        return null;
    }

    private boolean isTrusted() {
        if (this.classLoaderDepth() == -1) {
            return true;
        }
        Object url = this.getSecurityContext();
        return url != null && url instanceof URL && ((URL)url).getProtocol().equals("file");
    }

    public synchronized void checkCreateClassLoader() {
        if (this.classLoaderDepth() != 2) {
            return;
        }
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("classloader");
        }
    }

    public synchronized void checkAccess(Thread t) {
    }

    public synchronized void checkAccess(ThreadGroup g) {
    }

    public synchronized void checkExit(int status) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("exit", String.valueOf(status));
        }
    }

    public synchronized void checkExec(String cmd) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("exec", cmd);
        }
    }

    public synchronized void checkLink(String lib) {
        switch (this.classLoaderDepth()) {
            case 2: 
            case 3: {
                throw new BrowserSecurityException("link", lib);
            }
        }
    }

    public synchronized void checkPropertiesAccess() {
        if (this.classLoaderDepth() == 2) {
            throw new BrowserSecurityException("properties");
        }
    }

    public synchronized void checkPropertyAccess(String key) {
        if (this.isTrusted()) {
            return;
        }
        if (this.classLoaderDepth() == 2 && "true".equalsIgnoreCase(System.getProperty(String.valueOf("ice.").concat(String.valueOf(key))))) {
            return;
        }
        if (key.equals("java.home") || key.equals("java.class.path") || key.equals("user.name") || key.equals("user.home") || key.equals("user.dir")) {
            throw new BrowserSecurityException(String.valueOf("properties attempt to access ").concat(String.valueOf(key)));
        }
    }

    public synchronized void checkRead(String file) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("file.read", file);
        }
    }

    public void checkRead(String file, Object context) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("file.read", file);
        }
    }

    public synchronized void checkWrite(String file) {
        this.debug("checkWrite(String file)");
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("file.write", file);
        }
    }

    public void checkDelete(String file) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("file.delete", file);
        }
    }

    public synchronized void checkRead(FileDescriptor fd) {
        if (!this.isTrusted() && !this.inClass("java.net.SocketInputStream") || !fd.valid()) {
            throw new BrowserSecurityException("fd.read");
        }
    }

    public synchronized void checkWrite(FileDescriptor fd) {
        this.debug("checkWrite(FileDescriptor fd)");
        if (!this.isTrusted() && !this.inClass("java.net.SocketOutputStream") || !fd.valid()) {
            throw new BrowserSecurityException("fd.write");
        }
    }

    public synchronized void checkListen(int port) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("socket.listen", String.valueOf(port));
        }
    }

    public synchronized void checkAccept(String host, int port) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("socket.accept", String.valueOf(String.valueOf(host).concat(String.valueOf(":"))).concat(String.valueOf(String.valueOf(port))));
        }
    }

    public void checkMulticast(InetAddress maddr) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("checkmulticast");
        }
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("checkmulticast");
        }
    }

    public synchronized void checkConnect(String host, int port) {
        if (this.isTrusted()) {
            return;
        }
        Object url = this.getSecurityContext();
        if (url == null || !(url instanceof URL)) {
            throw new BrowserSecurityException("checkConnect", String.valueOf(String.valueOf(String.valueOf("To ").concat(String.valueOf(host))).concat(String.valueOf(":"))).concat(String.valueOf(port)));
        }
        this.checkConnect(((URL)url).getHost(), host);
    }

    private synchronized void checkConnect(String fromHost, String toHost) {
        block5: {
            try {
                this.inCheck = true;
                if (fromHost.equals(toHost)) break block5;
                try {
                    InetAddress toHostAddr = InetAddress.getByName(toHost);
                    InetAddress fromHostAddr = InetAddress.getByName(fromHost);
                    if (fromHostAddr.equals(toHostAddr)) {
                        Object var7_5 = null;
                        this.inCheck = false;
                        return;
                    }
                    throw new BrowserSecurityException("checkConnect", String.valueOf("To ").concat(String.valueOf(toHost)));
                }
                catch (UnknownHostException e) {
                    throw new BrowserSecurityException("checkConnect", String.valueOf("To ").concat(String.valueOf(toHost)));
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.inCheck = false;
                throw throwable;
            }
        }
        Object var7_6 = null;
        this.inCheck = false;
    }

    public void checkConnect(String host, int port, Object context) {
        this.checkConnect(host, port);
        if (context != null) {
            if (context instanceof URL) {
                this.checkConnect(((URL)context).getHost(), host);
            } else {
                throw new BrowserSecurityException("checkConnect (unknown context)", String.valueOf("To ").concat(String.valueOf(host)));
            }
        }
    }

    public synchronized boolean checkTopLevelWindow(Object window) {
        return this.isTrusted();
    }

    public synchronized void checkPackageAccess(String pkg) {
        if (this.isTrusted()) {
            return;
        }
        int i = pkg.indexOf(46);
        while (i > 0) {
            String subpkg = pkg.substring(0, i);
            if (Boolean.getBoolean(String.valueOf("package.restrict.access.").concat(String.valueOf(subpkg)))) {
                throw new BrowserSecurityException("checkpackageaccess", pkg);
            }
            i = pkg.indexOf(46, i + 1);
        }
    }

    public synchronized void checkPackageDefinition(String pkg) {
        if (this.isTrusted()) {
            return;
        }
        int i = pkg.indexOf(46);
        while (i > 0) {
            String subpkg = pkg.substring(0, i);
            if (Boolean.getBoolean(String.valueOf("package.restrict.definition.").concat(String.valueOf(subpkg)))) {
                throw new BrowserSecurityException("checkpackagedefinition", pkg);
            }
            i = pkg.indexOf(46, i + 1);
        }
    }

    public synchronized void checkSetFactory() {
        if (this.classLoaderDepth() != 2) {
            return;
        }
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("cannotsetfactory");
        }
    }

    public void checkPrintJobAccess() {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("getPrintJob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("checkawteventqueueaccess");
        }
    }

    public void checkMemberAccess(Class clazz, int which) {
        ClassLoader currentLoader;
        if (which != 0 && (currentLoader = this.currentClassLoader()) != null && currentLoader != clazz.getClassLoader()) {
            throw new BrowserSecurityException("checkmemberaccess");
        }
    }

    public void checkSecurityAccess(String provider) {
        if (!this.isTrusted()) {
            throw new BrowserSecurityException("checksecurityaccess", provider);
        }
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup tg;
        ClassLoader loader = this.currentClassLoader();
        if (loader != null && loader instanceof BrowserClassLoader) {
            BrowserClassLoader appletLoader = (BrowserClassLoader)loader;
            tg = appletLoader.getThreadGroup();
        } else {
            tg = super.getThreadGroup();
        }
        this.debug(String.valueOf("getThreadGroup() = ").concat(String.valueOf(tg)));
        return tg;
    }

    public ClassLoader currentClassLoader() {
        Class cClass = this.currentLoadedClass();
        if (cClass == null) {
            return null;
        }
        return cClass.getClassLoader();
    }

    public Class currentLoadedClass() {
        ClassLoader classLoader = null;
        Class<?>[] aclass = this.getClassContext();
        for (int i = 0; i < aclass.length; ++i) {
            classLoader = aclass[i].getClassLoader();
            if (classLoader == null || classLoader.getClass() == this.classLoaderClass) continue;
            return aclass[i];
        }
        return null;
    }

    public int classLoaderDepth() {
        Class<?>[] aclass = this.getClassContext();
        for (int i = 0; i < aclass.length; ++i) {
            ClassLoader classLoader = aclass[i].getClassLoader();
            if (classLoader == null || classLoader.getClass() == this.classLoaderClass) continue;
            return --i;
        }
        return -1;
    }

    private void debug(String msg) {
        if (debug) {
            System.out.println(String.valueOf("BrowserSecurityManager:: ").concat(String.valueOf(msg)));
            System.out.println(String.valueOf("    currentClassLoader = ").concat(String.valueOf(this.currentClassLoader())));
        }
    }
}

