/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxTable;
import ice.htmlbrowser.BoxWord;
import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.BrowserURLLoader;
import ice.htmlbrowser.Document;
import ice.htmlbrowser.FontInfo;
import ice.htmlbrowser.ImageMap;
import ice.htmlbrowser.MouseOverLinkEvent;
import ice.htmlbrowser.Parser;
import ice.htmlbrowser.ProcessURL;
import ice.htmlbrowser.VisDocument;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

class DocContainer
extends Panel
implements MouseListener,
MouseMotionListener,
Serializable {
    private Cursor cursorLink;
    private Cursor cursorNormal;
    private Cursor cursorWait;
    private Cursor cursorDefault;
    private boolean parsingDone = false;
    private transient Stack Tables;
    private transient BoxTable box_table;
    private transient Box last_box = null;
    private Vector imageList = new Vector();
    private int newScrollX = 0;
    private int newScrollY = 0;
    private transient Thread procThread;
    private transient Parser parser;
    private transient FontInfo fi;
    private URL baseURL;
    private URL url;
    private String title;
    private transient Image backImage;
    private String backImageLoc;
    private Box boxListHead = null;
    private Box boxListTail = null;
    private int boxListCount = 0;
    private int boxValidCount = 0;
    private Vector ImageMaps;
    private transient Vector compBoxes;
    private transient Vector compComponents;
    private int scroll_x = 0;
    private int scroll_y = 0;
    private transient VisDocument vis_doc;
    private transient Document parentDocument;
    BoxWord savebox = null;

    DocContainer() {
    }

    DocContainer(Document parentDocument, URL url, String outputString, FontInfo fi) {
        this.setLayout(null);
        this.fi = fi;
        this.setParentDocument(parentDocument);
        this.htmlStart();
        this.cursorLink = new Cursor(12);
        this.cursorNormal = new Cursor(0);
        this.cursorWait = new Cursor(3);
        this.cursorDefault = this.cursorNormal;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCurrentURL(url);
        if (url != null) {
            this.cursorDefault = this.cursorWait;
            this.setDefaultCursor();
            this.setTitle(String.valueOf(String.valueOf("[").concat(String.valueOf(url.toString()))).concat(String.valueOf("]")));
            this.setDocumentBase(url);
            this.procThread = new ProcessURL(this, this.parser, url, outputString);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.procThread != null && !this.procThread.isAlive()) {
            this.procThread.start();
        }
    }

    private void setLinkCursor() {
        if (this.getCursor() != this.cursorLink) {
            this.setCursor(this.cursorLink);
        }
    }

    private void setDefaultCursor() {
        if (this.getCursor() != this.cursorDefault) {
            this.setCursor(this.cursorDefault);
        }
    }

    void setParsingDone(boolean flag) {
        this.parsingDone = flag;
        if (this.parsingDone) {
            VisDocument visDocument = this.vis_doc;
            synchronized (visDocument) {
                try {
                    this.vis_doc.notify();
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    boolean isParsingDone() {
        return this.parsingDone;
    }

    void redirectTo(BoxTable bt) {
        if (bt == null) {
            this.box_table = !this.Tables.empty() ? (BoxTable)this.Tables.pop() : null;
        } else {
            this.Tables.push(this.box_table);
            this.box_table = bt;
        }
    }

    BoxTable getRedirect() {
        return this.box_table;
    }

    void addBox(Box b) {
        if (this.box_table != null) {
            this.box_table.addBox(b);
        } else if (this.boxListHead == null) {
            this.boxListHead = this.boxListTail = b;
            this.boxListCount = 1;
            this.invalidate();
            this.getParentDocument().invalidate();
            this.getParentDocument().validate();
        } else {
            this.boxListTail.setNext(b);
            this.boxListTail = b;
            ++this.boxListCount;
            VisDocument visDocument = this.vis_doc;
            synchronized (visDocument) {
                try {
                    this.vis_doc.notify();
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
        this.last_box = b;
    }

    Box lastBox() {
        return this.last_box;
    }

    synchronized void setAWTComponent(Box b, Component c) {
        if (c != null) {
            this.add(c);
            this.compBoxes.addElement(b);
            this.compComponents.addElement(c);
            c.setLocation(b.location().x - this.scroll_x, b.location().y - this.scroll_y);
        }
    }

    synchronized Vector getAWTComponents() {
        return this.compComponents;
    }

    ImageMap newImageMap(String name) {
        try {
            URL url = new URL(this.getDocumentBase(), String.valueOf("#").concat(String.valueOf(name)));
            ImageMap map = new ImageMap(url);
            this.ImageMaps.addElement(map);
            ImageMap imageMap = map;
            return imageMap;
        }
        catch (MalformedURLException e) {
            ImageMap imageMap = null;
            return imageMap;
        }
    }

    ImageMap getImageMap(String loc) {
        URL url;
        try {
            url = new URL(this.getDocumentBase(), loc);
        }
        catch (MalformedURLException e) {
            ImageMap imageMap = null;
            return imageMap;
        }
        int n = this.ImageMaps.size();
        for (int i = 0; i < n; ++i) {
            ImageMap map = (ImageMap)this.ImageMaps.elementAt(i);
            if (!url.equals(map.getURL())) continue;
            return map;
        }
        return null;
    }

    void setBackgroundImage(String loc) {
        try {
            URL url = new URL(this.getDocumentBase(), loc);
            BrowserURLLoader bul = new BrowserURLLoader(url);
            this.backImage = bul.getImage();
            this.addImage(this.backImage);
            this.prepareImage(this.backImage, this);
        }
        catch (Exception e) {
            this.backImage = null;
            return;
        }
        this.backImageLoc = loc;
    }

    Image getBackgroundImage() {
        return this.backImage;
    }

    void htmlStart() {
        this.removeAll();
        this.backImage = null;
        this.backImageLoc = null;
        this.boxListHead = null;
        this.boxListTail = null;
        this.boxListCount = 0;
        this.boxValidCount = 0;
        this.last_box = null;
        this.ImageMaps = new Vector();
        this.Tables = new Stack();
        this.compBoxes = new Vector();
        this.compComponents = new Vector();
        if (this.parser != null) {
            this.parser.init(this);
        } else {
            this.parser = new Parser(this);
        }
        if (this.vis_doc != null) {
            this.vis_doc.init();
        } else {
            this.vis_doc = new VisDocument(this.parentDocument);
        }
        this.setParsingDone(false);
    }

    void htmlAppend(String str) {
        try {
            this.parser.setLexReader(new StringReader(str));
        }
        catch (IOException e) {
            System.err.println(String.valueOf("Cannot append String to document\n").concat(String.valueOf(e.getMessage())));
        }
    }

    void htmlAppend(InputStream stream) {
        try {
            this.parser.setLexReader(new InputStreamReader(stream));
        }
        catch (IOException e) {
            System.err.println(String.valueOf("Cannot append InputStream to document\n").concat(String.valueOf(e.getMessage())));
        }
        this.validate();
    }

    void parseHTMLString(String str) {
        this.htmlStart();
        this.htmlAppend(str);
    }

    void parseHTMLStream(InputStream stream) {
        this.htmlStart();
        this.htmlAppend(stream);
    }

    void setFontInfo(FontInfo fi) {
        this.fi = fi;
        this.vis_doc.prepareFullLayout();
        this.invalidate();
        this.validate();
    }

    void showDocument() {
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            if (!(b instanceof ActiveBox)) continue;
            ((ActiveBox)((Object)b)).activeShow();
        }
        this.getParentDocument().updateTitle(this.title);
        this.cursorDefault = this.cursorNormal;
        this.setDefaultCursor();
    }

    Vector getImages() {
        return this.imageList;
    }

    void addImage(Image img) {
        if (!this.imageList.contains(img)) {
            this.imageList.addElement(img);
        }
    }

    void hideDocument() {
        if (this.procThread != null) {
            if (this.procThread.isAlive()) {
                this.procThread.stop();
            }
            this.procThread = null;
        }
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            if (!(b instanceof ActiveBox)) continue;
            ((ActiveBox)((Object)b)).activeHide();
        }
    }

    void stopLoading() {
        if (this.procThread != null) {
            if (this.procThread.isAlive()) {
                this.procThread.stop();
            }
            this.procThread = null;
        }
        this.parser.stopLoading();
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            if (!(b instanceof ActiveBox)) continue;
            ((ActiveBox)((Object)b)).activeInterrupt();
        }
    }

    void repaintBox(Box b) {
        try {
            if (this.isVisible()) {
                Point pos = b.location();
                Dimension dim = b.size();
                int x = pos.x - this.scroll_x;
                int y = pos.y - this.scroll_y;
                if (x < this.visSize().width && y < this.visSize().height && x + dim.width > 0 && y + dim.height > 0) {
                    Graphics gg = this.getGraphics().create(x, y, dim.width, dim.height);
                    b.paint(gg);
                    gg.dispose();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public URL getReferer() {
        return this.parentDocument.getReferer();
    }

    public void doLayout() {
        super.doLayout();
        int w = this.visSize().width;
        this.vis_doc.doLayout(this.boxListHead, this.boxListCount, w, w);
    }

    void moveComponentBoxes() {
        int n = this.compBoxes.size();
        for (int i = 0; i < n; ++i) {
            Box b = (Box)this.compBoxes.elementAt(i);
            Component c = (Component)this.compComponents.elementAt(i);
            c.setLocation(b.location().x - this.scroll_x, b.location().y - this.scroll_y);
        }
    }

    Dimension visSize() {
        return this.getSize();
    }

    Dimension docSize() {
        Dimension d = new Dimension(this.vis_doc.docSize());
        return d;
    }

    URL getDocumentBase() {
        return this.baseURL;
    }

    void setCurrentURL(URL url) {
        this.url = url;
    }

    URL getCurrentURL() {
        return this.url;
    }

    void setDocumentBase(String loc) {
        try {
            this.setDocumentBase(new URL(loc));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    void setDocumentBase(URL url) {
        try {
            url = url.getRef() != null ? new URL(url, String.valueOf("#").concat(String.valueOf(url.getRef()))) : new URL(url, "");
        }
        catch (MalformedURLException e) {
            return;
        }
        this.baseURL = url;
        this.getParentDocument().updateCurrentURL();
    }

    Font getFont(int font_idx) {
        return this.fi.getFont(font_idx);
    }

    FontMetrics getFontMetrics(int font_idx) {
        return this.fi.getFontMetrics(font_idx);
    }

    Document getParentDocument() {
        return this.parentDocument;
    }

    Frame getFrame() {
        return BrowserTools.findFrame(this);
    }

    void setParentDocument(Document pd) {
        this.parentDocument = pd;
    }

    Point getAnchorPosition(URL url) {
        if (!url.sameFile(this.getDocumentBase())) {
            return null;
        }
        String ref = url.getRef();
        if (ref == null) {
            return null;
        }
        Box theBox = null;
        for (Box b = this.boxListHead; b != null && theBox == null; b = b.getNext()) {
            theBox = b.getAnchorBox(ref);
        }
        if (theBox != null) {
            return theBox.location();
        }
        return new Point(0, 0);
    }

    void setTitle(String str) {
        this.title = new String(str);
        this.getParentDocument().updateTitle(this.title);
    }

    Point getScrollPosition() {
        return new Point(this.scroll_x, this.scroll_y);
    }

    void scrollTo(int x, int y) {
        if (this.scroll_x != x || this.scroll_y != y) {
            this.newScrollX = x;
            this.newScrollY = y;
            this.repaint();
        }
    }

    void scrollJumpTo(int x, int y) {
        this.newScrollX = this.scroll_x = x;
        this.newScrollY = this.scroll_y = y;
        this.repaint();
        this.moveComponentBoxes();
    }

    public void update(Graphics g) {
        int w = this.visSize().width;
        int h = this.visSize().height;
        if (this.newScrollY != this.scroll_y) {
            if (this.newScrollY > this.scroll_y) {
                int y = this.newScrollY - this.scroll_y;
                if (y < h) {
                    g.copyArea(0, y, w, h - y, 0, -y);
                    g.setClip(new Rectangle(0, h - y, w, y));
                }
            } else {
                int y = this.scroll_y - this.newScrollY;
                if (y < h) {
                    g.copyArea(0, 0, w, h - y, 0, y);
                    g.setClip(new Rectangle(0, 0, w, y));
                }
            }
            this.scroll_y = this.newScrollY;
            this.moveComponentBoxes();
        } else if (this.newScrollX != this.scroll_x) {
            if (this.newScrollX > this.scroll_x) {
                int x = this.newScrollX - this.scroll_x;
                if (x < w) {
                    g.copyArea(x, 0, w - x, h, -x, 0);
                    g.setClip(new Rectangle(w - x, 0, x, h));
                }
            } else {
                int x = this.scroll_x - this.newScrollX;
                if (x < w) {
                    g.copyArea(0, 0, w - x, h, x, 0);
                    g.setClip(new Rectangle(0, 0, x, h));
                }
            }
            this.scroll_x = this.newScrollX;
            this.moveComponentBoxes();
        }
        this.paint(g);
    }

    private void clearBackground(Graphics g) {
        Rectangle b = g.getClipBounds();
        if (this.backImage != null) {
            int iw = this.backImage.getWidth(this);
            int ih = this.backImage.getHeight(this);
            if (iw > 0 && ih > 0) {
                int x_start = (-this.scroll_x - b.x) % iw + b.x;
                for (int y = (-this.scroll_y - b.y) % ih + b.y; y < b.y + b.height; y += ih) {
                    for (int x = x_start; x < b.x + b.width; x += iw) {
                        g.drawImage(this.backImage, x, y, this.getBackground(), this);
                    }
                }
            } else {
                g.clearRect(b.x, b.y, b.width, b.height);
            }
        } else if (b != null) {
            g.clearRect(b.x, b.y, b.width, b.height);
        }
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {
        if (img == this.backImage && (info & 0x20) != 0) {
            this.repaint();
        }
        return (info & 0xE0) == 0;
    }

    public void printJob() {
    }

    public void paint(Graphics g) {
        this.clearBackground(g);
        this.vis_doc.paint(g, this.scroll_x, this.scroll_y);
    }

    public void mouseReleased(MouseEvent e) {
        int y;
        int x = e.getX() + this.scroll_x;
        Box b = this.vis_doc.mouseClicked(x, y = e.getY() + this.scroll_y);
        if (b != null && b.getLink() != null) {
            try {
                URL u = new URL(this.getDocumentBase(), b.getLink());
                MouseOverLinkEvent mole = new MouseOverLinkEvent(u, b.getLinkTargetFrame(), b.getOutputString());
                this.getParentDocument().fireMouseOverLinkClickedEvent(mole);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public String getSelectedText(MouseEvent e) {
        int y;
        String text = null;
        int x = e.getX() + this.scroll_x;
        Box b = this.vis_doc.mouseDoubleClicked(x, y = e.getY() + this.scroll_y);
        if (b != null && b instanceof BoxWord) {
            if (this.savebox != null) {
                this.savebox.setGrayOut(false);
            }
            this.savebox = (BoxWord)b;
            this.savebox.setGrayOut(true);
            this.repaint();
            text = this.savebox.getText();
        }
        return text;
    }

    public static void Sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            System.out.println("Sleeping interrupted...");
        }
    }

    public void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX() + this.scroll_x;
        Box b = this.vis_doc.mouseMoved(x, y = e.getY() + this.scroll_y);
        if (b != null && b.getLink() != null) {
            try {
                URL u = new URL(this.getDocumentBase(), b.getLink());
                MouseOverLinkEvent mole = new MouseOverLinkEvent(u, b.getLinkTargetFrame(), b.getOutputString());
                this.setLinkCursor();
                this.getParentDocument().fireMouseOverLinkMovedEvent(mole);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            this.setDefaultCursor();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private synchronized void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            b.setDocContainer(this);
        }
    }
}

