/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ConnectSocketThread;
import innoval.mailer.MsgBox;
import innoval.mailer.PromptNewsServer;
import innoval.mailer.SendItem;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.jstreet;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public class NewsPost {
    private jstreet Jstreet = null;
    private SendItem senditem = null;
    private File popfile = null;
    private String server = null;
    private Socket socket = null;
    private Label text = null;
    private int port = 119;
    private int connectTime = 60;
    private boolean quit = false;
    private BufferedReader in = null;
    private DataOutputStream out = null;

    NewsPost(jstreet Jstreet, SendItem senditem, File popfile) {
        this.Jstreet = Jstreet;
        this.senditem = senditem;
        this.popfile = popfile;
        this.text = Jstreet.text;
        this.server = Jstreet.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NEWS_SERVER, "");
        try {
            this.port = Integer.valueOf(Jstreet.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NEWS_PORT, "119"));
        }
        catch (NumberFormatException e) {
            this.port = 119;
        }
        try {
            this.connectTime = Integer.valueOf(Jstreet.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.SMTPTIMEOUT, "60"));
        }
        catch (NumberFormatException e) {
            this.connectTime = 60;
        }
    }

    public void setQuit(boolean quit) {
        this.quit = quit;
    }

    public boolean uploadMessage() {
        boolean ret_code = true;
        if (this.server == null || this.server.trim().length() == 0) {
            PromptNewsServer prompt = new PromptNewsServer(this.Jstreet);
            if (prompt.getServer() != null) {
                this.server = prompt.getServer();
                this.port = prompt.getPort();
            }
            Object var2_2 = null;
        }
        if (this.server != null && this.server.trim().length() > 0) {
            if (this.connect()) {
                ret_code = this.sendMessage();
                if (ret_code) {
                    this.disconnect();
                }
            } else {
                ret_code = false;
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Error: NEWS server [").concat(String.valueOf(this.server))).concat(String.valueOf(":"))).concat(String.valueOf(this.port))).concat(String.valueOf("] could not be connected.")));
            }
        } else {
            System.out.println("Error: No NEWS server is specified in the General Settings.");
            System.out.println("       News postings cannot be sent.");
            ret_code = false;
        }
        return ret_code;
    }

    private boolean sendMessage() {
        boolean ret_code = true;
        String inchar = null;
        MsgBox msgbox = null;
        if (!this.quit && !(inchar = this.issueCommand("POST")).startsWith("340")) {
            ret_code = false;
            msgbox = new MsgBox(this.Jstreet, String.valueOf("NEWS Error: ").concat(String.valueOf(inchar)));
        }
        if (!this.quit && ret_code) {
            ret_code = this.senditem.uploadNewsMessage(this.out, this.popfile);
            if (!this.quit && ret_code) {
                inchar = this.issueCommand(".");
                if (!inchar.startsWith("240")) {
                    ret_code = false;
                    msgbox = new MsgBox(this.Jstreet, String.valueOf("NEWS Error: ").concat(String.valueOf(inchar)));
                }
            } else if (!ret_code) {
                msgbox = new MsgBox(this.Jstreet, "NEWS Error uploading message text.");
            }
        }
        return ret_code;
    }

    private void disconnect() {
        if (!this.quit) {
            String string = this.issueCommand("quit");
        } else {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String issueCommand(String text) {
        String inchar = new String("");
        try {
            this.out.writeBytes(String.valueOf(text).concat(String.valueOf("\r\n")));
            inchar = this.in.readLine();
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.Jstreet, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return inchar;
    }

    private boolean connect() {
        boolean ret_code;
        block5: {
            ret_code = false;
            this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Connecting to NEWS server...").concat(String.valueOf(this.server))).concat(String.valueOf(" ["))).concat(String.valueOf(this.port))).concat(String.valueOf("]")));
            try {
                this.socket = this.connectSocket(this.text, this.server, this.port);
                if (this.socket != null) {
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    String inchar = this.in.readLine();
                    if (inchar.startsWith("200")) {
                        this.out = new DataOutputStream(this.socket.getOutputStream());
                        this.text.setText("NEWS Connection established...");
                        ret_code = true;
                    } else {
                        MsgBox msgBox = new MsgBox(this.Jstreet, String.valueOf("Unexpected response from NEWS server: ").concat(String.valueOf(inchar)));
                    }
                }
            }
            catch (IOException e) {
                MsgBox box = new MsgBox(this.Jstreet, String.valueOf("Error").concat(String.valueOf(e)));
            }
            if (ret_code) break block5;
            this.text.setText("Error connecting to NEWS server.");
        }
        return ret_code;
    }

    private Socket connectSocket(Label text, String server, int port) {
        Socket socket = null;
        ConnectSocketThread thread = new ConnectSocketThread(this.Jstreet, server, port);
        String oldText = text.getText();
        try {
            thread.start();
            for (int i = this.connectTime; i > 0; --i) {
                thread.join(1000L);
                text.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" [Timeout in: "))).concat(String.valueOf(i))).concat(String.valueOf(" seconds]")));
                if (!thread.isAlive() || this.quit) break;
            }
            text.setText(oldText);
            if (thread.isAlive()) {
                thread.stop();
                if (!this.quit) {
                    MsgBox msgBox = new MsgBox(this.Jstreet, String.valueOf(String.valueOf("Connection attempt timed out after ").concat(String.valueOf(this.connectTime))).concat(String.valueOf(" seconds.")));
                }
            }
            socket = thread.getSocket();
        }
        catch (InterruptedException e) {
            MsgBox msgBox = new MsgBox(this.Jstreet, String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return socket;
    }
}

