/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderIndexItem;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteWin;
import innoval.mailer.NoteWinLoad;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PopFileReader;
import innoval.mailer.jstreet;
import java.awt.Component;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.Vector;

public class NoteWinText
extends TextArea
implements KeyListener {
    private String[] keyCmd = new String[]{"CTRL+PAGE DOWN", "CTRL+PAGE UP", "CTRL+N", "CTRL+B", "CTRL+C", "CTRL+D", "CTRL+F", "CTRL+H", "CTRL+M", "CTRL+P", "CTRL+R", "CTRL+S", "CTRL+W", "CTRL+T", "CTRL+X"};
    private int bottomCnt = 0;
    private jstreet parent;
    private BufferedInputStream in;
    private File popfile = null;
    private NoteWinLoad notewinload;
    private int headerState = 2;
    private int fontSize = 1;
    private int reloads = 0;
    private Vector cmdVector = null;
    private boolean formatState = true;
    private boolean decodeState = true;

    NoteWinText(jstreet frame) {
        this.formatState = false;
        this.initWindow(frame);
    }

    NoteWinText(jstreet frame, boolean formatState) {
        super(new String(""), 1, 1, 1);
        this.formatState = formatState;
        this.initWindow(frame);
    }

    private void initWindow(jstreet frame) {
        this.parent = frame;
        this.setEditable(false);
        this.notewinload = null;
        this.enableEvents(16L);
        this.addKeyListener(this);
        NoteWinText.setupFont(this.formatState, this.fontSize, this);
        this.loadKeyStrokes();
    }

    public static void setupFont(boolean formatState, int fontSize, TextArea text) {
        if (formatState) {
            switch (fontSize) {
                case 0: {
                    text.setFont(new Font("Dialog", 0, 10));
                    break;
                }
                case 1: {
                    text.setFont(new Font("Dialog", 0, 12));
                    break;
                }
                case 2: {
                    text.setFont(new Font("Dialog", 0, 14));
                    break;
                }
                case 3: {
                    text.setFont(new Font("Dialog", 0, 16));
                }
            }
        } else {
            switch (fontSize) {
                case 0: {
                    text.setFont(new Font("Monospaced", 0, 10));
                    break;
                }
                case 1: {
                    text.setFont(new Font("Monospaced", 0, 12));
                    break;
                }
                case 2: {
                    text.setFont(new Font("Monospaced", 0, 14));
                    break;
                }
                case 3: {
                    text.setFont(new Font("Monospaced", 0, 16));
                }
            }
        }
    }

    public void setHeaderState(int val, Label text) {
        this.headerState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public int getHeaderState() {
        return this.headerState;
    }

    public void setFontSize(int val) {
        this.fontSize = val;
        NoteWinText.setupFont(this.formatState, this.fontSize, this);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFormatState(boolean val, Label text) {
        this.formatState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public boolean getFormatState() {
        return this.formatState;
    }

    public void setDecodeState(boolean val, Label text) {
        this.decodeState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public boolean getDecodeState() {
        return this.decodeState;
    }

    public File getFile() {
        return this.popfile;
    }

    public String getPopFile() {
        String pname = "";
        if (this.popfile != null) {
            pname = new String(this.popfile.getName());
        }
        return pname;
    }

    public void processMouseEvent(MouseEvent e) {
        String text;
        boolean ret_code = false;
        if (e.getID() == 501) {
            if (this.popfile != null && e.getModifiers() == 4) {
                this.parent.viewPopup.show(this, e.getX(), e.getY());
                ret_code = true;
            }
        } else if (e.getID() == 500 && e.getClickCount() == 2 && NoteWinText.isUrl(text = this.getSelectedText())) {
            this.parent.runBrowser(text);
        }
        if (!ret_code) {
            super.processMouseEvent(e);
        }
    }

    public static boolean isUrl(String text) {
        boolean ret_code = false;
        String url = new String(jstreet.scrubUrl(text).toLowerCase());
        if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("www.")) {
            ret_code = true;
        }
        return ret_code;
    }

    public void keyPressed(KeyEvent e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            if (this.goToNextPage()) return;
        }
        int cmd = NoteWin.determineCommand(e, this.keyCmd);
        if (cmd < 0) return;
        this.parent.executeNoteCommand(cmd);
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean goToNextPage() {
        Component co = this.getComponentAt(new Point(this.getSize().width - 10, 30));
        boolean ret_code = true;
        int val = 0;
        int max = 0;
        int page = 0;
        int left = max - val;
        if (co != null && co instanceof Scrollbar) {
            Scrollbar scrollbar = (Scrollbar)co;
        }
        if (left <= page) {
            if (this.bottomCnt > 0 || max <= page) {
                this.bottomCnt = 0;
                ret_code = false;
            } else {
                ++this.bottomCnt;
            }
        } else {
            this.bottomCnt = 0;
        }
        return ret_code;
    }

    public String[] getKeyCmd() {
        return this.keyCmd;
    }

    public void clear() {
        this.stopLoading();
        this.setVisible(false);
        this.setText("");
        this.setVisible(true);
        NoteWinText.clearDirectory(this.parent.getAttachDir());
        this.parent.attachbar.setup(this.parent.getAttachDir());
        this.popfile = null;
    }

    public static void clearDirectory(File dir) {
        String[] file = dir.list();
        if (file != null && file.length > 0) {
            for (int i = 0; i < file.length; ++i) {
                File tfile = new File(dir.getPath(), file[i]);
                tfile.delete();
            }
        }
    }

    public void updateTitle(String title) {
    }

    public void sayLine(String text) {
    }

    public void stopLoading() {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
    }

    public synchronized void load(File file, Label text) {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
        this.popfile = file;
        this.sayLine("Starting load thread...");
        this.notewinload = new NoteWinLoad(this, text);
        this.notewinload.start();
    }

    public void reload() {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
        this.notewinload = new NoteWinLoad(this, null);
        this.notewinload.start();
    }

    public synchronized void loadNote(NoteWinLoad thread) {
        PopFileProcedure pop = null;
        FolderIndexItem item = null;
        thread.setText("Loading message...");
        this.sayLine("In thread...");
        this.setVisible(false);
        NoteWinText.clearDirectory(this.parent.getAttachDir());
        this.parent.attachbar.setup(this.parent.getAttachDir());
        ++this.reloads;
        if (this.reloads % 5 == 0) {
            System.gc();
            Runtime.getRuntime().gc();
        }
        if (!thread.getStop()) {
            this.sayLine("Setting up popfileprocedure...");
            pop = new PopFileProcedure();
            thread.setPopFileProcedure(pop);
            pop.setAttachDir(this.parent.getAttachDir());
            pop.setHeaderState(this.headerState);
            pop.setHtml(false);
            pop.setDecode(this.decodeState);
            pop.setFormat(this.formatState);
            pop.setHtmlFontSize(this.fontSize);
        }
        if (!thread.getStop()) {
            this.sayLine("Getting selected message...");
            item = this.parent.getSelectedMessage();
            this.sayLine("Checking sticky note...");
            if (item != null && item.getNotes().length() > 0) {
                pop.setStickyNotes(true);
            } else {
                pop.setStickyNotes(false);
            }
        }
        if (!thread.getStop() && this.popfile != null) {
            if (this.popfile.exists()) {
                this.sayLine("Reading file...");
                pop.readFile(this.parent, this.popfile.getAbsolutePath());
                if (item != null && !thread.getStop() && pop.countAttachments() > 0 && !item.getAttach()) {
                    item.setAttach(true);
                    this.parent.notelist.setDirty();
                    this.parent.notelist.refreshCurrentMessage();
                }
            } else {
                MsgBox msgBox = new MsgBox(this.parent, "The selected message file was not found.");
            }
        }
        if (!thread.getStop()) {
            this.sayLine("Setting attachment toolbar...");
            this.parent.attachbar.setup(this.parent.getAttachDir());
        }
        if (!thread.getStop()) {
            this.sayLine("Loading text window...");
            if (this.popfile.exists()) {
                this.setText(pop.getPopText());
                try {
                    this.setCaretPosition(0);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {}
            } else {
                this.setText("");
            }
            this.setVisible(true);
        }
        this.parent.validateMessageWindow();
        if (thread.getStop()) {
            this.clear();
        }
        this.notewinload = null;
        pop = null;
        this.sayLine("Done.");
        this.requestFocus();
        if (this.parent.notelist.selected() > 1) {
            this.clear();
        }
        thread.setText("");
    }

    public int removeChar(byte[] text, int bytes, char tchar) {
        int cnt = 0;
        for (int i = 0; i < bytes; ++i) {
            if (text[i] == (byte)tchar) continue;
            text[cnt++] = text[i];
        }
        for (int i = cnt; i < bytes; ++i) {
            text[i] = 0;
        }
        return cnt;
    }

    public void loadKeyStrokes() {
        PopFileReader in;
        File file = new File(this.parent.getAccountDir(), jstreet.KEYFILE);
        String text = "";
        if (!file.exists()) {
            file = new File(this.parent.getSystemDir(), jstreet.KEYFILE);
        }
        if (file.exists() && (in = new PopFileReader()).open(file)) {
            this.cmdVector = new Vector();
            for (int i = 0; i < NoteWin.COMMANDS.length; ++i) {
                this.cmdVector.addElement(NoteWin.COMMANDS[i]);
            }
            while (text != null) {
                text = in.lineIn();
                if (text == null || text.trim().length() <= 0 || text.trim().charAt(0) == '*') continue;
                text = new String(text.trim().toUpperCase().replace('\t', ' '));
                this.parseKeyRecord(text);
            }
            in.close();
        }
    }

    public void parseKeyRecord(String text) {
        int spot = text.indexOf(32);
        if (spot > 0) {
            String keys = new String(text.substring(0, spot));
            String cmd = new String(text.substring(spot + 1));
            keys = new String(keys.trim());
            spot = (cmd = new String(cmd.trim())).indexOf(32);
            if (spot >= 0) {
                cmd = new String(cmd.substring(0, spot).trim());
            }
            if ((spot = this.cmdVector.indexOf(cmd)) >= 0 && spot < this.keyCmd.length) {
                this.keyCmd[spot] = new String(keys.replace('_', ' '));
            }
        }
    }
}

