/*
 * Decompiled with CFR 0.152.
 */
package jspell.spellchecker;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import jspell.spellchecker.JSpellToolkit;
import jspell.spellchecker.SpellCheckThread;
import jspell.spellchecker.TextInfo;

public class JSpellCheck
extends Dialog
implements KeyListener,
ItemListener,
ActionListener {
    static final int CX = 450;
    static final int CY = 450;
    public TextInfo textInfo;
    public TextArea usertext;
    public Frame frame;
    public int errorPos;
    public TextField wordField;
    public Label label_2;
    public Label textLabel;
    public List suggList;
    public Button stopButton;
    public Button ignoreAll;
    public Button learnButton;
    public Button ignore;
    public Button replace;
    public Button replaceAll;
    public JSpellToolkit jsc;
    public SpellCheckThread thread;
    public boolean quitChecking = false;
    public boolean threadwaiting = false;

    public JSpellCheck(Frame frame, JSpellToolkit jsc) {
        super(frame, "Spell Checker", true);
        this.jsc = jsc;
        this.textInfo = jsc.getTextInfo();
        this.usertext = jsc.getUserTextArea();
        this.initDialog();
        this.runCheck();
        this.show();
    }

    public void initDialog() {
        Dimension dim = this.getToolkit().getScreenSize();
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + 450, this.getInsets().top + this.getInsets().bottom + 450);
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{7, 11, 2, 2, 14, 8, 12, 41, 14};
        int[] columnWidths = new int[]{4, 10, 115, 72, 10, 104, 8, 3};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        this.wordField = new TextField();
        this.wordField.addKeyListener(this);
        this.add(this.wordField);
        this.replace = new Button();
        this.replace.setLabel("Replace");
        this.replace.addActionListener(this);
        this.replace.addKeyListener(this);
        this.add(this.replace);
        this.label_2 = new Label();
        this.label_2.setFont(new Font("Helvetica", 0, 12));
        this.label_2.setText("Suggestions:");
        this.add(this.label_2);
        this.replaceAll = new Button();
        this.replaceAll.setLabel("Replace All");
        this.replaceAll.addActionListener(this);
        this.replaceAll.addKeyListener(this);
        this.add(this.replaceAll);
        this.suggList = new List(4, false);
        this.suggList.addActionListener(this);
        this.suggList.addItemListener(this);
        this.suggList.addKeyListener(this);
        this.add(this.suggList);
        this.ignore = new Button();
        this.ignore.setLabel("Ignore");
        this.ignore.addActionListener(this);
        this.ignore.addKeyListener(this);
        this.add(this.ignore);
        this.ignoreAll = new Button();
        this.ignoreAll.setLabel("Ignore All");
        this.ignoreAll.addActionListener(this);
        this.ignoreAll.addKeyListener(this);
        this.add(this.ignoreAll);
        this.learnButton = new Button();
        this.learnButton.setLabel("Learn");
        this.learnButton.addActionListener(this);
        this.learnButton.addKeyListener(this);
        this.add(this.learnButton);
        this.stopButton = new Button();
        this.stopButton.setLabel("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.addKeyListener(this);
        this.add(this.stopButton);
        this.textLabel = new Label();
        this.textLabel.setFont(new Font("Helvetica", 0, 12));
        this.add(this.textLabel);
        GridBagConstraints con = new GridBagConstraints();
        this.reset(con);
        con.gridx = 2;
        con.gridy = 2;
        con.gridwidth = 2;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.wordField, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.replace, con);
        this.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 2;
        con.anchor = 17;
        con.fill = 0;
        grid.setConstraints(this.label_2, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.replaceAll, con);
        this.reset(con);
        con.gridx = 2;
        con.gridy = 4;
        con.gridwidth = 2;
        con.gridheight = 4;
        con.anchor = 10;
        con.fill = 1;
        grid.setConstraints(this.suggList, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 4;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.ignore, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.ignoreAll, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 6;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.learnButton, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 7;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.stopButton, con);
        this.reset(con);
        con.gridx = 1;
        con.gridy = 8;
        con.gridwidth = 8;
        con.anchor = 17;
        con.fill = 2;
        grid.setConstraints(this.textLabel, con);
        this.setLayout(grid);
        this.pack();
        this.enableEvents(64L);
        JSpellCheck.centerDialog(this, null);
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void runSpellCheck() {
        this.enableDialog(false);
        this.textLabel.setText("Checking...");
        if (this.jsc.checkWords()) {
            this.textLabel.setText("Found error...");
            this.jsc.selectCurrent();
            this.loadError();
            this.enableDialog(true);
        } else {
            this.textLabel.setText("Spell check completed.");
        }
    }

    public void waitThread() {
        this.setWaiting(true);
        while (this.isWaiting()) {
            JSpellCheck.Sleep(500L);
        }
    }

    public synchronized void setWaiting(boolean val) {
        this.threadwaiting = val;
    }

    public boolean isWaiting() {
        return this.threadwaiting;
    }

    public static void Sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            System.out.println("Sleeping interrupted...");
        }
    }

    public void loadError() {
        ((TextComponent)this.wordField).setText(this.jsc.getCheckWord());
        this.loadSuggestions();
    }

    public void loadSuggestions() {
        String[] sugg = this.jsc.getSuggestions();
        this.suggList.removeAll();
        if (sugg != null && sugg.length > 0) {
            for (int j = 0; j < sugg.length && sugg[j] != null; ++j) {
                this.suggList.addItem(sugg[j]);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.replace;
            if (e.getSource() == this.stopButton) {
                evt = this.stopButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ignore) {
            this.jsc.selectCurrent();
            this.runCheck();
        } else if (e.getSource() == this.suggList) {
            ((TextComponent)this.wordField).setText(this.suggList.getSelectedItem());
            this.textInfo.curPos = this.jsc.getErrPos();
            this.textInfo.setWordsToCheck(true);
            this.jsc.replaceSingle(this.jsc.getCheckWord(), this.wordField.getText());
            this.jsc.updateUserTextArea(this.wordField.getText());
            this.runCheck();
        } else if (e.getSource() == this.ignoreAll) {
            this.jsc.addIgnore(this.jsc.getCheckWord());
            this.runCheck();
        } else if (e.getSource() == this.replace) {
            this.textInfo.curPos = this.jsc.getErrPos();
            this.textInfo.setWordsToCheck(true);
            this.jsc.replaceSingle(this.jsc.getCheckWord(), this.wordField.getText());
            this.jsc.updateUserTextArea(this.wordField.getText());
            this.runCheck();
        } else if (e.getSource() == this.replaceAll) {
            this.textInfo.curPos = this.errorPos;
            this.textInfo.setWordsToCheck(true);
            this.jsc.replaceAll(this.jsc.getCheckWord(), this.wordField.getText());
            this.jsc.updateUserTextArea(this.wordField.getText());
            this.runCheck();
        } else if (e.getSource() == this.learnButton) {
            this.jsc.addLearned(this.jsc.getCheckWord());
            this.runCheck();
        } else if (e.getSource() == this.stopButton) {
            this.quitChecking = true;
            this.setWaiting(false);
            this.close();
        }
    }

    private void runCheck() {
        this.thread = new SpellCheckThread(this);
        this.thread.run();
    }

    private void close() {
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.suggList && e.getStateChange() == 1) {
            ((TextComponent)this.wordField).setText(this.suggList.getSelectedItem());
        }
    }

    private void reset(GridBagConstraints con) {
        con.gridx = -1;
        con.gridy = -1;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.weightx = 0.0;
        con.weighty = 0.0;
        con.anchor = 10;
        con.fill = 0;
        con.insets = new Insets(0, 0, 0, 0);
        con.ipadx = 0;
        con.ipady = 0;
    }

    public void enableDialog(boolean val) {
        this.wordField.setEnabled(val);
        this.suggList.setEnabled(val);
        this.ignoreAll.setEnabled(val);
        this.learnButton.setEnabled(val);
        this.ignore.setEnabled(val);
        this.replace.setEnabled(val);
        this.replaceAll.setEnabled(val);
    }

    public static void centerDialog(Dialog d, Frame f) {
        int yPos;
        int xPos;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int dWidth = d.getSize().width;
        int dHeight = d.getSize().height;
        if (f == null) {
            xPos = (screen.width - dWidth) / 2;
            yPos = (screen.height - dHeight) / 2;
        } else {
            xPos = f.getLocation().x + f.getSize().width / 2 - dWidth / 2;
            yPos = f.getLocation().y + f.getSize().height / 2 - dHeight / 2;
        }
        if (xPos < 0) {
            xPos = (screen.width - dWidth) / 2;
        }
        if (yPos < 0) {
            yPos = (screen.width - dHeight) / 2;
        }
        if (xPos + dWidth > screen.width) {
            xPos = screen.width - dWidth - 10;
        }
        if (yPos + dHeight > screen.height) {
            yPos = screen.height - dHeight - 10;
        }
        ((Component)d).setBounds(xPos, yPos, dWidth, dHeight);
    }
}

