/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.File;
import java.util.Enumeration;
import java.util.Observable;
import sun.misc.Compare;
import sun.misc.Sort;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sunw.hotjava.misc.EditorProperties;

public class ContentViewersManager
extends Observable
implements Compare {
    private static ContentViewersManager manager = null;
    private MimeTable viewers = MimeTable.getDefaultTable();
    private MimeEntry currentViewer;
    private MimeEntry lastRemovedViewer;

    public static void create() {
        ContentViewersManager.getManager();
    }

    public static ContentViewersManager getManager() {
        if (manager == null) {
            manager = new ContentViewersManager();
        }
        return manager;
    }

    private ContentViewersManager() {
        this.setCurrentViewer(this.viewers.find("text/plain"));
    }

    public MimeEntry getContentViewer(String string) {
        return this.viewers.find(string);
    }

    public MimeEntry getContentViewer(String string, String string2) {
        return this.getContentViewer(String.valueOf(string) + "/" + string2);
    }

    public Enumeration getViewersInfo() {
        return this.viewers.elements();
    }

    public MimeEntry getCurrentViewer() {
        return this.currentViewer;
    }

    public void setCurrentViewer(MimeEntry mimeEntry) {
        this.currentViewer = (MimeEntry)mimeEntry.clone();
        this.setChanged();
    }

    public void setCurrentViewerByType(String string) {
        try {
            MimeEntry mimeEntry = this.viewers.find(string);
            this.currentViewer = mimeEntry != null ? (MimeEntry)mimeEntry.clone() : new MimeEntry(string);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("ContentViewersManager.setCurrentViewerByType: " + nullPointerException);
        }
        this.setChanged();
    }

    public void setCurrentViewerByDescription(String string) {
        try {
            MimeEntry mimeEntry = this.viewers.findByDescription(string);
            if (mimeEntry != null) {
                this.currentViewer = (MimeEntry)mimeEntry.clone();
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("ContentViewersManager.setCurrentViewerByDescription: " + nullPointerException);
        }
        this.setChanged();
    }

    public void setType(String string) {
        this.currentViewer.setType(string);
        this.setChanged();
    }

    public void setAction(int n) {
        this.currentViewer.setAction(n);
        this.setChanged();
    }

    public void setCommand(String string) {
        this.currentViewer.setCommand(string);
        this.setChanged();
    }

    public void setDescription(String string) {
        this.currentViewer.setDescription(string);
        this.setChanged();
    }

    public void setFileExtensions(String string) {
        this.currentViewer.setExtensions(string);
        this.setChanged();
    }

    public void setIconFilename(String string) {
        this.currentViewer.setImageFileName(string);
        this.setChanged();
    }

    public void remove(String string) {
        this.viewers.remove(string);
    }

    public void removeCurrentViewer() {
        String string = this.currentViewer.getType();
        this.lastRemovedViewer = this.viewers.remove(string);
        this.currentViewer = null;
        this.setChanged();
    }

    public void undoRemove() {
        if (this.lastRemovedViewer != null) {
            this.setCurrentViewer(this.lastRemovedViewer);
            this.apply();
        }
    }

    public void defineViewer(String string, int n, String string2, String string3, String string4, String string5) {
        MimeEntry mimeEntry = new MimeEntry(string);
        mimeEntry.setAction(n);
        if (string2 != null && string2.length() > 0) {
            mimeEntry.setCommand(string2);
        }
        if (string3 != null && string3.length() > 0) {
            mimeEntry.setExtensions(string3);
        }
        if (string4 != null && string4.length() > 0) {
            mimeEntry.setImageFileName(string4);
        }
        if (string5 != null && string5.length() > 0) {
            mimeEntry.setDescription(string5);
        }
        this.setCurrentViewer(mimeEntry);
        this.setChanged();
    }

    public void apply() {
        this.viewers.add(this.currentViewer);
        this.lastRemovedViewer = null;
        this.setChanged();
    }

    public boolean save() {
        String string;
        String string2 = System.getProperty("user.home");
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if (this.viewers.save(string = String.valueOf(string2) + ".hotjava" + File.separator + "content-types.properties")) {
            EditorProperties editorProperties = (EditorProperties)System.getProperties();
            editorProperties.put("content.types.user.table", string);
            editorProperties.save();
            return true;
        }
        return false;
    }

    public int doCompare(Object object, Object object2) {
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        MimeEntry mimeEntry = (MimeEntry)object;
        MimeEntry mimeEntry2 = (MimeEntry)object2;
        return mimeEntry.getDescription().compareTo(mimeEntry2.getDescription());
    }

    public MimeEntry[] getSortedViewers() {
        Object[] objectArray = new MimeEntry[this.viewers.getSize()];
        Enumeration enumeration = this.getViewersInfo();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n] = (MimeEntry)enumeration.nextElement();
            ++n;
        }
        Sort.quicksort((Object[])objectArray, (Compare)this);
        return objectArray;
    }
}

