/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.text.MessageFormat;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.ui.ProgressDialog;
import sunw.hotjava.ui.ValueBar;

class BPSIndicator
extends Panel {
    private long maxBPS;
    private ValueBar valueBar;
    private Label valueLabel;
    private MessageFormat valueTemplate;
    private Object[] argsArray = new Object[3];
    private Label maxLabel;
    private String maxTemplate;
    private static final Insets myInsets = new Insets(2, 2, 2, 2);

    BPSIndicator() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.valueBar = new ValueBar(100, 20, 0);
        this.addComponent(gridBagLayout, gridBagConstraints, this.valueBar);
        this.valueTemplate = new MessageFormat(Globals.localProps.handleGetString("progressDialog.BPSIndicator.bps", "{0} (max {1}) bps"));
        this.argsArray[0] = "0";
        this.argsArray[1] = "1";
        this.valueLabel = new Label(this.valueTemplate.format(this.argsArray));
        this.addComponent(gridBagLayout, gridBagConstraints, this.valueLabel);
    }

    private void addComponent(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public Insets getInsets() {
        return myInsets;
    }

    void updateBPS(long l) {
        String string = ProgressDialog.convertToReadableValue(l);
        if (l > this.maxBPS) {
            this.maxBPS = l;
            this.valueBar.setMaxValue(l);
        }
        String string2 = ProgressDialog.convertToReadableValue(this.maxBPS);
        this.valueBar.updateValue(l);
        this.argsArray[0] = string;
        this.argsArray[1] = string2;
        this.valueLabel.setText(this.valueTemplate.format(this.argsArray));
        this.valueLabel.invalidate();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

