import innoval.mailer.FilterMessage;
/*
This is a sample InnoVal mail filter class. In creating your own filter
classes it is only necessary to add logic to the getResult method. This method
must exist as a public boolean method and must return either true or false. If
you wish to pass the method string argument(s) from InnoVal's filter
procedure, you may do so by entering comma-delimited strings on the filter
definition screen.  These parameters will automatically be loaded into a
string array called parameterValues and will be available to this class.
Passing parameters in this way allows you to build multiple
filtering scenarios into a single class file.

The following variables are available to you.  You do not need to read the
message file (it has been read by the time this class is instantiated and
values are loaded into these variables).  The variables must be prefaced by
the name give the FilterMessage parameter to getResult (in this sample the
name is "msg"). So to reference the SUBJECT variable, use msg.SUBJECT in your
java statement.

parameterValues[] an array of strings containing the parameters defined for
   the given java filter
FROM              From header (reformed and unfolded)
REPLY_TO          Reply-to header (reformed and unfolded)
TO                To header (reformed and unfolded)
CC                Cc header (reformed and unfolded)
BCC               Bcc header (reformed and unfolded)
DATE              Date header
SUBJECT           Subject header
RECEIVED          Received header
PRIORITY          Priority header
BODY              Text portion of message
ALLHEADERS        Single string containing all header lines
ENTIREMSG         Single string containing complete original message
MSG_FULLPATH      Full path and file name of message file
ATTACHMENTS       Blank delimited string of attachments

*/

public class Sample {

  public boolean getResult(FilterMessage msg) {
    if (msg.SUBJECT.indexOf(msg.parameterValues[0]) >= 0)
      return(true);
    else
      return(false);
  }

  public Sample() {
  }
/*
Within the context of a java filter, you may read the message file, revise its
content and rewrite it. You should not, however, rename it or delete it. If
you rewrite the file or make copies of the file in other JStreet folders, it
is important that it conform to applicable RFC's for POP files.
*/

}

