/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.NeighbourAnt;
import ants.p2p.Router;
import ants.p2p.SenderThread;
import ants.p2p.WarriorAnt;
import ants.p2p.exceptions.NullNeighbourException;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.messages.ControlMessage;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileSizePullErrorControlMessage;
import ants.p2p.messages.FileSizePullMessage;
import ants.p2p.messages.FileSizePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.security.sockets.SecureClientSocket;
import ants.p2p.security.sockets.SecureServerSocket;
import ants.p2p.utils.Base16;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class Ant
extends Thread {
    public static String ConnectionType;
    private static Logger _logger;
    private static final String antRelease = "1.0";
    private static final String antVersion = "beta0.3.7";
    public static int beingRoutedMessages;
    static /* synthetic */ Class class$ants$p2p$Ant;
    public List deliveredMessages;
    public List failedMessages;
    String id = null;
    public static int inTransitDelivered;
    public static int inTransitMessageSizeMax;
    List inTransitMessages;
    public static int maxFailedMessageToTrace;
    public static int maxMessagesToRouteToghether;
    public static int maxNeighbours;
    public static int maxRetransmissions;
    public static int maxRetransmissionsForceDirection;
    public static long messageTimeout;
    public static int myMessageSizeMax;
    public List myMessages;
    Hashtable neighbourEfficiency;
    List neighbours = Collections.synchronizedList(new ArrayList());
    public static int probeCheckInterval;
    public PropertyChangeSupport propertyChangeSupport;
    int serverPort = 4000;
    protected SecureServerSocket sss;
    boolean terminate = false;
    public static double underRateConnections;

    static {
        _logger = Logger.getLogger((class$ants$p2p$Ant == null ? (class$ants$p2p$Ant = Ant.class$("ants.p2p.Ant")) : class$ants$p2p$Ant).getName());
        ConnectionType = "56K";
        myMessageSizeMax = Router.ownDeliveredMessagesQueue;
        inTransitDelivered = Router.ownDeliveredMessagesQueue;
        inTransitMessageSizeMax = Router.inTransitQueue;
        maxNeighbours = 1;
        messageTimeout = 180000L;
        maxRetransmissions = 5;
        maxRetransmissionsForceDirection = 3;
        maxFailedMessageToTrace = 100;
        beingRoutedMessages = 0;
        maxMessagesToRouteToghether = 200;
        probeCheckInterval = 360000;
        underRateConnections = 0.6666666666666666;
    }

    public Ant(String id, int maxNeighbours, int serverPort) {
        this.neighbourEfficiency = new Hashtable();
        this.myMessages = Collections.synchronizedList(new ArrayList());
        this.failedMessages = Collections.synchronizedList(new ArrayList());
        this.deliveredMessages = Collections.synchronizedList(new ArrayList());
        this.inTransitMessages = Collections.synchronizedList(new ArrayList());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.id = id;
        this.serverPort = serverPort;
        if (maxNeighbours >= 1) {
            this.setMaxNeighbours(maxNeighbours);
        }
        this.setPriority(1);
        this.start();
    }

    public void activateNewRouterProcess(Message m, String requirer) throws Exception {
        if (Ant.verifyAndIncBeingRoutedMessages()) {
            Router r = new Router(this, m, requirer);
            if (m instanceof Message) {
                r.setPriority(10);
            } else if (m instanceof ControlMessage || m instanceof FileTransferEndControlMessage || m instanceof FileTransferErrorControlMessage || m instanceof FileSizePullErrorControlMessage || m instanceof HttpTransferEndControlMessage) {
                r.setPriority(10);
            } else if (m instanceof SecurityRequestMessage || m instanceof SecurityResponseMessage || m instanceof FilePullMessage || m instanceof FilePushMessage || m instanceof HttpRequestMessage) {
                r.setPriority(9);
            } else if (m instanceof FileSizePullMessage || m instanceof FileSizePushMessage) {
                r.setPriority(6);
            } else if (m instanceof QueryMessage) {
                QueryMessage qm = (QueryMessage)m;
                if (qm.getQuery() instanceof QueryHashItem) {
                    r.setPriority(5);
                } else if (qm.getQuery() instanceof QueryRandomItem) {
                    r.setPriority(2);
                } else {
                    r.setPriority(6);
                }
            } else if (m instanceof HttpResponsePartMessage) {
                r.setPriority(4);
            } else if (m instanceof FilePartMessage) {
                r.setPriority(3);
            }
            if (Router.PARALLEL) {
                r.start();
            } else {
                r.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNeighbour(String remoteAddress, int port, boolean isRequirer, InetAddress localhost) throws Exception {
        InetAddress remote = InetAddress.getByName(remoteAddress);
        if ((remote.isLoopbackAddress() || remote.isAnyLocalAddress() || remote.isLinkLocalAddress() || remote.isSiteLocalAddress()) && port == this.getServerPort()) {
            return;
        }
        if (localhost.getHostAddress().equals(remote.getHostAddress()) && port == this.getServerPort()) {
            return;
        }
        int x = 0;
        while (x < this.neighbours.size()) {
            NeighbourAnt na = (NeighbourAnt)this.neighbours.get(x);
            if (na.getId().equals(remoteAddress + ":" + port) || na.getRemoteId().equals(remoteAddress + ":" + port) || (na.s.getInetAddress().isLoopbackAddress() || na.s.getInetAddress().isAnyLocalAddress() || na.s.getInetAddress().isLinkLocalAddress() || na.s.getInetAddress().isSiteLocalAddress()) && (na.remoteServerPort == port || na.port == port)) {
                return;
            }
            ++x;
        }
        SecureClientSocket scs = new SecureClientSocket(remoteAddress, port, this.getServerPort());
        if (!scs.isClosed()) {
            _logger.info(scs.getInetAddress().getHostAddress() + ": Local time elapsed: " + scs.getTimeElapsed() + "[Thresold: " + this.getRateThresold() + "]");
            if ((double)this.getUnderRatedNeighbours() >= Math.floor((double)maxNeighbours * underRateConnections)) {
                if (scs.getTimeElapsed() >= (long)this.getRateThresold()) {
                    throw new Exception(scs.getInetAddress().getHostAddress() + ": Rejected neighbour cause it doesn't satisfy bandwith request: [" + this.getUnderRatedNeighbours() + "/" + Math.floor((double)maxNeighbours * underRateConnections) + "]");
                }
            }
            NeighbourAnt n = new NeighbourAnt(this, remoteAddress, port, scs.getLocalServerPort(), scs.getCipherEnc(), scs.getCipherDec(), scs, isRequirer, scs.getTimeElapsed());
            List list = this.neighbours;
            synchronized (list) {
                Hashtable hashtable = this.neighbourEfficiency;
                synchronized (hashtable) {
                    if (this.neighbours.size() >= maxNeighbours || this.neighbours.contains(n)) {
                        n.terminate();
                        if (this.neighbours.size() >= maxNeighbours) {
                            throw new Exception(this.getId() + ": Max neighbourg number reached");
                        }
                        if (this.neighbours.contains(n)) {
                            throw new Exception(this.getId() + ": Neighbourg already connected");
                        }
                        throw new Exception(this.getId() + ": Strange thing in neighbour add process.");
                    }
                    this.neighbours.add(n);
                    this.neighbourEfficiency.put(n.getId() + "", new Integer(0));
                }
            }
            _logger.debug(this.getId() + ": Added Neighbourg from address IP(local): " + n.getId() + " IP(remote): " + n.getRemoteId());
            this.propertyChangeSupport.firePropertyChange("newNeighbour", null, n);
        } else {
            _logger.info(this.getId() + ": Connection rejected...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNeighbour(NeighbourAnt n) throws Exception {
        List list = this.neighbours;
        synchronized (list) {
            Hashtable hashtable = this.neighbourEfficiency;
            synchronized (hashtable) {
                if (this.neighbours.size() >= maxNeighbours || this.neighbours.contains(n)) {
                    if (this.neighbours.size() >= maxNeighbours) {
                        throw new Exception(this.getId() + ": Max neighbourg number reached");
                    }
                    if (this.neighbours.contains(n)) {
                        throw new Exception(this.getId() + ": Neighbourg already connected");
                    }
                    throw new Exception(this.getId() + ": Strange thing in neighbour add process.");
                }
                this.neighbours.add(n);
                this.neighbourEfficiency.put(n.getId() + "", new Integer(0));
            }
        }
        _logger.debug(this.getId() + ": Added Neighbour by request IP(local): " + n.getId() + " IP(remote): " + n.getRemoteId());
        this.propertyChangeSupport.firePropertyChange("newNeighbour", null, n);
    }

    public NeighbourAnt checkForRoute(MessageWrapper wm, boolean jump) {
        int x = 0;
        while (x < this.deliveredMessages.size() && !jump) {
            NeighbourAnt n;
            MessageWrapper old = (MessageWrapper)this.deliveredMessages.get(x);
            if (old.getMessage().getDest().equals(wm.getMessage().getDest()) && old.getMessage().getDelivered()) {
                n = this.getNeighbour(old.getRoutedTo());
                if (n != null) {
                    this.traceMyMessage(wm, old.getRoutedTo());
                    _logger.debug(this.getId() + ": Routing message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + wm.getRoutedTo());
                    this.deliveredMessages.remove(old);
                    this.deliveredMessages.add(old);
                    return n;
                }
            } else if (old.getMessage().getSource().equals(wm.getMessage().getDest()) && old.getMessage().getDelivered() && (n = this.getNeighbour(old.getRequirer())) != null) {
                this.traceMyMessage(wm, old.getRequirer());
                _logger.debug(this.getId() + ": Routing message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + wm.getRoutedTo());
                this.deliveredMessages.remove(old);
                this.deliveredMessages.add(old);
                return n;
            }
            ++x;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static void decBeingRoutedMessages() {
        --beingRoutedMessages;
    }

    public void disconnect() {
        try {
            int x = 0;
            while (x < this.neighbours.size()) {
                NeighbourAnt na = (NeighbourAnt)this.neighbours.get(x);
                na.terminate();
                ++x;
            }
            if (this.sss != null) {
                this.sss.close();
                this.sss.serverThread.stop();
            }
            this.terminate = true;
            this.stop();
        }
        catch (Exception e) {
            _logger.error(this.getId() + "", e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Ant) {
            return ((Ant)o).getId().equals(this.getId());
        }
        return o == this;
    }

    public NeighbourAnt findBestNeighbour(List alreadyRoutedTo, List alreadyComingFrom, String source, boolean resolveLoop, boolean jump) {
        String bestNeighbour = null;
        if (jump) {
            Enumeration neighbours = this.neighbourEfficiency.keys();
            List<String> avaiableNeighbours = Collections.synchronizedList(new ArrayList());
            List<String> notVisitedNeighbours = Collections.synchronizedList(new ArrayList());
            while (neighbours.hasMoreElements()) {
                String currentNeighbour = (String)neighbours.nextElement();
                if (this.getNeighbour(currentNeighbour) == null) {
                    this.neighbourEfficiency.remove(currentNeighbour);
                }
                if (!(alreadyRoutedTo.contains(currentNeighbour) || alreadyComingFrom.contains(currentNeighbour) || currentNeighbour.equals(source))) {
                    notVisitedNeighbours.add(currentNeighbour);
                    continue;
                }
                if (alreadyRoutedTo.contains(currentNeighbour) || currentNeighbour.equals(source)) continue;
                avaiableNeighbours.add(currentNeighbour);
            }
            if (avaiableNeighbours.size() == 0 && notVisitedNeighbours.size() == 0 && (alreadyRoutedTo.contains(source) || source.equals(this.getId()))) {
                bestNeighbour = null;
            } else if (avaiableNeighbours.size() == 0 && notVisitedNeighbours.size() == 0 && !source.equals(this.getId()) && !alreadyRoutedTo.contains(source)) {
                bestNeighbour = source;
            } else if (notVisitedNeighbours.size() > 0) {
                int index = (int)Math.ceil(Math.random() * (double)notVisitedNeighbours.size());
                int x = 0;
                while (x < index) {
                    bestNeighbour = (String)notVisitedNeighbours.get(x);
                    ++x;
                }
            } else if (avaiableNeighbours.size() > 0) {
                int index = (int)Math.ceil(Math.random() * (double)avaiableNeighbours.size());
                int x = 0;
                while (x < index) {
                    bestNeighbour = (String)avaiableNeighbours.get(x);
                    ++x;
                }
            }
        } else {
            int efficiency = Integer.MIN_VALUE;
            if (resolveLoop) {
                efficiency = Integer.MAX_VALUE;
            }
            Enumeration neighbours = this.neighbourEfficiency.keys();
            Enumeration efficiencies = this.neighbourEfficiency.elements();
            while (efficiencies.hasMoreElements()) {
                double mustSelect;
                String currentNeighbour = (String)neighbours.nextElement();
                if (this.getNeighbour(currentNeighbour) == null) {
                    this.neighbourEfficiency.remove(currentNeighbour);
                }
                int currentEfficiency = (Integer)efficiencies.nextElement();
                if (!alreadyComingFrom.contains(currentNeighbour) && !resolveLoop) {
                    currentEfficiency += Router.efficiencyLimit;
                } else if (!alreadyComingFrom.contains(currentNeighbour) && resolveLoop) {
                    currentEfficiency -= Router.efficiencyLimit;
                }
                if ((efficiency < currentEfficiency && !resolveLoop || efficiency > currentEfficiency && resolveLoop) && !alreadyRoutedTo.contains(currentNeighbour) && !currentNeighbour.equals(source)) {
                    efficiency = currentEfficiency;
                    bestNeighbour = currentNeighbour;
                    continue;
                }
                if (efficiency != currentEfficiency || alreadyRoutedTo.contains(currentNeighbour) || currentNeighbour.equals(source) || !((mustSelect = Math.random()) < 0.5)) continue;
                bestNeighbour = currentNeighbour;
            }
            if (bestNeighbour == null && !source.equals(this.getId()) && !alreadyRoutedTo.contains(source)) {
                bestNeighbour = source;
            }
        }
        return this.getNeighbour(bestNeighbour);
    }

    public List getFailedMessages() {
        return this.failedMessages;
    }

    public String getId() {
        return this.id;
    }

    public int getMaxNeighbours() {
        return maxNeighbours;
    }

    public MessageWrapper getMessage(String id) {
        int x = 0;
        while (x < this.myMessages.size()) {
            if (((MessageWrapper)this.myMessages.get(x)).getMessage().getAck_Id().equals(id)) {
                return (MessageWrapper)this.myMessages.get(x);
            }
            ++x;
        }
        return null;
    }

    public NeighbourAnt getNeighbour(String id) {
        int x = 0;
        while (x < this.neighbours.size()) {
            if (((NeighbourAnt)this.neighbours.get(x)).getId().equals(id) || ((NeighbourAnt)this.neighbours.get(x)).getRemoteId().equals(id)) {
                return (NeighbourAnt)this.neighbours.get(x);
            }
            ++x;
        }
        return null;
    }

    public List getNeighbours() {
        return this.neighbours;
    }

    public int getNeighboursNumber() {
        return this.neighbours.size();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public static int getRateThresold() {
        int rateThresold = Integer.MAX_VALUE;
        if (ConnectionType.equals("56K")) {
            rateThresold = Integer.MAX_VALUE;
        } else if (ConnectionType.equals("ISDN")) {
            rateThresold = Integer.MAX_VALUE;
        } else if (ConnectionType.equals("DSL")) {
            rateThresold = 3000;
        } else if (ConnectionType.equals("CABLE")) {
            rateThresold = 1500;
        } else if (ConnectionType.equals("LAN T3")) {
            rateThresold = 750;
        } else if (ConnectionType.equals("LAN T2")) {
            rateThresold = 375;
        } else if (ConnectionType.equals("LAN T1")) {
            rateThresold = 186;
        } else if (ConnectionType.equals("LAN or Fiber Net")) {
            rateThresold = 186;
        }
        return rateThresold;
    }

    public static String getRelease() {
        return antRelease;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public synchronized int getUnderRatedNeighbours() {
        int rateThresold = this.getRateThresold();
        int underRatedNeighbours = 0;
        int x = 0;
        while (x < this.getNeighbours().size()) {
            if (((NeighbourAnt)this.getNeighbours().get(x)).getTimeElapsed() >= (long)rateThresold) {
                ++underRatedNeighbours;
            }
            ++x;
        }
        return underRatedNeighbours;
    }

    public static String getVersion() {
        return antVersion;
    }

    public boolean isDisconnected() {
        return this.terminate;
    }

    void processMessage(Message m, Router r) throws Exception {
        _logger.debug(this.getId() + ": Received Message = " + m.getAck_Id() + " type = " + m.getType() + " from a peer running version: " + m.getVersion());
        double mustDie = Math.random() * 100.0;
        if (m.getType() == 2 && m.getTTL() == 0L && mustDie < (double)r.dieProbability) {
            _logger.info(this.getId() + ": Broadcast message timed out. " + m.getAck_Id() + " type = " + m.getType() + " from a peer running version: " + m.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNeighbour(NeighbourAnt n) {
        List list = this.neighbours;
        synchronized (list) {
            Hashtable hashtable = this.neighbourEfficiency;
            synchronized (hashtable) {
                try {
                    this.neighbours.remove(n);
                    this.neighbourEfficiency.remove(n.getId() + "");
                    n.terminate();
                }
                catch (Exception e) {
                    _logger.error(this.getId() + "", e);
                }
            }
        }
    }

    private SenderThread[] retransmitMessage(MessageWrapper wm) {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            _logger.error(this.getId() + "", e);
        }
        try {
            if (wm.getRetrasmissions() > maxRetransmissions) {
                throw new Exception("Retransmissions exceeeded");
            }
            _logger.debug(this.getId() + ": Retransmitting Message from id = " + this.getId() + " to id = " + wm.getMessage().getDest() + " message id = " + wm.getMessage().getAck_Id());
            wm.getMessage().resetResolveLoop();
            wm.getMessage().resetTTL();
            wm.getMessage().resetDelivered();
            boolean jump = false;
            if (Math.random() < Router.jumpProbability) {
                jump = true;
            }
            if (wm.getMessage().getType() == 2) {
                jump = true;
            }
            if (wm.getRetrasmissions() <= maxRetransmissionsForceDirection) {
                wm.notToBeConsidered = Collections.synchronizedList(new ArrayList());
                wm.alreadyVisited = Collections.synchronizedList(new ArrayList());
            } else if (!wm.notToBeConsidered.contains(wm.getRoutedTo())) {
                wm.notToBeConsidered.add(wm.getRoutedTo());
                wm.alreadyVisited.remove(wm.getRoutedTo());
            }
            NeighbourAnt n = this.checkForRoute(wm, jump);
            if (n != null) {
                SenderThread[] st = new SenderThread[]{n.route(wm.getMessage())};
                return st;
            }
            n = this.findBestNeighbour(wm.notToBeConsidered, wm.alreadyVisited, this.getId(), wm.getMessage().getResolveLoop(), jump);
            if (n != null) {
                this.traceMyMessage(wm, n.getId());
                _logger.debug(this.getId() + ": Routing (retransmission) message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + wm.getRoutedTo());
                SenderThread[] st = new SenderThread[]{n.route(wm.getMessage())};
                return st;
            }
            boolean x = false;
            throw new Exception(this.getId() + ": Destination (retransmission) unreachable for message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType());
        }
        catch (Exception e) {
            _logger.error(this.getId() + "", e);
            return null;
        }
    }

    public SenderThread[] route(MessageWrapper wm, Message m, String requirer, Router r, boolean external, boolean retransmission) throws Exception {
        if (external) {
            return this.routeExternalMessage(m, requirer, r);
        }
        if (!external && retransmission) {
            return this.retransmitMessage(wm);
        }
        return this.routeMyMessage(wm);
    }

    private SenderThread[] routeExternalMessage(Message m, String requirer, Router r) throws Exception {
        try {
            boolean jump = false;
            if (Math.random() < Router.jumpProbability) {
                jump = true;
            }
            if (m.getType() == 2) {
                jump = true;
            }
            NeighbourAnt requirerAnt = this.getNeighbour(requirer);
            if (Router.delay > 0) {
                Thread.sleep((long)Math.floor((double)Router.delay * Math.random()));
            }
            if (m.ttl > Router.timeToLive) {
                m.ttl = Router.timeToLive;
            }
            m.decTTL();
            double mustDie = Math.random() * 100.0;
            if (m.getType() != 2 && m.getTTL() == 0L && mustDie < (double)r.dieProbability) {
                throw new Exception(this.getId() + ": Destination node " + m.getDest() + " unreachable for message from node " + m.getSource() + " with id " + m.ack_id + " type = " + m.getType() + " Reason: Connection Timeout");
            }
            if (this.neighbours.size() == 0) {
                throw new Exception(this.getId() + ": Destination node " + m.getDest() + " unreachable for message from node " + m.getSource() + " with id " + m.ack_id + " type = " + m.getType() + "\nReason: No Route Found " + "Node " + this.getId() + " has no neighbours");
            }
            if (this.myMessages.contains(m)) {
                if (this.getNeighbour(requirer) != null && m.getType() != 2) {
                    int efficiency = (Integer)this.neighbourEfficiency.get(requirer + "");
                    if (efficiency > -Router.efficiencyLimit && (efficiency = (int)((double)efficiency - (double)(Router.timeToLive - (((MessageWrapper)this.myMessages.get(this.myMessages.indexOf(m))).getMessage().getTTL() - m.getTTL())) * 1.0 / (double)Router.timeToLive * (double)Router.efficiencyModifier)) < -Router.efficiencyLimit) {
                        efficiency = -Router.efficiencyLimit;
                    }
                    this.neighbourEfficiency.put(requirer + "", new Integer(efficiency));
                }
                if (m.getType() != 2) {
                    int index = this.myMessages.indexOf(m);
                    MessageWrapper wm = (MessageWrapper)this.myMessages.get(index);
                    if (wm.getRetrasmissions() < m.getRetrasmissions() && m.getRetrasmissions() <= maxRetransmissionsForceDirection) {
                        wm.notToBeConsidered = Collections.synchronizedList(new ArrayList());
                        wm.alreadyVisited = Collections.synchronizedList(new ArrayList());
                    } else {
                        if (!wm.notToBeConsidered.contains(wm.getRoutedTo())) {
                            wm.notToBeConsidered.add(wm.getRoutedTo());
                            wm.alreadyVisited.remove(wm.getRoutedTo());
                        }
                        if (!wm.alreadyVisited.contains(requirer)) {
                            wm.alreadyVisited.add(requirer);
                        }
                    }
                    int x = 0;
                    while (x < this.deliveredMessages.size() && !jump) {
                        NeighbourAnt n;
                        MessageWrapper old = (MessageWrapper)this.deliveredMessages.get(x);
                        if (old.getMessage().getDest().equals(m.getDest()) && !wm.notToBeConsidered.contains(old.getRoutedTo()) && old.getMessage().getDelivered()) {
                            n = this.getNeighbour(old.getRoutedTo());
                            if (n != null) {
                                this.traceMyMessage(wm, old.getRoutedTo());
                                _logger.debug(this.getId() + ": A Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                                this.deliveredMessages.remove(old);
                                this.deliveredMessages.add(0, old);
                                SenderThread[] st = new SenderThread[]{n.route(m)};
                                return st;
                            }
                        } else if (old.getMessage().getSource().equals(m.getDest()) && !wm.notToBeConsidered.contains(old.getRequirer()) && old.getMessage().getDelivered() && (n = this.getNeighbour(old.getRequirer())) != null) {
                            this.traceMyMessage(wm, old.getRequirer());
                            _logger.debug(this.getId() + ": D Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                            this.deliveredMessages.remove(old);
                            this.deliveredMessages.add(0, old);
                            SenderThread[] st = new SenderThread[]{n.route(m)};
                            return st;
                        }
                        ++x;
                    }
                    NeighbourAnt n = this.findBestNeighbour(wm.notToBeConsidered, wm.alreadyVisited, requirer, m.getResolveLoop(), jump);
                    if (n != null) {
                        this.traceMyMessage(wm, n.getId());
                        _logger.debug(this.getId() + ": Message with id = " + m.ack_id + " type = " + m.getType() + " returned. Not considering node " + wm.getRoutedTo() + " routing to node " + n.getId());
                        SenderThread[] st = new SenderThread[]{n.route(m)};
                        return st;
                    }
                    throw new Exception(this.getId() + ": Destination node " + m.getDest() + " unreachable for message from node " + m.getSource() + " with id " + m.ack_id + " type = " + m.getType() + "\nReason: No Route Found " + "Node " + this.getId() + " excluded all its " + wm.notToBeConsidered.size() + " neghbours");
                }
                _logger.debug(this.getId() + ": Broadcast Message returned no more node avaiable to send. Killing...");
                return null;
            }
            if (!m.getDest().equals(this.getId())) {
                if (!this.inTransitMessages.contains(m)) {
                    NeighbourAnt n;
                    if (m.getType() == 1) {
                        int k = 0;
                        while (k < this.inTransitMessages.size()) {
                            MessageWrapper inTransit = (MessageWrapper)this.inTransitMessages.get(k);
                            if ((inTransit.getMessage().getType() == 0 || inTransit.getMessage().getType() == 2) && inTransit.getMessage().getAck_Id().equals(m.ack_id) && (n = this.getNeighbour(inTransit.getRequirer())) != null) {
                                int efficiency = (Integer)this.neighbourEfficiency.get(n.getId() + "");
                                if (efficiency < Router.efficiencyLimit && (efficiency = (int)((double)efficiency + (double)m.getTTL() * 1.0 / (double)Router.timeToLive * (double)Router.efficiencyModifier)) > Router.efficiencyLimit) {
                                    efficiency = Router.efficiencyLimit;
                                }
                                this.neighbourEfficiency.put(n.getId() + "", new Integer(efficiency));
                                inTransit.getMessage().invalidate();
                                if (inTransit.getMessage().getType() == 2) {
                                    inTransit.setRoutedTo(requirer);
                                }
                                this.traceDeliveredMessage(inTransit);
                                _logger.debug(this.getId() + ": C Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                                SenderThread[] st = new SenderThread[]{n.route(m)};
                                return st;
                            }
                            ++k;
                        }
                    }
                    if (m.getType() == 2) {
                        this.processMessage(m, r);
                        ArrayList<SenderThread> threadsList = new ArrayList<SenderThread>();
                        int x = 0;
                        while (x < this.getNeighbours().size()) {
                            NeighbourAnt n2;
                            double mustRoute = Math.random() * 100.0;
                            int ttlRouteFactor = (int)Math.floor((double)m.getTTL() * 1.0 / (double)WarriorAnt.maxQueryTimeToLive * 85.0);
                            if ((m.getTTL() != 0L || mustRoute < (double)(r.routeProbability + ttlRouteFactor)) && (n2 = (NeighbourAnt)this.getNeighbours().get(x)) != null && !n2.getId().equals(requirer)) {
                                try {
                                    SenderThread broadSender = n2.route(m);
                                    threadsList.add(broadSender);
                                    _logger.debug(this.getId() + ": Flooding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n2.getId());
                                }
                                catch (Exception e) {
                                    _logger.error("Cannot flood to neighbour", e);
                                }
                            }
                            ++x;
                        }
                        this.traceMessage(m, requirer, "");
                        SenderThread[] st = new SenderThread[threadsList.size()];
                        int x2 = 0;
                        while (x2 < threadsList.size()) {
                            st[x2] = (SenderThread)threadsList.get(x2);
                            ++x2;
                        }
                        return st;
                    }
                    int x = 0;
                    while (x < this.deliveredMessages.size() && !jump) {
                        MessageWrapper old = (MessageWrapper)this.deliveredMessages.get(x);
                        if (old.getMessage().getDest().equals(m.getDest()) && old.getMessage().getDelivered()) {
                            n = this.getNeighbour(old.getRoutedTo());
                            if (n != null) {
                                this.traceMessage(m, requirer, old.getRoutedTo());
                                _logger.debug(this.getId() + ": A Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                                this.deliveredMessages.remove(old);
                                this.deliveredMessages.add(0, old);
                                SenderThread[] st = new SenderThread[]{n.route(m)};
                                return st;
                            }
                        } else if (old.getMessage().getSource().equals(m.getDest()) && old.getMessage().getDelivered() && (n = this.getNeighbour(old.getRequirer())) != null) {
                            this.traceMessage(m, requirer, old.getRequirer());
                            _logger.debug(this.getId() + ": D Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                            this.deliveredMessages.remove(old);
                            this.deliveredMessages.add(0, old);
                            SenderThread[] st = new SenderThread[]{n.route(m)};
                            return st;
                        }
                        ++x;
                    }
                    NeighbourAnt n3 = this.findBestNeighbour(Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), requirer, m.getResolveLoop(), jump);
                    if (n3 != null) {
                        _logger.debug(this.getId() + ": B Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n3.getId());
                        this.traceMessage(m, requirer, n3.getId());
                        SenderThread[] st = new SenderThread[]{n3.route(m)};
                        return st;
                    }
                    throw new NullNeighbourException(this.getId() + ": Destination node " + m.getDest() + " unreachable for message from node " + m.getSource() + " with id " + m.ack_id + " type = " + m.getType() + "\nReason: No Route Found with no excluded neghbours");
                }
                int index = this.inTransitMessages.indexOf(m);
                MessageWrapper wm = (MessageWrapper)this.inTransitMessages.get(index);
                if (this.getNeighbour(requirer) != null && m.getType() != 2) {
                    int efficiency = (Integer)this.neighbourEfficiency.get(requirer + "");
                    if (efficiency > -Router.efficiencyLimit && (efficiency = (int)((double)efficiency - (double)(Router.timeToLive - (((MessageWrapper)this.inTransitMessages.get(this.inTransitMessages.indexOf(m))).getMessage().getTTL() - m.getTTL())) * 1.0 / (double)Router.timeToLive * (double)Router.efficiencyModifier)) < -Router.efficiencyLimit) {
                        efficiency = -Router.efficiencyLimit;
                    }
                    this.neighbourEfficiency.put(requirer + "", new Integer(efficiency));
                }
                if (m.getType() != 2) {
                    if (wm.getRetrasmissions() < m.getRetrasmissions() && m.getRetrasmissions() <= maxRetransmissionsForceDirection) {
                        wm.notToBeConsidered = Collections.synchronizedList(new ArrayList());
                        wm.alreadyVisited = Collections.synchronizedList(new ArrayList());
                    } else {
                        if (!wm.notToBeConsidered.contains(wm.getRoutedTo())) {
                            wm.notToBeConsidered.add(wm.getRoutedTo());
                            wm.alreadyVisited.remove(wm.getRoutedTo());
                        }
                        if (!wm.alreadyVisited.contains(requirer)) {
                            wm.alreadyVisited.add(requirer);
                        }
                    }
                    _logger.debug(this.getId() + ": Message with id = " + m.ack_id + " type = " + m.getType() + " returned. Not considering node " + wm.getRoutedTo());
                    int x = 0;
                    while (x < this.deliveredMessages.size() && !jump) {
                        NeighbourAnt n;
                        MessageWrapper old = (MessageWrapper)this.deliveredMessages.get(x);
                        if (old.getMessage().getDest().equals(m.getDest()) && !wm.notToBeConsidered.contains(old.getRoutedTo()) && old.getMessage().getDelivered()) {
                            n = this.getNeighbour(old.getRoutedTo());
                            if (n != null) {
                                wm.setRoutedTo(old.getRoutedTo());
                                _logger.debug(this.getId() + ": A Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                                this.deliveredMessages.remove(old);
                                this.deliveredMessages.add(0, old);
                                SenderThread[] st = new SenderThread[]{n.route(m)};
                                return st;
                            }
                        } else if (old.getMessage().getSource().equals(m.getDest()) && !wm.notToBeConsidered.contains(old.getRequirer()) && old.getMessage().getDelivered() && (n = this.getNeighbour(old.getRequirer())) != null) {
                            wm.setRoutedTo(old.getRoutedTo());
                            _logger.debug(this.getId() + ": D Forwarding message with id = " + m.ack_id + " type = " + m.getType() + " to id = " + n.getId());
                            this.deliveredMessages.remove(old);
                            this.deliveredMessages.add(0, old);
                            SenderThread[] st = new SenderThread[]{n.route(m)};
                            return st;
                        }
                        ++x;
                    }
                    NeighbourAnt n = this.findBestNeighbour(wm.notToBeConsidered, wm.alreadyVisited, wm.getRequirer(), m.getResolveLoop(), jump);
                    if (n != null) {
                        wm.setRoutedTo(n.getId());
                        this.inTransitMessages.remove(wm);
                        this.inTransitMessages.add(wm);
                        SenderThread[] st = new SenderThread[]{n.route(m)};
                        return st;
                    }
                    throw new NullNeighbourException(this.getId() + ": Destination node " + m.getDest() + " unreachable for message from node " + m.getSource() + " with id " + m.ack_id + " type = " + m.getType() + "\nReason: No Route Found Node " + this.getId() + " excluded all its " + wm.notToBeConsidered.size() + " neghbours");
                }
                _logger.debug(this.getId() + ": D Flooded message with id = " + m.ack_id + " type = " + m.getType() + " returned. Killing!");
                return null;
            }
            if (m.getDest().equals(this.getId())) {
                if (this.getNeighbour(requirer) != null && m.getType() != 2) {
                    int efficiency = (Integer)this.neighbourEfficiency.get(requirer + "");
                    if (efficiency < Router.efficiencyLimit && (efficiency = (int)((double)efficiency + (double)m.getTTL() * 1.0 / (double)Router.timeToLive * (double)Router.efficiencyModifier)) > Router.efficiencyLimit) {
                        efficiency = Router.efficiencyLimit;
                    }
                    this.neighbourEfficiency.put(requirer + "", new Integer(efficiency));
                }
                if (m.getType() == 0 && !m.getSource().equals("")) {
                    _logger.debug(this.getId() + ": Received Message sending Ack for message with id = " + m.ack_id + " type = " + m.getType());
                    MessageWrapper toBeStored = new MessageWrapper(m, requirer);
                    toBeStored.setStoreFormat();
                    this.traceDeliveredMessage(toBeStored);
                    Message ackMessage = new Message();
                    ackMessage.fillMessageProperties(this.getId(), m.getSource(), 1, m.ack_id);
                    MessageWrapper wm = new MessageWrapper(ackMessage, requirer);
                    this.processMessage(m, r);
                    if (this.getNeighbour(requirer) != null) {
                        SenderThread[] st = new SenderThread[]{this.getNeighbour(requirer).route(new Message(wm))};
                        return st;
                    }
                    NeighbourAnt n = this.findBestNeighbour(Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), requirer, m.getResolveLoop(), jump);
                    SenderThread[] st = new SenderThread[]{n.route(new Message(wm))};
                    return st;
                }
                if ((m.getType() == 0 || m.getType() == 1) && m.getSource().equals("")) {
                    _logger.debug(this.getId() + ": Received Message with masked source id = " + m.ack_id + " type = " + m.getType());
                    this.processMessage(m, r);
                    return null;
                }
                if (m.getType() == 1) {
                    if (this.getMessage(m.ack_id) != null) {
                        if (m instanceof Message) {
                            MessageWrapper movingMessage = null;
                            movingMessage = this.getMessage(m.ack_id);
                            if (movingMessage != null) {
                                movingMessage.getMessage().invalidate();
                                this.myMessages.remove(movingMessage);
                                this.traceDeliveredMessage(movingMessage);
                                Ant.decBeingRoutedMessages();
                            } else {
                                Ant.decBeingRoutedMessages();
                            }
                        }
                        _logger.debug(this.getId() + ": Message succesfully routed id = " + m.ack_id + " type = " + m.getType());
                        this.processMessage(m, r);
                        return null;
                    }
                    _logger.debug(this.getId() + ": (Retransmission) Message succesfully routed id = " + m.ack_id + " type = " + m.getType());
                    this.processMessage(m, r);
                    return null;
                }
                throw new Exception(this.getId() + ": There is something strange(2) for message with id = " + m.ack_id + " type = " + m.getType());
            }
            throw new Exception(this.getId() + ": There is something strange(3) for message with id = " + m.ack_id + " type = " + m.getType());
        }
        catch (Exception e) {
            _logger.error(this.getId() + " routing error: ", e);
            return null;
        }
    }

    private SenderThread[] routeMyMessage(MessageWrapper wm) throws Exception {
        boolean jump = false;
        if (Math.random() < Router.jumpProbability) {
            jump = true;
        }
        if (wm.getMessage().getType() == 2) {
            jump = true;
        }
        if (wm.getMessage().getType() != 2) {
            NeighbourAnt n = this.checkForRoute(wm, jump);
            if (n != null) {
                SenderThread[] st = new SenderThread[]{n.route(wm.getMessage())};
                return st;
            }
            n = this.findBestNeighbour(Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), this.getId(), wm.getMessage().getResolveLoop(), jump);
            if (n != null) {
                this.traceMyMessage(wm, n.getId());
                _logger.debug(this.getId() + ": Routing message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + wm.getRoutedTo());
                SenderThread[] st = new SenderThread[]{n.route(wm.getMessage())};
                return st;
            }
            throw new Exception(this.getId() + ": Destination unreachable for message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType());
        }
        ArrayList<SenderThread> threadsList = new ArrayList<SenderThread>();
        int x = 0;
        while (x < this.getNeighbours().size()) {
            NeighbourAnt n = (NeighbourAnt)this.getNeighbours().get(x);
            if (n != null) {
                try {
                    SenderThread broadSender = n.route(wm.getMessage());
                    threadsList.add(broadSender);
                    _logger.debug(this.getId() + ": Flooding message with id = " + wm.getMessage().ack_id + " type = " + wm.getMessage().getType() + " to id = " + n.getId());
                }
                catch (Exception e) {
                    _logger.error("Cannot flood to neighbour", e);
                }
            }
            ++x;
        }
        this.traceMyMessage(wm, "");
        SenderThread[] st = new SenderThread[threadsList.size()];
        int x2 = 0;
        while (x2 < threadsList.size()) {
            st[x2] = (SenderThread)threadsList.get(x2);
            ++x2;
        }
        return st;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            this.sss = new SecureServerSocket(this, this.serverPort);
            if (this.sss != null) ** GOTO lbl102
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    System.gc();
                    z = 0;
                    while (z < 3) {
                        sleepTime = (int)Math.floor((double)Ant.messageTimeout * 1.0 / 3.0);
                        Ant.sleep(sleepTime);
                        try {
                            x = 0;
                            while (x < this.neighbours.size()) {
                                toBeRemoved = (NeighbourAnt)this.neighbours.get(x);
                                if (!toBeRemoved.isAlive() || !toBeRemoved.isConnected() || toBeRemoved.getLastProbenAt() < System.currentTimeMillis() - (long)Ant.probeCheckInterval) {
                                    this.removeNeighbour(toBeRemoved);
                                    this.propertyChangeSupport.firePropertyChange("removedNeighbour", null, toBeRemoved);
                                    Ant._logger.info("Removing stuck neighbour...");
                                }
                                ++x;
                            }
                            x = this.neighbours.size() - 1;
                            while (x >= 0) {
                                y = x - 1;
                                while (y >= 0) {
                                    if (this.neighbours.get(x).equals(this.neighbours.get(y))) {
                                        this.removeNeighbour((NeighbourAnt)this.neighbours.get(x));
                                        Ant._logger.info("Removing duplicated neighbour...");
                                        break;
                                    }
                                    --y;
                                }
                                --x;
                            }
                        }
                        catch (Exception e) {
                            Ant._logger.error(this.getId() + ": Error in removing stuck neighbour", e);
                        }
                        ++z;
                    }
                    while (this.failedMessages.size() > Ant.maxFailedMessageToTrace) {
                        this.failedMessages.remove(0);
                    }
                    if (this.myMessages.size() == 0) continue;
                    Ant._logger.debug(this.getId() + ": Processing " + this.myMessages.size() + " messages for eventual retransmission...");
                    Ant._logger.debug("There are " + this.failedMessages.size() + " messages failed!");
                    toBeRemoved = new ArrayList<MessageWrapper>();
                    x = 0;
                    while (x < this.myMessages.size()) {
                        wm = (MessageWrapper)this.myMessages.get(x);
                        if (wm.getLifetime() > Ant.messageTimeout) {
                            if (wm.getRetrasmissions() < Ant.maxRetransmissions) {
                                wm.retrasmitted(this);
                                st = this.route(wm, null, null, null, false, true);
                                if (st != null) {
                                    i = 0;
                                    while (i < st.length) {
                                        st[i].join();
                                        ++i;
                                    }
                                }
                                Ant._logger.debug("Retransmited Message: " + wm.getMessage().getAck_Id() + wm.getMessage().getType());
                            } else {
                                if (wm.getMessage().getType() == 2) {
                                    Ant._logger.info(this.getId() + ": Broadcast message timed out " + wm.getMessage().getDest());
                                } else if (wm.getMessage().getType() == 0 && wm.getMessage().getSource().equals("")) {
                                    Ant._logger.info(this.getId() + ": Masked message timed out " + wm.getMessage().getDest());
                                } else {
                                    Ant._logger.info(this.getId() + ": Destination unreachable " + wm.getMessage().getDest());
                                    this.failedMessages.add(wm);
                                }
                                toBeRemoved.add(wm);
                            }
                        }
                        ++x;
                    }
                    x = toBeRemoved.size() - 1;
                    while (x >= 0) {
                        wm = (MessageWrapper)toBeRemoved.get(x);
                        if (this.myMessages.remove(wm)) {
                            Ant._logger.info("Removed Message from myMessages: " + wm.getMessage().getAck_Id() + wm.getMessage().getType());
                        }
                        --x;
                    }
                    continue;
                }
                catch (Exception cycleException) {
                    Ant._logger.error("ANt(ID_" + this.getId() + ") main cycle error!", cycleException);
                }
lbl102:
                // 4 sources

                ** while (!this.terminate)
            }
lbl103:
            // 1 sources

        }
        catch (Exception e) {
            this.terminate = true;
            Ant._logger.info(this.getId() + " - Failure in setting up Ant server port", e);
        }
    }

    public MessageWrapper sendBroadcastMessage(Message message) {
        String messageID = this.getId() + "@" + System.currentTimeMillis();
        SecureRandom sr = new SecureRandom();
        byte[] randomDest = new byte[10];
        sr.nextBytes(randomDest);
        String dest = Base16.toHexString(randomDest);
        message.fillMessageProperties(this.getId(), dest, 2, messageID);
        try {
            Thread.sleep(50L);
        }
        catch (Exception e) {
            _logger.error(this.getId() + "", e);
        }
        MessageWrapper wm = new MessageWrapper(message, this.getId());
        wm.disableAutoRetransmit();
        try {
            SenderThread[] st = this.route(wm, null, null, null, false, false);
            if (st != null) {
                int x = 0;
                while (x < st.length) {
                    try {
                        st[x].join();
                    }
                    catch (Exception e) {
                        _logger.error("Cannot join send process", e);
                    }
                    ++x;
                }
            }
            return wm;
        }
        catch (Exception e) {
            _logger.error(this.getId() + "", e);
            return null;
        }
    }

    public MessageWrapper sendMessage(Message message, String dest, boolean disableAutoRetransmit, boolean maskSource) throws InterruptedException {
        String messageID = this.getId() + "@" + System.currentTimeMillis();
        if (!maskSource) {
            message.fillMessageProperties(this.getId(), dest, 0, messageID);
        } else {
            message.fillMessageProperties("", dest, 0, messageID);
        }
        _logger.debug("There are " + this.failedMessages.size() + " messages failed!");
        _logger.debug("There are " + this.myMessages.size() + " messages pending!");
        _logger.debug(this.getId() + ": Sending Message from id = " + this.getId() + " to id = " + dest + " message id = " + messageID);
        Thread.sleep(50L);
        MessageWrapper wm = new MessageWrapper(message, this.getId());
        if (disableAutoRetransmit) {
            wm.disableAutoRetransmit();
        }
        try {
            SenderThread[] st = this.route(wm, null, null, null, false, false);
            if (st != null) {
                int x = 0;
                while (x < st.length) {
                    st[x].join();
                    ++x;
                }
            }
            return wm;
        }
        catch (Exception e) {
            _logger.error(this.getId() + "", e);
            return null;
        }
    }

    public void setMaxNeighbours(int mn) {
        maxNeighbours = mn;
    }

    public void traceDeliveredMessage(MessageWrapper wm) {
        wm.setStoreFormat();
        boolean removed = false;
        if (this.deliveredMessages.size() >= Router.ownDeliveredMessagesQueue && this.deliveredMessages.size() > 0) {
            int x = this.deliveredMessages.size() - 1;
            while (x >= 0 && !removed) {
                if (((MessageWrapper)this.deliveredMessages.get(x)).getMessage().getDest().equals(wm.getMessage().getDest()) && ((MessageWrapper)this.deliveredMessages.get(x)).getMessage().getSource().equals(wm.getMessage().getSource())) {
                    this.deliveredMessages.remove(x);
                    removed = true;
                }
                --x;
            }
            int x2 = this.deliveredMessages.size() - 1;
            while (x2 >= 0 && !removed) {
                if (((MessageWrapper)this.deliveredMessages.get(x2)).getMessage().getDest().equals(wm.getMessage().getDest())) {
                    this.deliveredMessages.remove(x2);
                    removed = true;
                }
                --x2;
            }
            int x3 = this.deliveredMessages.size() - 1;
            while (x3 >= 0 && !removed) {
                if (((MessageWrapper)this.deliveredMessages.get(x3)).getMessage().getSource().equals(wm.getMessage().getDest())) {
                    this.deliveredMessages.remove(x3);
                    removed = true;
                }
                --x3;
            }
            if (!removed) {
                this.deliveredMessages.remove(this.deliveredMessages.size() - 1);
            }
            this.deliveredMessages.add(0, wm);
        } else {
            this.deliveredMessages.add(0, wm);
        }
    }

    public void traceMessage(Message m, String requirer, String routedTo) {
        MessageWrapper wm = new MessageWrapper(m, requirer);
        wm.setStoreFormat();
        wm.setRoutedTo(routedTo);
        wm.alreadyVisited.add(requirer);
        int index = this.inTransitMessages.indexOf(m);
        if (index >= 0) {
            this.inTransitMessages.remove(index);
        }
        if (this.inTransitMessages.size() < inTransitMessageSizeMax && !this.inTransitMessages.contains(m)) {
            this.inTransitMessages.add(wm);
        } else if (this.inTransitMessages.size() >= inTransitMessageSizeMax && !this.inTransitMessages.contains(m)) {
            this.inTransitMessages.add(wm);
            this.inTransitMessages.remove(0);
        }
    }

    public void traceMyMessage(MessageWrapper wm, String routedTo) {
        wm.setRoutedTo(routedTo);
        int index = this.myMessages.indexOf(wm);
        if (index < 0) {
            this.myMessages.add(wm);
        } else {
            this.myMessages.remove(wm);
            this.myMessages.add(wm);
        }
    }

    public static synchronized boolean verifyAndIncBeingRoutedMessages() {
        if (beingRoutedMessages < maxMessagesToRouteToghether) {
            ++beingRoutedMessages;
            return true;
        }
        return false;
    }
}

