/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.InterruptedDownload;
import ants.p2p.Message;
import ants.p2p.MultipleSourcesDownloadManager;
import ants.p2p.WarriorAnt;
import ants.p2p.gui.DownloadAntPanel;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryFileTupleComparator;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.security.AsymmetricProvider;
import ants.p2p.security.EndpointSecurityManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoresumeEngine
extends Thread
implements PropertyChangeListener {
    static Logger _logger;
    static /* synthetic */ Class class$ants$p2p$AutoresumeEngine;
    QueryMessage currentQuery = null;
    DownloadAntPanel dap;
    InterruptedDownload interruptedDownload;
    MultipleSourcesDownloadManager msdm;
    WarriorAnt n;
    public PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    List secureConnectionRequired = Collections.synchronizedList(new ArrayList());
    static int secureConnectionToTrace;
    public static int sleepRate;
    boolean terminate = false;

    static {
        secureConnectionToTrace = 1000;
        sleepRate = 180000;
        _logger = Logger.getLogger((class$ants$p2p$AutoresumeEngine == null ? (class$ants$p2p$AutoresumeEngine = AutoresumeEngine.class$("ants.p2p.AutoresumeEngine")) : class$ants$p2p$AutoresumeEngine).getName());
    }

    public AutoresumeEngine(InterruptedDownload interruptedDownload, WarriorAnt n, DownloadAntPanel dap) {
        this.msdm = null;
        this.interruptedDownload = interruptedDownload;
        this.n = n;
        this.dap = dap;
        this.n.propertyChangeSupport.addPropertyChangeListener(this);
        this.pcs.addPropertyChangeListener(dap);
        this.setInterruptedDownload(interruptedDownload);
    }

    public AutoresumeEngine(MultipleSourcesDownloadManager msdm, DownloadAntPanel dap) {
        this.msdm = msdm;
        this.n = msdm.n;
        this.dap = dap;
        this.interruptedDownload = null;
        this.n.propertyChangeSupport.addPropertyChangeListener(this);
        this.pcs.addPropertyChangeListener(dap);
        this.setMultipleSourcesDownloadManager(msdm);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void deactivate() {
        this.n.propertyChangeSupport.removePropertyChangeListener(this);
        this.terminate = true;
        if (this.msdm != null) {
            _logger.info("Autoresume Engine deactivated for file: " + this.msdm.getFileHash());
        } else if (this.interruptedDownload != null) {
            _logger.info("Autoresume Engine deactivated for file: " + this.interruptedDownload.getFileHash());
        }
    }

    public ArrayList mergeQueryResults(ArrayList resultSet) {
        ArrayList<FileTupleGroup> tupleGroups = new ArrayList<FileTupleGroup>();
        int x = 0;
        while (x < resultSet.size()) {
            FileTupleGroup ftg;
            FileTupleGroup ftg2;
            if (resultSet.get(x) instanceof QueryCompletedFileTuple) {
                if (tupleGroups.contains((QueryCompletedFileTuple)resultSet.get(x))) {
                    ftg2 = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryCompletedFileTuple)resultSet.get(x)));
                    ftg2.tuples.add(resultSet.get(x));
                } else {
                    QueryCompletedFileTuple qft = (QueryCompletedFileTuple)resultSet.get(x);
                    ftg = new FileTupleGroup(qft.getFileHash(), qft.getSize());
                    ftg.tuples.add(qft);
                    tupleGroups.add(ftg);
                }
            } else if (resultSet.get(x) instanceof QueryPartialFileTuple) {
                if (tupleGroups.contains((QueryPartialFileTuple)resultSet.get(x))) {
                    ftg2 = (FileTupleGroup)tupleGroups.get(tupleGroups.indexOf((QueryPartialFileTuple)resultSet.get(x)));
                    ftg2.tuples.add(resultSet.get(x));
                } else {
                    QueryPartialFileTuple qpft = (QueryPartialFileTuple)resultSet.get(x);
                    ftg = new FileTupleGroup(qpft.getFileHash(), qpft.getSize());
                    ftg.tuples.add(qpft);
                    tupleGroups.add(ftg);
                }
            }
            ++x;
        }
        return tupleGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChange(PropertyChangeEvent e) {
        QueryMessage eventQuerySource;
        if (e.getPropertyName().equals("queryCompleted") && this.currentQuery != null && (eventQuerySource = (QueryMessage)e.getOldValue()).getLocalQueryId() == this.currentQuery.getLocalQueryId()) {
            ArrayList resultset = this.mergeQueryResults((ArrayList)e.getNewValue());
            int x = 0;
            boolean bl = true;
            while (true) {
                if (!bl || (bl = false) || !true) {
                    FileTupleGroup ftg = (FileTupleGroup)resultset.get(x);
                    _logger.info("Autoresume query completed for file: " + ftg.getHash());
                    Object[] tuples = ftg.tuples.toArray();
                    Arrays.sort(tuples, new QueryFileTupleComparator());
                    int y = 0;
                    boolean bl2 = true;
                    while (true) {
                        if (!bl2 || (bl2 = false) || !true) {
                            QueryFileTuple qft = (QueryFileTuple)tuples[x];
                            EndpointSecurityManager esm = this.n.getOutputSecureConnectionManager(qft.getOwnerID());
                            if (esm != null) {
                                this.pcs.firePropertyChange("addSourcePeer", this, qft);
                            } else {
                                List list = this.secureConnectionRequired;
                                synchronized (list) {
                                    this.n.createSecureConnection(qft.getOwnerID());
                                    if (this.secureConnectionRequired.size() > secureConnectionToTrace) {
                                        this.secureConnectionRequired.remove(0);
                                    }
                                    this.secureConnectionRequired.add(qft);
                                }
                            }
                            ++y;
                        }
                        if (y >= tuples.length) break;
                        if (this.msdm == null) continue;
                        if (this.msdm.getPeersNumber() >= MultipleSourcesDownloadManager.MaxSources) break;
                    }
                    ++x;
                }
                if (x >= resultset.size()) break;
                if (this.msdm == null) continue;
                if (this.msdm.getPeersNumber() >= MultipleSourcesDownloadManager.MaxSources) break;
            }
        }
        if (e.getPropertyName().equals("secureConnectionCreated")) {
            List list = this.secureConnectionRequired;
            synchronized (list) {
                int x = 0;
                boolean bl = true;
                while (true) {
                    if (!bl || (bl = false) || !true) {
                        QueryFileTuple qft = (QueryFileTuple)this.secureConnectionRequired.get(x);
                        if (qft.getOwnerID().equals(((SecurityResponseMessage)e.getNewValue()).getSource())) {
                            _logger.info("Autoresume secure connection created file: " + qft.getFileHash());
                            this.secureConnectionRequired.remove(x);
                            this.pcs.firePropertyChange("addSourcePeer", this, qft);
                            return;
                        }
                        ++x;
                    }
                    if (x >= this.secureConnectionRequired.size()) break;
                    if (this.msdm == null) continue;
                    if (this.msdm.getPeersNumber() >= MultipleSourcesDownloadManager.MaxSources) break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.terminate) {
                AutoresumeEngine autoresumeEngine = this;
                synchronized (autoresumeEngine) {
                    Message query;
                    AsymmetricProvider ap;
                    QueryHashItem qsi;
                    if (this.interruptedDownload != null) {
                        if (DownloadAntPanel.maxConcurrentDownloads == 0 || this.dap.getActiveDownloadsNumber() < DownloadAntPanel.maxConcurrentDownloads) {
                            _logger.info("Autoresume is running for file (interrupted): " + this.interruptedDownload.getFileHash());
                            qsi = new QueryHashItem(null, this.interruptedDownload.getFileHash());
                            ap = new AsymmetricProvider(false);
                            query = this.n.doQuery(qsi, ap.getPublicHeader(), WarriorAnt.maxQueryTimeToLive).getMessage();
                            if (query != null && query instanceof QueryMessage) {
                                this.currentQuery = (QueryMessage)query;
                            }
                        }
                    } else if (this.msdm != null && this.msdm.getPeersNumber() < MultipleSourcesDownloadManager.MaxSources) {
                        _logger.info("Autoresume is running for file (downloading): " + this.msdm.getFileHash());
                        qsi = new QueryHashItem(null, this.msdm.getFileHash());
                        ap = new AsymmetricProvider(false);
                        query = this.n.doQuery(qsi, ap.getPublicHeader(), WarriorAnt.maxQueryTimeToLive).getMessage();
                        if (query != null && query instanceof QueryMessage) {
                            this.currentQuery = (QueryMessage)query;
                        }
                    }
                }
                AutoresumeEngine.sleep(sleepRate);
            }
        }
        catch (Exception e) {
            _logger.error("Autoresume Engine Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterruptedDownload(InterruptedDownload interruptedDownload) {
        AutoresumeEngine autoresumeEngine = this;
        synchronized (autoresumeEngine) {
            this.interruptedDownload = interruptedDownload;
            this.msdm = null;
        }
        this.interruptedDownload.addAutoresumeEngine(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultipleSourcesDownloadManager(MultipleSourcesDownloadManager msdm) {
        AutoresumeEngine autoresumeEngine = this;
        synchronized (autoresumeEngine) {
            this.msdm = msdm;
            this.interruptedDownload = null;
        }
        this.msdm.addAutoresumeEngine(this);
    }
}

