/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.MessageWrapper;
import ants.p2p.PartialFile;
import ants.p2p.PullWatchDog;
import ants.p2p.WarriorAnt;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.security.EndpointSecurityManager;
import ants.p2p.utils.BackgroundEngine;
import ants.p2p.utils.Base16;
import ants.p2p.utils.FileInfos;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FilePullMessageProcessor
extends Thread {
    static Logger _logger = Logger.getLogger((class$ants$p2p$FilePullMessageProcessor == null ? (class$ants$p2p$FilePullMessageProcessor = FilePullMessageProcessor.class$("ants.p2p.FilePullMessageProcessor")) : class$ants$p2p$FilePullMessageProcessor).getName());
    static /* synthetic */ Class class$ants$p2p$FilePullMessageProcessor;
    FilePullMessage fpm;
    WarriorAnt n;
    int percentage = 0;
    long startTime;
    PullWatchDog watchDog = new PullWatchDog(this);

    public FilePullMessageProcessor(WarriorAnt n, FilePullMessage fpm) {
        this.startTime = System.currentTimeMillis();
        this.n = n;
        this.fpm = fpm;
        this.setPriority(5);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public FilePullMessage getFilePullMessage() {
        return this.fpm;
    }

    public double getSpeedValue() {
        double elapsed = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double speed = (double)this.percentage / 100.0 * (double)(this.fpm.getBlocks() * this.fpm.getBlockSize().longValue()) / (elapsed * Math.pow(2.0, 10.0));
        return speed > 0.0 ? speed : 0.0;
    }

    public void run() {
        FileInputStream fis = null;
        this.watchDog.start();
        try {
            Object partialFile;
            EndpointSecurityManager esm = this.n.getInputSecureConnectionManager(this.fpm.getSource());
            if (esm == null) {
                this.n.propertyChangeSupport.firePropertyChange("noSecureConnection", null, this.fpm);
                throw new Exception("No secure connection avaiable with endpoint " + this.fpm.getSource());
            }
            this.fpm.decrypt(esm.getCipherDec());
            if (this.n.checkInServiceFilePullRequests(false, this.fpm)) {
                this.watchDog.stop();
                return;
            }
            byte[] hash = this.fpm.getHash();
            Long offset = this.fpm.getOffset();
            File f = null;
            BackgroundEngine be = BackgroundEngine.getInstance();
            boolean shared = false;
            boolean partial = false;
            String fpmHash = Base16.toHexString(hash);
            FileInfos fileInfo = (FileInfos)be.sharedFilesIndexHash.get(fpmHash);
            if (fileInfo != null) {
                shared = true;
                f = new File(fileInfo.getName());
            }
            if (!(shared && f != null && f.exists() || (partialFile = BackgroundEngine.getInstance().getPartialFile(fpmHash)) == null)) {
                shared = true;
                long partId = this.fpm.getOffset() / ((long)this.fpm.getBlockSize().intValue() * this.fpm.getBlocks());
                f = new File(WarriorAnt.chunksPath + fpmHash + "." + partId);
                partial = true;
            }
            if (!shared || f == null || !f.exists()) {
                FileTransferErrorControlMessage fterrcm = new FileTransferErrorControlMessage(new Integer(0), hash, "File don't exist", this.fpm);
                fterrcm.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.n.sendMessage(fterrcm, this.fpm.getSource(), false, false);
                _logger.debug(this.n.getId() + ": File " + this.fpm.getFileName() + " don't exist. Cannot serve pull request from id " + this.fpm.getSource());
                while (this.n.myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (this.n.failedMessages.contains(wm)) {
                    this.n.failedMessages.remove(wm);
                    fterrcm.decrypt(esm.getCipherDec());
                    _logger.debug(this.n.getId() + ": Error in sending ControlMessage " + fterrcm.getMessage());
                }
                this.watchDog.stop();
                return;
            }
            this.n.propertyChangeSupport.firePropertyChange("filePullInit", null, this);
            fis = new FileInputStream(f);
            FilePushMessage frm = new FilePushMessage(this.fpm.getLocalFileName(), hash, offset, this.fpm.getBlockSize(), this.fpm.getResume(), new Long(f.length()));
            frm.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.n.sendMessage(frm, this.fpm.getSource(), false, false);
            while (this.n.myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.n.failedMessages.contains(wm)) {
                this.n.failedMessages.remove(wm);
                frm.decrypt(esm.getCipherDec());
                _logger.debug(this.n.getId() + ": Error in sending FilePushMessage " + frm.getFileName() + " - Cannot serve pull request from id " + this.fpm.getSource());
                this.watchDog.stop();
                return;
            }
            this.watchDog.setReceivedPart();
            frm.decrypt(esm.getCipherDec());
            if (this.n.checkInServiceFilePullRequests(true, this.fpm)) {
                this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                this.watchDog.stop();
                return;
            }
            byte[] block = new byte[this.fpm.getBlockSize().intValue()];
            long blocks = this.fpm.getBlocks();
            if (!partial) {
                fis.skip(offset);
            }
            long partId = 0L;
            ArrayList messageGroup = new ArrayList();
            while (fis.available() > 0 && partId < blocks) {
                int g = 0;
                while (g < PartialFile.computeGroupFactor(this.fpm.getBlockSize()) - messageGroup.size() && partId < blocks) {
                    int read = fis.read(block);
                    if (read > 0) {
                        if (read < block.length) {
                            byte[] reduced = new byte[read];
                            int x = 0;
                            while (x < read) {
                                reduced[x] = block[x];
                                ++x;
                            }
                            block = reduced;
                        }
                        FilePartMessage filepartmess = new FilePartMessage(block, hash, new Long(partId), frm);
                        filepartmess.encrypt(esm.getCipherEnc());
                        MessageWrapper wm1 = this.n.sendMessage(filepartmess, this.fpm.getSource(), false, false);
                        this.n.propertyChangeSupport.firePropertyChange("updatePacketCompressionStats", new Long(block.length), null);
                        this.percentage = (int)((double)(++partId) * 1.0 / (double)blocks * 100.0);
                        this.n.propertyChangeSupport.firePropertyChange("filePullUpdate", null, this);
                        messageGroup.add(wm1);
                    }
                    ++g;
                }
                while (messageGroup.size() == PartialFile.computeGroupFactor(this.fpm.getBlockSize()) && !this.n.areInFailedMessages(messageGroup)) {
                    messageGroup = this.n.removeDeliveredMessagesFromList(messageGroup);
                    Thread.sleep(1000L);
                }
                if (this.n.areInFailedMessages(messageGroup)) {
                    this.n.failedMessages.removeAll(messageGroup);
                    this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                    _logger.info(this.n.getId() + ": Error in file transfer " + this.fpm.getFileName() + ". Cannot serve pull request from id " + this.fpm.getSource());
                    fis.close();
                    this.n.inServiceFilePullRequests.remove(this.fpm);
                    this.watchDog.stop();
                    return;
                }
                this.watchDog.setReceivedPart();
            }
            while (messageGroup.size() > 0 && !this.n.areInFailedMessages(messageGroup)) {
                messageGroup = this.n.removeDeliveredMessagesFromList(messageGroup);
                Thread.sleep(1000L);
            }
            if (this.n.areInFailedMessages(messageGroup)) {
                this.n.failedMessages.removeAll(messageGroup);
                this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                _logger.info(this.n.getId() + ": Error in file transfer " + this.fpm.getFileName() + ". Cannot serve pull request from id " + this.fpm.getSource());
                fis.close();
                this.n.inServiceFilePullRequests.remove(this.fpm);
                this.watchDog.stop();
                return;
            }
            this.watchDog.setReceivedPart();
            fis.close();
            FileTransferEndControlMessage cm = new FileTransferEndControlMessage(new Integer(0), hash, "", frm);
            cm.encrypt(esm.getCipherEnc());
            MessageWrapper wm2 = this.n.sendMessage(cm, this.fpm.getSource(), false, false);
            while (this.n.myMessages.contains(wm2)) {
                Thread.sleep(1000L);
            }
            if (this.n.failedMessages.contains(wm2)) {
                this.n.failedMessages.remove(wm2);
                this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                _logger.info(this.n.getId() + ": Error in file transfer " + this.fpm.getFileName() + ". Cannot serve pull request from id " + this.fpm.getSource());
                this.watchDog.stop();
                return;
            }
            this.watchDog.setReceivedPart();
            this.n.inServiceFilePullRequests.remove(this.fpm);
            this.n.propertyChangeSupport.firePropertyChange("filePullEnd", null, this.getFilePullMessage());
            _logger.info(this.n.getId() + ": File sent " + this.fpm.getFileName() + " - " + this.fpm.getLocalFileName() + ". Pull request from id " + this.fpm.getSource() + " served.");
            this.watchDog.stop();
        }
        catch (Exception e) {
            try {
                fis.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
            this.n.inServiceFilePullRequests.remove(this.fpm);
            this.watchDog.stop();
            _logger.error(this.n.getId() + ": Error In Processing FilePullMessage: id = " + this.fpm.getAck_Id() + " Source: " + this.fpm.getSource() + " Dest: " + this.fpm.getDest(), e);
        }
    }

    public String speedToString() {
        double speed = this.getSpeedValue();
        return ("" + speed).substring(0, ("" + speed).indexOf(".") + 2) + "Kb/s ";
    }

    public void terminate() {
        this.stop();
        this.watchDog.stop();
        try {
            EndpointSecurityManager esm = this.n.getInputSecureConnectionManager(this.fpm.getSource());
            if (esm == null) {
                this.n.propertyChangeSupport.firePropertyChange("noSecureConnection", null, this.fpm);
                _logger.error("No secure connection avaiable with endpoint " + this.fpm.getSource());
            }
            FileTransferErrorControlMessage cm = new FileTransferErrorControlMessage(new Integer(1), this.fpm.getHash(), "", this.fpm);
            cm.encrypt(esm.getCipherEnc());
            MessageWrapper wm2 = this.n.sendMessage(cm, this.fpm.getSource(), false, false);
            while (this.n.myMessages.contains(wm2)) {
                Thread.sleep(1000L);
            }
            if (this.n.failedMessages.contains(wm2)) {
                this.n.failedMessages.remove(wm2);
                _logger.info(this.n.getId() + ": Error file transfer interruption " + this.fpm.getFileName() + ". Cannot notificate interruption of msg id " + this.fpm.getSource());
                return;
            }
            _logger.warn(this.n.getId() + ": File pull interrupted: id = " + this.fpm.getAck_Id() + " Source: " + this.fpm.getSource() + " Dest: " + this.fpm.getDest());
        }
        catch (Exception ex) {
            _logger.error("Exception while trying to notify file transfer interruption", ex);
        }
    }

    public String toString() {
        return this.percentage + "%   Speed: " + this.speedToString() + "   Hash: " + Base16.toHexString(this.fpm.getHash()) + "   Requirer: " + this.fpm.getSource() + "    Name: " + this.fpm.getFileName();
    }
}

