/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.AutoresumeEngine;
import ants.p2p.MultipleSourcesDownloadManager;
import ants.p2p.WarriorAnt;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.utils.BackgroundEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.apache.log4j.Logger;

public class InterruptedDownload {
    static Logger _logger = Logger.getLogger((class$ants$p2p$InterruptedDownload == null ? (class$ants$p2p$InterruptedDownload = InterruptedDownload.class$("ants.p2p.InterruptedDownload")) : class$ants$p2p$InterruptedDownload).getName());
    AutoresumeEngine ae;
    long assignedCoprime;
    int blockSize;
    long byteDownloaded;
    static /* synthetic */ Class class$ants$p2p$InterruptedDownload;
    boolean[] downloadedBlockGroups;
    String extendedInfos;
    String fileHash;
    String fileName;
    long fileSize;

    public InterruptedDownload(File store) {
        try {
            this.fileName = store.getName();
            if (store.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(store));
                this.downloadedBlockGroups = (boolean[])ois.readObject();
                this.fileName = (String)ois.readObject();
                this.fileHash = (String)ois.readObject();
                this.byteDownloaded = (Long)ois.readObject();
                this.fileSize = (Long)ois.readObject();
                this.blockSize = (Integer)ois.readObject();
                this.assignedCoprime = (Long)ois.readObject();
                this.extendedInfos = (String)ois.readObject();
                ois.close();
            }
            BackgroundEngine.getInstance().addPartialFile(this);
        }
        catch (Exception e) {
            _logger.error("", e);
        }
    }

    public InterruptedDownload(MultipleSourcesDownloadManager store) {
        this.fileName = store.getFileName();
        this.fileHash = store.getFileHash();
        this.byteDownloaded = store.getByteDownloaded();
        this.fileSize = store.getFileSize();
        this.blockSize = store.getBlockSize();
        this.assignedCoprime = store.assignedCoprime;
        this.extendedInfos = store.getExtendedInfos();
        this.downloadedBlockGroups = store.getDownloadedBlockGroups();
        BackgroundEngine.getInstance().addPartialFile(this);
    }

    public void addAutoresumeEngine(AutoresumeEngine ae) {
        if (this.ae != null && this.ae.isAlive()) {
            this.ae.stop();
        }
        this.ae = ae;
        if (this.ae != null && !this.ae.isAlive()) {
            this.ae.start();
            while (!this.ae.isAlive()) {
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void deactivateAutoresumeEngine() {
        if (this.ae != null && this.ae.isAlive()) {
            this.ae.deactivate();
            this.ae = null;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getByteDownloaded() {
        return this.byteDownloaded;
    }

    public boolean[] getDownloadedBlockGroups() {
        return this.downloadedBlockGroups;
    }

    public String getExtendedInfos() {
        return this.extendedInfos;
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getPercentage() {
        int den = this.downloadedBlockGroups.length;
        int num = 0;
        int x = 0;
        while (x < this.downloadedBlockGroups.length) {
            if (this.downloadedBlockGroups[x]) {
                ++num;
            }
            ++x;
        }
        double perc = (double)num * 1.0 / (double)den * 100.0;
        return (int)perc + "%  ";
    }

    public boolean isAutoresumeActive() {
        return this.ae != null && this.ae.isAlive();
    }

    public void removeInterrupted() {
        File f;
        int x = 0;
        while (x < this.getDownloadedBlockGroups().length) {
            if (this.getDownloadedBlockGroups()[x]) {
                try {
                    f = new File(WarriorAnt.chunksPath + this.getFileHash() + "." + x);
                    f.delete();
                }
                catch (Exception ex) {
                }
            }
            ++x;
        }
        try {
            f = new File(WarriorAnt.chunksPath + this.getFileHash() + ".mul");
            f.delete();
        }
        catch (Exception ex) {
            // empty catch block
        }
        BackgroundEngine.getInstance().removePartialFile(this.getFileHash());
    }

    public String sizeToString(double dSize) {
        int index;
        double currentSize = dSize;
        int x = 0;
        while (dSize > 1.0 && x < 4) {
            dSize /= Math.pow(2.0, 20.0);
            ++x;
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mb";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gb";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }

    public String toString() {
        String result = this.getPercentage();
        while (result.length() < 8) {
            result = result + ".";
        }
        result = result + " " + this.sizeToString(this.getFileSize()) + " ";
        while (result.length() < 25) {
            result = result + ".";
        }
        result = result + " " + this.getFileHash() + " ";
        result = result + "     ";
        int mark = result.length();
        if (this.getFileName().length() < FileTupleGroup.maxNameLengthToDisplay) {
            result = result + this.getFileName();
            while (result.length() < mark + FileTupleGroup.maxNameLengthToDisplay) {
                result = result + " ";
            }
        } else {
            result = result + " " + this.getFileName().substring(0, FileTupleGroup.maxNameLengthToDisplay - 1);
        }
        result = result + " " + this.getExtendedInfos();
        return result;
    }
}

