/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.MessageWrapper;
import ants.p2p.Router;
import java.io.Serializable;
import javax.crypto.Cipher;

public class Message
implements Serializable {
    String ack_id;
    private final String antMessageVersion = Ant.getVersion();
    private boolean delivered = false;
    private String dest;
    private boolean resolveLoop = false;
    private int retransmissions;
    private String source;
    protected long ttl = Router.timeToLive;
    private int type;

    public Message() {
        this.type = -1;
        this.ack_id = null;
        this.source = null;
        this.dest = null;
        int x = 0;
        int index = Router.timeToLiveDecreaseFactorIndex;
        while (x < Router.timeToLiveDecreaseRounds || this.ttl == Router.timeToLive) {
            int decFactor = (int)(System.currentTimeMillis() % (long)Router.primes[index]);
            if (++x < Router.timeToLiveDecreaseRounds) {
                ++index;
            }
            this.ttl -= (long)decFactor;
        }
        if (this.ttl < 0L) {
            this.ttl = 0L;
        }
        this.retransmissions = 0;
    }

    public Message(MessageWrapper wm) {
        this(wm.getMessage());
    }

    public Message(Message m) {
        this.source = m.source;
        this.dest = m.dest;
        this.ack_id = m.ack_id;
        this.type = m.type;
        this.ttl = m.ttl;
        this.delivered = m.delivered;
        this.resolveLoop = m.resolveLoop;
        this.retransmissions = m.retransmissions;
    }

    public synchronized void decTTL() {
        int x = 0;
        int index = Router.timeToLiveDecreaseFactorIndex;
        while (x < Router.timeToLiveDecreaseRounds) {
            ++x;
            int decFactor = (int)(System.currentTimeMillis() % (long)Router.primes[index++]);
            this.ttl -= (long)decFactor;
        }
        if (this.ttl < 0L) {
            this.ttl = 0L;
        }
    }

    public void decrypt(Cipher dec) throws Exception {
    }

    public void disableAutoRetransmit() {
        this.retransmissions = Ant.maxRetransmissions;
    }

    public void encrypt(Cipher enc) throws Exception {
    }

    public boolean equals(Object o) {
        if (o instanceof MessageWrapper) {
            return ((MessageWrapper)o).getMessage().getAck_Id().equals(this.getAck_Id()) && ((MessageWrapper)o).getMessage().getType() == this.getType();
        }
        try {
            return ((Message)o).ack_id.equals(this.ack_id) && ((Message)o).type == this.type;
        }
        catch (ClassCastException e) {
            return o == this;
        }
    }

    public void fillMessageProperties(String source, String dest, int type, String id_ack) {
        this.type = type;
        this.ack_id = id_ack;
        this.source = source;
        this.dest = dest;
    }

    public String getAck_Id() {
        return this.ack_id;
    }

    public boolean getDelivered() {
        return this.delivered;
    }

    public String getDest() {
        return this.dest;
    }

    public boolean getResolveLoop() {
        return this.resolveLoop;
    }

    public int getRetrasmissions() {
        return this.retransmissions;
    }

    public String getSource() {
        return this.source;
    }

    public long getTTL() {
        return this.ttl;
    }

    public int getType() {
        return this.type;
    }

    public String getVersion() {
        return this.antMessageVersion;
    }

    public void invalidate() {
        this.delivered = true;
    }

    public void resetDelivered() {
        this.delivered = false;
    }

    public void resetResolveLoop() {
        this.resolveLoop = false;
    }

    public void resetTTL() {
        this.ttl = Router.timeToLive;
        int x = 0;
        int index = Router.timeToLiveDecreaseFactorIndex;
        while (x < Router.timeToLiveDecreaseRounds) {
            ++x;
            int decFactor = (int)(System.currentTimeMillis() % (long)Router.primes[index++]);
            this.ttl -= (long)decFactor;
        }
        if (this.ttl < 0L) {
            this.ttl = 0L;
        }
        if (this.ttl < 0L) {
            this.ttl = 0L;
        }
    }

    public void retrasmitted() {
        ++this.retransmissions;
    }

    public void setDelivered() {
        this.delivered = true;
    }

    public void setResolveLoop() {
        this.resolveLoop = true;
    }

    public void setTTLtoZero() {
        this.ttl = 0L;
    }
}

