/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.AutoresumeEngine;
import ants.p2p.DownloadWatchDog;
import ants.p2p.WarriorAnt;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.utils.BackgroundEngine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class MultipleSourcesDownloadManager
extends Thread {
    public static int MaxSources;
    static Logger _logger;
    AutoresumeEngine ae;
    long assignedCoprime;
    int blockSize;
    public static int blocksPerSource;
    long bytesDownloaded;
    int chunckBlocksCounter = 0;
    static /* synthetic */ Class class$ants$p2p$MultipleSourcesDownloadManager;
    boolean[] downloadedBlockGroups;
    String extendedInfos;
    String fileHash;
    String fileName;
    long fileSize;
    boolean[] inServiceBlockGroups;
    List inServicepeerList;
    long initialBytesDownloaded;
    MultipleSourcesDownloadManager instance = null;
    boolean interrupt = false;
    long lastPartCompletedTime;
    WarriorAnt n;
    int partId;
    List peerList = Collections.synchronizedList(new ArrayList());
    public PropertyChangeSupport propertyChangeSupport;
    int[] pullErrorsPerBlock;
    long startTime;
    DownloadWatchDog watchDog;

    static {
        _logger = Logger.getLogger((class$ants$p2p$MultipleSourcesDownloadManager == null ? (class$ants$p2p$MultipleSourcesDownloadManager = MultipleSourcesDownloadManager.class$("ants.p2p.MultipleSourcesDownloadManager")) : class$ants$p2p$MultipleSourcesDownloadManager).getName());
        blocksPerSource = 10;
        MaxSources = 5;
    }

    public MultipleSourcesDownloadManager(WarriorAnt n, String fileName, String fileHash, long bytesDownloaded, int blockSize, long fileSize, String extendedInfos) throws Exception {
        this.inServicepeerList = Collections.synchronizedList(new ArrayList());
        this.watchDog = new DownloadWatchDog(this);
        this.instance = this;
        this.fileName = fileName;
        this.fileHash = fileHash;
        this.extendedInfos = extendedInfos;
        this.bytesDownloaded = bytesDownloaded;
        this.initialBytesDownloaded = bytesDownloaded;
        this.fileSize = fileSize;
        this.blockSize = blockSize;
        this.n = n;
        this.setPriority(5);
        this.startTime = System.currentTimeMillis();
        this.lastPartCompletedTime = System.currentTimeMillis();
        this.downloadedBlockGroups = new boolean[(int)Math.ceil((double)fileSize / ((double)(blockSize * blocksPerSource) * 1.0))];
        this.inServiceBlockGroups = new boolean[this.downloadedBlockGroups.length];
        this.pullErrorsPerBlock = new int[this.downloadedBlockGroups.length];
        this.partId = 0;
        this.assignedCoprime = (long)Math.floor(Math.random() * (double)this.downloadedBlockGroups.length);
        while (!new BigInteger(this.assignedCoprime + "").gcd(new BigInteger(this.downloadedBlockGroups.length + "")).equals(BigInteger.ONE)) {
            ++this.assignedCoprime;
            if (this.assignedCoprime != (long)this.downloadedBlockGroups.length) continue;
            this.assignedCoprime = (long)Math.floor(Math.random() * (double)this.downloadedBlockGroups.length);
        }
        Arrays.fill(this.downloadedBlockGroups, false);
        Arrays.fill(this.inServiceBlockGroups, false);
        Arrays.fill(this.pullErrorsPerBlock, 0);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("peerAvaiable")) {
                    MultipleSourcesDownloadManager.this.resume();
                } else if (e.getPropertyName().equals("multipleDownloadCompleted")) {
                    BackgroundEngine.getInstance().removePartialFile(MultipleSourcesDownloadManager.this.getFileHash());
                    MultipleSourcesDownloadManager.this.deactivateAutoresumeEngine();
                }
            }
        });
        n.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent e) {
                Object object;
                boolean[] blArray;
                int id;
                int index;
                String suffix;
                String peerId;
                if (e.getPropertyName().equals("filePartUpdate") && ((FilePartMessage)e.getNewValue()).getFilePushMessage().getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    ++MultipleSourcesDownloadManager.this.chunckBlocksCounter;
                    MultipleSourcesDownloadManager.this.lastPartCompletedTime = System.currentTimeMillis();
                }
                if (e.getPropertyName().equals("filePartDownloadCompleted") && ((FilePushMessage)e.getNewValue()).getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    MultipleSourcesDownloadManager.this.chunckBlocksCounter -= blocksPerSource;
                    if (MultipleSourcesDownloadManager.this.chunckBlocksCounter < 0) {
                        MultipleSourcesDownloadManager.this.chunckBlocksCounter = 0;
                    }
                    peerId = ((FilePushMessage)e.getNewValue()).getSource();
                    suffix = ((FilePushMessage)e.getNewValue()).getFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.downloadedBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.downloadedBlockGroups
                    object = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.inServicepeerList;
                    // MONITORENTER : list
                    List list2 = MultipleSourcesDownloadManager.this.peerList;
                    // MONITORENTER : list2
                    MultipleSourcesDownloadManager.this.watchDog.setReceivedPart();
                    MultipleSourcesDownloadManager.this.downloadedBlockGroups[id] = true;
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    QueryFileTuple peer = MultipleSourcesDownloadManager.this.findInServicePeer(peerId);
                    if (peer != null) {
                        MultipleSourcesDownloadManager.this.inServicepeerList.remove(peer);
                        MultipleSourcesDownloadManager.this.peerList.add(peer);
                    }
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : list2
                    // MONITOREXIT : list
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                    MultipleSourcesDownloadManager.this.lastPartCompletedTime = System.currentTimeMillis();
                }
                if (e.getPropertyName().equals("filePartDownloadError") && ((FileTransferErrorControlMessage)e.getNewValue()).getFilePullMessage().getLocalFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    MultipleSourcesDownloadManager.this.chunckBlocksCounter -= blocksPerSource;
                    if (MultipleSourcesDownloadManager.this.chunckBlocksCounter < 0) {
                        MultipleSourcesDownloadManager.this.chunckBlocksCounter = 0;
                    }
                    peerId = ((FileTransferErrorControlMessage)e.getNewValue()).getSource();
                    suffix = ((FileTransferErrorControlMessage)e.getNewValue()).getFilePullMessage().getLocalFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.inServicepeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId);
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePartDownloadInterrupted") && ((FilePushMessage)e.getNewValue()).getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    MultipleSourcesDownloadManager.this.chunckBlocksCounter -= blocksPerSource;
                    if (MultipleSourcesDownloadManager.this.chunckBlocksCounter < 0) {
                        MultipleSourcesDownloadManager.this.chunckBlocksCounter = 0;
                    }
                    peerId = ((FilePushMessage)e.getNewValue()).getSource();
                    suffix = ((FilePushMessage)e.getNewValue()).getFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.inServicepeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId);
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePullRequestError") && ((FilePullMessage)e.getNewValue()).getLocalFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    peerId = ((FilePullMessage)e.getNewValue()).getSource();
                    suffix = ((FilePullMessage)e.getNewValue()).getLocalFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.inServicepeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    int n = id;
                    MultipleSourcesDownloadManager.this.pullErrorsPerBlock[n] = MultipleSourcesDownloadManager.this.pullErrorsPerBlock[n] + 1;
                    QueryFileTuple peer = MultipleSourcesDownloadManager.this.findInServicePeer(peerId);
                    if (peer != null) {
                        MultipleSourcesDownloadManager.this.inServicepeerList.remove(peer);
                        MultipleSourcesDownloadManager.this.peerList.add(peer);
                    }
                    if (MultipleSourcesDownloadManager.this.pullErrorsPerBlock[id] >= Ant.maxRetransmissions) {
                        MultipleSourcesDownloadManager.this.removePeer(peerId);
                    }
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePushError") && ((FilePushMessage)e.getNewValue()).getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    peerId = ((FilePushMessage)e.getNewValue()).getSource();
                    suffix = ((FilePushMessage)e.getNewValue()).getFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.inServicepeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId);
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (e.getPropertyName().equals("filePartError") && ((FilePartMessage)e.getNewValue()).getFilePushMessage().getFileName().lastIndexOf(MultipleSourcesDownloadManager.this.getFileHash()) >= 0) {
                    peerId = ((FilePartMessage)e.getNewValue()).getSource();
                    suffix = ((FilePartMessage)e.getNewValue()).getFilePushMessage().getFileName();
                    index = suffix.lastIndexOf(".");
                    suffix = suffix.substring(index + 1, suffix.length());
                    id = Integer.parseInt(suffix);
                    blArray = MultipleSourcesDownloadManager.this.inServiceBlockGroups;
                    // MONITORENTER : MultipleSourcesDownloadManager.this.inServiceBlockGroups
                    List list = MultipleSourcesDownloadManager.this.inServicepeerList;
                    object = list;
                    // MONITORENTER : list
                    MultipleSourcesDownloadManager.this.inServiceBlockGroups[id] = false;
                    MultipleSourcesDownloadManager.this.removePeer(peerId);
                    MultipleSourcesDownloadManager.this.resume();
                    // MONITOREXIT : object
                    // MONITOREXIT : blArray
                }
                if (!e.getPropertyName().equals("securityConnectionError")) return;
                _logger.error("Critical Security Error: stopping all downloads from " + (String)e.getOldValue());
            }
        });
        WarriorAnt.checkChunksPath();
        File store = new File(WarriorAnt.chunksPath + fileHash + ".mul");
        if (store.exists()) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(store));
            this.downloadedBlockGroups = (boolean[])ois.readObject();
            this.fileName = (String)ois.readObject();
            this.fileHash = (String)ois.readObject();
            this.bytesDownloaded = (Long)ois.readObject();
            this.initialBytesDownloaded = bytesDownloaded;
            this.fileSize = (Long)ois.readObject();
            this.blockSize = (Integer)ois.readObject();
            this.assignedCoprime = (Long)ois.readObject();
            String ieDummy = (String)ois.readObject();
            ois.close();
            this.checkDownloadedBlockGroups();
        } else {
            this.checkDownloadedBlockGroups();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(store));
            oos.writeObject(this.downloadedBlockGroups);
            oos.writeObject(fileName);
            oos.writeObject(fileHash);
            oos.writeObject(new Long(bytesDownloaded));
            oos.writeObject(new Long(fileSize));
            oos.writeObject(new Integer(blockSize));
            oos.writeObject(new Long(this.assignedCoprime));
            oos.writeObject(extendedInfos);
            oos.flush();
            oos.close();
        }
        BackgroundEngine.getInstance().addPartialFile(this);
    }

    public void addAutoresumeEngine(AutoresumeEngine ae) {
        if (this.ae != null && this.ae.isAlive()) {
            this.ae.deactivate();
        }
        this.ae = ae;
        if (this.ae != null && !this.ae.isAlive()) {
            this.ae.start();
            while (!this.ae.isAlive()) {
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPeer(QueryFileTuple peerId) {
        List list = this.inServicepeerList;
        synchronized (list) {
            List list2 = this.peerList;
            synchronized (list2) {
                QueryPartialFileTuple qpftPeerId;
                if (peerId instanceof QueryCompletedFileTuple) {
                    QueryCompletedFileTuple qftPeerId = (QueryCompletedFileTuple)peerId;
                    if (this.n.getOutputSecureConnectionManager(qftPeerId.getOwnerID()) != null && !this.peerList.contains(qftPeerId) && !this.inServicepeerList.contains(qftPeerId) && this.peerList.size() + this.inServicepeerList.size() < MaxSources) {
                        this.peerList.add(qftPeerId);
                        this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                        return true;
                    }
                } else if (peerId instanceof QueryPartialFileTuple && this.n.getOutputSecureConnectionManager((qpftPeerId = (QueryPartialFileTuple)peerId).getOwnerID()) != null && !this.peerList.contains(qpftPeerId) && !this.inServicepeerList.contains(qpftPeerId) && this.peerList.size() + this.inServicepeerList.size() < MaxSources && this.getBlockSize() == qpftPeerId.getBlockSize().intValue() && blocksPerSource == qpftPeerId.getBlocksPerSource()) {
                    this.peerList.add(qpftPeerId);
                    this.propertyChangeSupport.firePropertyChange("peerAvaiable", null, null);
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized boolean checkCompleted() {
        boolean completed = true;
        int x = 0;
        while (x < this.downloadedBlockGroups.length) {
            if (!this.downloadedBlockGroups[x]) {
                completed = false;
            }
            ++x;
        }
        return completed;
    }

    public void checkDownloadedBlockGroups() {
        int x = 0;
        while (x < this.downloadedBlockGroups.length) {
            File currentFile = new File(WarriorAnt.chunksPath + this.getFileHash() + "." + x);
            this.downloadedBlockGroups[x] = x != this.downloadedBlockGroups.length - 1 ? currentFile.exists() && currentFile.length() == (long)(blocksPerSource * this.blockSize) : currentFile.exists() && currentFile.length() == this.fileSize - (long)((this.downloadedBlockGroups.length - 1) * (blocksPerSource * this.blockSize));
            ++x;
        }
    }

    public boolean checkPartsToDownload(boolean[] downloadedBlockGroups, boolean[] inServiceBlockGroups, boolean[] remoteParts) throws Exception {
        if (downloadedBlockGroups.length != remoteParts.length) {
            throw new Exception("Array sizes do not match");
        }
        int x = 0;
        while (x < downloadedBlockGroups.length) {
            if (!downloadedBlockGroups[x] && !inServiceBlockGroups[x] && remoteParts[x]) {
                return true;
            }
            ++x;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void deactivateAutoresumeEngine() {
        if (this.ae != null && this.ae.isAlive()) {
            this.ae.deactivate();
            this.ae = null;
        }
    }

    public QueryFileTuple findInServicePeer(String peerId) {
        int x = 0;
        while (x < this.inServicepeerList.size()) {
            if (((QueryFileTuple)this.inServicepeerList.get(x)).getOwnerID().equals(peerId)) {
                return (QueryFileTuple)this.inServicepeerList.get(x);
            }
            ++x;
        }
        return null;
    }

    public QueryFileTuple findPeer(String peerId) {
        int x = 0;
        while (x < this.peerList.size()) {
            if (((QueryFileTuple)this.peerList.get(x)).getOwnerID().equals(peerId)) {
                return (QueryFileTuple)this.peerList.get(x);
            }
            ++x;
        }
        return null;
    }

    public AutoresumeEngine getAutoresumeEngine() {
        return this.ae;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getByteDownloaded() {
        return this.bytesDownloaded;
    }

    public boolean[] getDownloadedBlockGroups() {
        return this.downloadedBlockGroups;
    }

    public String getExtendedInfos() {
        return this.extendedInfos;
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getPeersNumber() {
        return this.peerList.size() + this.inServicepeerList.size();
    }

    public String getPercentage() {
        long den = this.downloadedBlockGroups.length * blocksPerSource;
        int num = 0;
        int x = 0;
        while (x < this.downloadedBlockGroups.length) {
            if (this.downloadedBlockGroups[x]) {
                ++num;
            }
            ++x;
        }
        num = num * blocksPerSource + this.chunckBlocksCounter;
        double perc = (double)num * 1.0 / (double)den * 100.0;
        return (int)perc + "%  ";
    }

    public double getSpeedValue() {
        if (this.checkCompleted()) {
            return 0.0;
        }
        double elapsed = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        long downloadedGroups = 0L;
        int x = 0;
        while (x < this.downloadedBlockGroups.length) {
            if (this.downloadedBlockGroups[x]) {
                ++downloadedGroups;
            }
            ++x;
        }
        downloadedGroups = downloadedGroups * (long)blocksPerSource + (long)this.chunckBlocksCounter;
        double speed = elapsed > 0.0 ? (double)(downloadedGroups * (long)this.blockSize - this.initialBytesDownloaded) / elapsed / Math.pow(2.0, 10.0) : 0.0;
        return speed > 0.0 ? speed : 0.0;
    }

    public boolean isAutoresumeActive() {
        return this.ae != null && this.ae.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removePeer(String peerID) {
        List list = this.inServicepeerList;
        synchronized (list) {
            List list2 = this.peerList;
            synchronized (list2) {
                QueryFileTuple peer = this.findPeer(peerID);
                if (peer != null) {
                    this.peerList.remove(peer);
                    this.propertyChangeSupport.firePropertyChange("removedSourcePeer", this, peerID);
                    return peer;
                }
                QueryFileTuple ispeer = this.findInServicePeer(peerID);
                if (ispeer != null) {
                    this.inServicepeerList.remove(ispeer);
                    this.propertyChangeSupport.firePropertyChange("removedSourcePeer", this, peerID);
                    return ispeer;
                }
            }
        }
        return null;
    }

    public void resetInterrupt() {
        this.interrupt = false;
        this.resume();
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setInterrupt(boolean deactivateAutoresume) {
        if (this.isAutoresumeActive() && deactivateAutoresume) {
            this.deactivateAutoresumeEngine();
        }
        this.interrupt = true;
        this.resume();
    }

    public String sizeToString(double dSize) {
        int index;
        double currentSize = dSize;
        int x = 0;
        while (dSize > 1.0 && x < 4) {
            dSize /= Math.pow(2.0, 20.0);
            ++x;
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mb";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gb";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }

    public String speedToString() {
        double speed = this.getSpeedValue();
        return ("" + speed).substring(0, ("" + speed).indexOf(".") + 2) + "Kb/s ";
    }

    public String toString() {
        String result = !this.checkCompleted() ? this.getPercentage() : "Completed ";
        result = result + this.speedToString();
        while (result.length() < 20) {
            result = result + ".";
        }
        result = result + " " + this.sizeToString(this.getFileSize()) + " ";
        while (result.length() < 40) {
            result = result + ".";
        }
        result = result + " " + this.getFileHash() + "     ";
        int mark = result.length();
        if (this.getFileName().length() < FileTupleGroup.maxNameLengthToDisplay) {
            result = result + this.getFileName();
            while (result.length() < mark + FileTupleGroup.maxNameLengthToDisplay) {
                result = result + " ";
            }
        } else {
            result = result + " " + this.getFileName().substring(0, FileTupleGroup.maxNameLengthToDisplay - 1);
        }
        result = result + " " + this.getExtendedInfos();
        return result;
    }
}

