/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.CompressedByteArray;
import ants.p2p.Message;
import ants.p2p.Prober;
import ants.p2p.SenderThread;
import ants.p2p.messages.NetProbeMessage;
import com.jcraft.jzlib.ZInputStream;
import com.jcraft.jzlib.ZOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import org.apache.log4j.Logger;

public class NeighbourAnt
extends Thread {
    static Logger _logger = Logger.getLogger((class$ants$p2p$NeighbourAnt == null ? (class$ants$p2p$NeighbourAnt = NeighbourAnt.class$("ants.p2p.NeighbourAnt")) : class$ants$p2p$NeighbourAnt).getName());
    static /* synthetic */ Class class$ants$p2p$NeighbourAnt;
    Cipher dec;
    Cipher enc;
    boolean failure = false;
    String ip;
    boolean isRequirer;
    long lastProbenAt;
    Ant local;
    final int packetSize = 32768;
    int port;
    Prober prober = null;
    int remoteServerPort;
    Socket s;
    boolean terminate = false;
    long timeElapsed;
    public static double totalCompressedSizeIn;
    public static double totalCompressedSizeOut;
    public static double totalUncompressionSizeIn;
    public static double totalUncompressionSizeOut;

    public NeighbourAnt(Ant local, String ip, int port, int remoteServerPort, Cipher enc, Cipher dec, Socket s, boolean isRequirer, long timeElapsed) throws IOException {
        this.s = s;
        this.ip = ip;
        this.port = port;
        this.remoteServerPort = remoteServerPort;
        this.enc = enc;
        this.dec = dec;
        this.local = local;
        this.isRequirer = isRequirer;
        this.timeElapsed = timeElapsed;
        this.lastProbenAt = System.currentTimeMillis();
        _logger.info(this.getId() + ": Net probe done at " + new Date(this.lastProbenAt) + "[" + this.timeElapsed + "]");
        this.setPriority(5);
        this.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof NeighbourAnt) {
            String idThis = this.isRequirer() ? this.getId() : this.getRemoteId();
            String idO = ((NeighbourAnt)o).isRequirer() ? ((NeighbourAnt)o).getId() : ((NeighbourAnt)o).getRemoteId();
            return idThis.equals(idO);
        }
        return o == this;
    }

    public String getId() {
        if (this.ip.startsWith("/")) {
            this.ip = this.ip.substring(1);
        }
        return this.ip + ":" + this.port;
    }

    public long getLastProbenAt() {
        return this.lastProbenAt;
    }

    public String getRemoteId() {
        if (this.ip.startsWith("/")) {
            this.ip = this.ip.substring(1);
        }
        return this.ip + ":" + this.remoteServerPort;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public static int getTotalCompressionGainIn() {
        return (int)Math.ceil((1.0 - totalCompressedSizeIn / totalUncompressionSizeIn) * 100.0);
    }

    public static int getTotalCompressionGainOut() {
        return (int)Math.ceil((1.0 - totalCompressedSizeOut / totalUncompressionSizeOut) * 100.0);
    }

    public boolean isConnected() {
        if (this.s != null) {
            return !this.s.isClosed();
        }
        return false;
    }

    public boolean isRequirer() {
        return this.isRequirer;
    }

    public SenderThread route(Message m) {
        SenderThread st = new SenderThread(m, this);
        st.start();
        return st;
    }

    public void run() {
        block14: {
            try {
                this.prober = new Prober(this);
                this.prober.start();
                while (!this.terminate) {
                    Message m = null;
                    _logger.debug(this.getId() + ": Waiting for message to route...");
                    ObjectInputStream ois = new ObjectInputStream(this.s.getInputStream());
                    Object obj = ois.readObject();
                    if (obj instanceof CompressedByteArray) {
                        CompressedByteArray cba = (CompressedByteArray)obj;
                        ByteArrayInputStream in = new ByteArrayInputStream(cba.getArray());
                        ZInputStream zIn = new ZInputStream(in);
                        ObjectInputStream objIn = new ObjectInputStream(zIn);
                        obj = objIn.readObject();
                        totalCompressedSizeIn += (double)zIn.getTotalIn();
                        totalUncompressionSizeIn += (double)zIn.getTotalOut();
                    } else {
                        if (obj instanceof NetProbeMessage) {
                            long startProbe = System.currentTimeMillis();
                            int read = 0;
                            while (read < this.packetSize) {
                                read += ois.read(new byte[32768]);
                            }
                            this.timeElapsed = System.currentTimeMillis() - startProbe;
                            this.lastProbenAt = System.currentTimeMillis();
                            _logger.info(this.getId() + ": Net probe done at " + new Date(this.lastProbenAt) + "[" + this.timeElapsed + "]");
                            continue;
                        }
                        _logger.debug(obj.toString());
                        continue;
                    }
                    this.local.propertyChangeSupport.firePropertyChange("updatePacketCompressionStats", null, null);
                    if (!(obj instanceof SealedObject)) continue;
                    if ((obj = ((SealedObject)obj).getObject(this.dec)) instanceof Message) {
                        m = (Message)obj;
                        _logger.debug(this.getId() + ": Message received ID " + m.getAck_Id() + " From: " + m.getSource() + " To: " + m.getDest());
                        this.local.activateNewRouterProcess(m, this.getId());
                        continue;
                    }
                    _logger.debug(obj.toString());
                }
                if (this.failure) break block14;
                this.failure = true;
                _logger.info(this.local.getId() + ": 1Closed connection with neighbour: " + this.getId());
                try {
                    if (this.s != null && !this.s.isClosed()) {
                        this.s.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.local.removeNeighbour(this);
                this.local.propertyChangeSupport.firePropertyChange("removedNeighbour", null, this);
            }
            catch (Exception e) {
                if (this.failure) break block14;
                this.failure = true;
                _logger.info(this.local.getId() + ": 2Closed connection with neighbour: " + this.getId());
                _logger.debug("NeighbourAnt connection failed", e);
                try {
                    if (this.s != null && !this.s.isClosed()) {
                        this.s.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.local.removeNeighbour(this);
                this.local.propertyChangeSupport.firePropertyChange("removedNeighbour", null, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Message m) throws Exception {
        block12: {
            try {
                SealedObject sealedMessage;
                if (m instanceof NetProbeMessage) {
                    Socket socket = this.s;
                    synchronized (socket) {
                        OutputStream sos = this.s.getOutputStream();
                        ObjectOutputStream soos = new ObjectOutputStream(sos);
                        soos.writeObject(m);
                        _logger.info(this.getId() + ": Sending probe message at " + new Date(System.currentTimeMillis()));
                        soos.write(new byte[this.packetSize]);
                        _logger.info(this.getId() + ": Sent probe message at " + new Date(System.currentTimeMillis()));
                        break block12;
                    }
                }
                Cipher cipher = this.enc;
                synchronized (cipher) {
                    _logger.debug(this.getId() + ": Routing message: ID " + m.getAck_Id() + " Type: " + m.getType() + " From: " + " To: " + m.getDest());
                    sealedMessage = new SealedObject(m, this.enc);
                }
                Socket socket = this.s;
                synchronized (socket) {
                    OutputStream sos = this.s.getOutputStream();
                    ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                    ZOutputStream zOut = new ZOutputStream(byteArrayOut, 9);
                    ObjectOutputStream zOOs = new ObjectOutputStream(zOut);
                    zOOs.writeObject(sealedMessage);
                    totalUncompressionSizeOut += (double)zOut.getTotalIn();
                    zOut.close();
                    totalCompressedSizeOut += (double)byteArrayOut.toByteArray().length;
                    CompressedByteArray cba = new CompressedByteArray(byteArrayOut.toByteArray());
                    ObjectOutputStream oos = new ObjectOutputStream(sos);
                    oos.writeObject(cba);
                    this.local.propertyChangeSupport.firePropertyChange("updatePacketCompressionStats", null, null);
                }
            }
            catch (Exception e) {
                _logger.info(this.getId() + ": Socket is closed with neighbour: " + this.getId());
            }
        }
    }

    public void terminate() {
        try {
            this.terminate = true;
            if (this.s != null && !this.s.isClosed()) {
                this.s.close();
            }
        }
        catch (Exception ex) {
            _logger.error("Neighbour terminate error", ex);
        }
    }

    public String toString() {
        return this.getId() + " [" + this.getTimeElapsed() + "ms]";
    }
}

