/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.ByteWrapper;
import ants.p2p.messages.FilePushMessage;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class PartialFile {
    static Logger _logger = Logger.getLogger((class$ants$p2p$PartialFile == null ? (class$ants$p2p$PartialFile = PartialFile.class$("ants.p2p.PartialFile")) : class$ants$p2p$PartialFile).getName());
    static /* synthetic */ Class class$ants$p2p$PartialFile;
    File downloadInfos = null;
    File f = null;
    ByteWrapper[] fileParts;
    long fileSize;
    FilePushMessage fpm;
    int groupFactor;
    byte[] hash;
    public long lastId = 0L;
    String name;
    PropertyChangeSupport pcs;
    String source;

    public PartialFile(String name, String source, byte[] hash, boolean resume, long offset, FilePushMessage fpm, PropertyChangeSupport pcs) throws Exception {
        this.downloadInfos = new File(name + ".tmp");
        if (this.downloadInfos.exists() && !resume) {
            ObjectInputStream fis = new ObjectInputStream(new FileInputStream(this.downloadInfos));
            String oldName = (String)fis.readObject();
            fis.close();
            this.f = new File(oldName);
            if (this.f.exists()) {
                this.f.delete();
            }
            this.f = new File(name);
            if (this.f.exists()) {
                this.f.delete();
            }
            ObjectOutputStream fos = new ObjectOutputStream(new FileOutputStream(this.downloadInfos, false));
            fos.writeObject(name);
            fos.close();
        } else {
            if (!this.downloadInfos.exists() && resume) {
                throw new Exception("Resuming error");
            }
            if (this.downloadInfos.exists() && resume) {
                ObjectInputStream fis = new ObjectInputStream(new FileInputStream(this.downloadInfos));
                String oldName = (String)fis.readObject();
                fis.close();
                this.f = new File(oldName);
                if (this.f.length() != offset) {
                    throw new Exception("Resuming error");
                }
            } else {
                this.f = new File(name);
                if (this.f.exists()) {
                    this.f.delete();
                }
                ObjectOutputStream fos = new ObjectOutputStream(new FileOutputStream(this.downloadInfos, false));
                fos.writeObject(name);
                fos.close();
            }
        }
        this.pcs = pcs;
        this.fpm = fpm;
        this.name = name;
        this.source = source;
        this.hash = hash;
        this.fileSize = fpm.getFileSize();
        this.groupFactor = PartialFile.computeGroupFactor(fpm.getBlockSize());
        this.fileParts = new ByteWrapper[this.groupFactor];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendBytes(byte[] b, long id) {
        try {
            if (id < this.lastId * (long)this.groupFactor) {
                return;
            }
            if (this.fileParts[(int)(id - this.lastId * (long)this.groupFactor)] != null) {
                return;
            }
            ByteWrapper[] byteWrapperArray = this.fileParts;
            synchronized (this.fileParts) {
                _logger.debug("Writing to memory part " + id);
                this.pcs.firePropertyChange("bytesGroupAppendedToFilePart", null, this);
                this.fileParts[(int)(id - this.lastId * (long)this.groupFactor)] = new ByteWrapper(b);
                if (this.receivedBlock()) {
                    this.finalizeFile();
                    this.pcs.firePropertyChange("byteBlockFinalizedInFilePart", null, this);
                    ++this.lastId;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            _logger.error("", e);
        }
        {
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static boolean compareHash(byte[] h1, byte[] h2) {
        if (h1.length != h2.length) {
            return false;
        }
        int x = 0;
        while (x < h1.length) {
            if (h1[x] != h2[x]) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public static int computeGroupFactor(int blockSize) throws Exception {
        if (blockSize >= (int)Math.pow(2.0, 20.0)) {
            return 1;
        }
        if (blockSize <= (int)Math.pow(2.0, 15.0)) {
            return 10;
        }
        double logarithm = Math.log(blockSize) / Math.log(2.0);
        if (logarithm - Math.floor(logarithm) == 0.0) {
            blockSize /= (int)Math.pow(2.0, 15.0);
            blockSize = 10 - (int)Math.floor(Math.log(blockSize) / Math.log(2.0) * 2.0);
            return blockSize;
        }
        throw new Exception("BlockSize is not a power of 2: " + blockSize);
    }

    public boolean equals(Object o) {
        if (o instanceof PartialFile) {
            return PartialFile.compareHash(((PartialFile)o).hash, this.hash) && ((PartialFile)o).getFilePushMessage().equals(this.getFilePushMessage());
        }
        return o == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalizeFile() {
        try {
            ByteWrapper[] byteWrapperArray = this.fileParts;
            synchronized (this.fileParts) {
                _logger.debug("Finalizing");
                FileOutputStream fos = new FileOutputStream(this.f, true);
                int x = 0;
                while (x < this.fileParts.length) {
                    if (this.fileParts[x] == null) break;
                    fos.write(this.fileParts[x].content);
                    ++x;
                }
                int x2 = 0;
                while (x2 < this.fileParts.length) {
                    this.fileParts[x2] = null;
                    ++x2;
                }
                fos.close();
                this.downloadInfos.delete();
                System.gc();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            _logger.error("", e);
        }
        {
            return;
        }
    }

    public FilePushMessage getFilePushMessage() {
        return this.fpm;
    }

    public long getLastId() {
        return this.lastId;
    }

    public long getReceivedSize() {
        return this.f.length();
    }

    public boolean receivedBlock() {
        int x = 0;
        while (x < this.fileParts.length) {
            if (this.fileParts[x] == null) {
                return false;
            }
            ++x;
        }
        return true;
    }
}

