/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.FilePullMessageProcessor;
import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.PartialFile;
import ants.p2p.Router;
import ants.p2p.http.HttpProxy;
import ants.p2p.http.HttpRequestHandler;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.messages.ControlMessage;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileSizePullErrorControlMessage;
import ants.p2p.messages.FileSizePullMessage;
import ants.p2p.messages.FileSizePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.query.HttpServerInfo;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryHttpServerItem;
import ants.p2p.query.QueryInetAddressItem;
import ants.p2p.query.QueryManager;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryNode;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.query.QueryResultSenderThread;
import ants.p2p.query.ServerInfo;
import ants.p2p.query.security.AsymmetricProvider;
import ants.p2p.query.security.PublicHeader;
import ants.p2p.security.EndpointSecurityManager;
import ants.p2p.utils.AddressServer;
import ants.p2p.utils.Base16;
import ants.p2p.utils.InetAddressEngine;
import java.io.File;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class WarriorAnt
extends Ant {
    static Logger _logger;
    AddressServer addressServer = null;
    public static int blockSizeInDownload;
    public static String chunksPath;
    static /* synthetic */ Class class$ants$p2p$WarriorAnt;
    public static String downloadPath;
    static String httpHomePage;
    static int httpLocalServerPort;
    HttpProxy httpProxy = null;
    static int httpProxyPort;
    static boolean httpRunning;
    static String httpServerDescription;
    public List inServiceFilePullRequests;
    public List inServiceFilePushRequests;
    public List inputSecureConnections;
    public static boolean isServer;
    public static int maxConcurrentProxies;
    public static int maxOwnPullRequestsToTrace;
    public static int maxPartialFiles;
    public static int maxPullRequestsToServe;
    public static int maxQueryTimeToLive;
    public static int maxScheduledDownloads;
    public static int maxScheduledHttpProxy;
    public static int maxSecureConnections;
    public static int minQueryTimeToLive;
    public List outputSecureConnections;
    List partialFiles = Collections.synchronizedList(new ArrayList());
    public static String password;
    public List pendingFilePullRequests;
    public List pendingSecureRequest;
    public static int processProbability;
    public static long queryTimeToLive;
    public List scheduledDownloads;
    public List scheduledHttpProxy;

    static {
        httpProxyPort = 8080;
        httpServerDescription = "My personal Web Server";
        httpHomePage = "Default.htm";
        httpRunning = false;
        httpLocalServerPort = 80;
        maxScheduledDownloads = 1000;
        maxScheduledHttpProxy = 100;
        maxConcurrentProxies = 100;
        downloadPath = "./";
        chunksPath = "./chunks/";
        maxOwnPullRequestsToTrace = 1000;
        maxPullRequestsToServe = 100;
        maxSecureConnections = 10000;
        maxPartialFiles = 500;
        blockSizeInDownload = (int)Math.pow(2.0, 15.0);
        maxQueryTimeToLive = 7000;
        minQueryTimeToLive = 200;
        queryTimeToLive = 3500L;
        isServer = true;
        password = "";
        processProbability = 50;
        _logger = Logger.getLogger((class$ants$p2p$WarriorAnt == null ? (class$ants$p2p$WarriorAnt = WarriorAnt.class$("ants.p2p.WarriorAnt")) : class$ants$p2p$WarriorAnt).getName());
    }

    public WarriorAnt(String id, int maxNeighbours, int serverPort) {
        super(id, maxNeighbours, serverPort);
        this.outputSecureConnections = Collections.synchronizedList(new ArrayList());
        this.inputSecureConnections = Collections.synchronizedList(new ArrayList());
        this.pendingSecureRequest = Collections.synchronizedList(new ArrayList());
        this.inServiceFilePullRequests = Collections.synchronizedList(new ArrayList());
        this.inServiceFilePushRequests = Collections.synchronizedList(new ArrayList());
        this.pendingFilePullRequests = Collections.synchronizedList(new ArrayList());
        this.scheduledDownloads = Collections.synchronizedList(new ArrayList());
        this.scheduledHttpProxy = Collections.synchronizedList(new ArrayList());
        processProbability += (int)(System.currentTimeMillis() % 25L);
        WarriorAnt.checkChunksPath();
    }

    public boolean areInFailedMessages(ArrayList list) {
        int x = 0;
        while (x < list.size()) {
            if (this.failedMessages.contains(list.get(x))) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public boolean areInMyMessages(ArrayList list) {
        int x = 0;
        while (x < list.size()) {
            if (this.myMessages.contains(list.get(x))) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public static void checkChunksPath() {
        File cpf = new File(chunksPath);
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
        } else if (!cpf.exists()) {
            cpf.mkdir();
        }
    }

    public synchronized boolean checkInServiceFilePullRequests(boolean addThis, FilePullMessage fpm) {
        if (this.inServiceFilePullRequests.contains(fpm)) {
            _logger.info(this.getId() + ": Found in service file pull! Rejecting message");
            return true;
        }
        int x = 0;
        while (x < this.inServiceFilePullRequests.size()) {
            FilePullMessage currentFpM = (FilePullMessage)this.inServiceFilePullRequests.get(x);
            if (currentFpM != null && currentFpM.getBlocks().equals(fpm.getBlocks()) && currentFpM.getBlockSize().equals(fpm.getBlockSize()) && currentFpM.getFileName().equals(fpm.getFileName()) && WarriorAnt.compareHash(currentFpM.getHash(), fpm.getHash()) && currentFpM.getLocalFileName().equals(fpm.getLocalFileName()) && currentFpM.getOffset().equals(fpm.getOffset()) && currentFpM.getResume().equals(fpm.getResume()) && currentFpM.getSource().equals(fpm.getSource())) {
                _logger.info(this.getId() + ": Found in service file pull! Rejecting message");
                return true;
            }
            ++x;
        }
        _logger.info(this.getId() + ": Not Found in service file pull! Processing message");
        if (addThis) {
            if (this.inServiceFilePullRequests.size() >= maxPullRequestsToServe) {
                _logger.info(this.getId() + ": Already serving max request! Rejecting message");
                return true;
            }
            this.inServiceFilePullRequests.add(fpm);
        }
        return false;
    }

    void checkScheduledDownloads(EndpointSecurityManager esm) {
        int x = 0;
        while (x < this.scheduledDownloads.size()) {
            QueryFileTuple qft = (QueryFileTuple)this.scheduledDownloads.get(x);
            if (esm.getPeerId().equals(qft.getOwnerID())) {
                this.scheduledDownloads.remove(x);
                this.propertyChangeSupport.firePropertyChange("addSourcePeer", null, qft);
            }
            ++x;
        }
    }

    void checkScheduledHttpProxy(EndpointSecurityManager esm) {
        int x = 0;
        while (x < this.scheduledHttpProxy.size()) {
            HttpServerInfo httpServer = (HttpServerInfo)this.scheduledHttpProxy.get(x);
            if (esm.getPeerId().equals(httpServer.getOwnerId())) {
                this.scheduledHttpProxy.remove(x);
                this.createProxy(esm);
            }
            ++x;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static boolean compareHash(byte[] h1, byte[] h2) {
        if (h1.length != h2.length) {
            return false;
        }
        int x = 0;
        while (x < h1.length) {
            if (h1[x] != h2[x]) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public void createProxy(EndpointSecurityManager esm) {
        try {
            if (this.httpProxy != null && !this.httpProxy.terminate()) {
                throw new Exception("Active proxy not stopped");
            }
            this.httpProxy = new HttpProxy(httpProxyPort, esm.getPeerId(), this);
            this.propertyChangeSupport.firePropertyChange("currentProxyChanged", null, this.httpProxy);
            _logger.info("Proxy to " + esm.getPeerId() + " started on port " + this.httpProxy.getPort());
        }
        catch (Exception e) {
            _logger.error("Error in creating proxy", e);
        }
    }

    public void createSecureConnection(String peerId) {
        try {
            EndpointSecurityManager esm;
            if (this.outputSecureConnections.size() >= maxSecureConnections) {
                return;
            }
            _logger.info(this.getId() + " Creating secure connection");
            if (this.pendingSecureRequest.size() >= maxSecureConnections) {
                EndpointSecurityManager esm2 = (EndpointSecurityManager)this.pendingSecureRequest.get(this.pendingSecureRequest.size() - 1);
                if (System.currentTimeMillis() - esm2.getLastTimeUsed() > Ant.messageTimeout * (long)Ant.maxRetransmissions) {
                    this.pendingSecureRequest.remove(this.inputSecureConnections.size() - 1);
                }
            }
            int x = this.outputSecureConnections.size() - 1;
            while (x >= 0) {
                EndpointSecurityManager esm3 = (EndpointSecurityManager)this.outputSecureConnections.get(x);
                if (esm3.getPeerId().equals(peerId)) {
                    this.myMessages.remove(esm3.getSecurityMessage());
                    this.outputSecureConnections.remove(esm3);
                }
                --x;
            }
            int x2 = this.pendingSecureRequest.size() - 1;
            while (x2 >= 0) {
                esm = (EndpointSecurityManager)this.pendingSecureRequest.get(x2);
                if (esm.getPeerId().equals(peerId)) {
                    return;
                }
                --x2;
            }
            esm = new EndpointSecurityManager(this, peerId);
        }
        catch (Exception e) {
            _logger.error("", e);
        }
    }

    public void disconnectWarrior() {
        if (this.addressServer != null) {
            this.addressServer.terminate();
        }
        if (InetAddressEngine.getInstance() != null) {
            InetAddressEngine.getInstance().terminate();
        }
        this.disconnect();
    }

    public MessageWrapper doQuery(QueryNode query, PublicHeader ph, long timeToLive) throws Exception {
        QueryMessage qm = new QueryMessage(query, timeToLive, ph);
        MessageWrapper wm = this.sendBroadcastMessage(qm);
        return wm;
    }

    public QueryMessage doRandomQuery(long timeToLive) {
        try {
            QueryRandomItem qri = new QueryRandomItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(qri, timeToLive, ap.getPublicHeader());
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
                return qm;
            }
            return null;
        }
        catch (Exception ex) {
            _logger.error("", ex);
            return null;
        }
    }

    public HttpProxy getCurrentProxy() {
        return this.httpProxy;
    }

    public static int getHttpLocalServerPort() {
        return httpLocalServerPort;
    }

    public static int getHttpProxyPort() {
        return httpProxyPort;
    }

    public static String getHttpServerDescription() {
        return httpServerDescription;
    }

    public static String getHttpServerHomePage() {
        return httpHomePage;
    }

    public void getHttpServers(long timeToLive) {
        try {
            QueryHttpServerItem httpItem = new QueryHttpServerItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(httpItem, timeToLive, ap.getPublicHeader());
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
            }
        }
        catch (Exception ex) {
            _logger.error("", ex);
        }
    }

    public EndpointSecurityManager getInputSecureConnectionManager(String peerId) {
        int x = 0;
        while (x < this.inputSecureConnections.size()) {
            if (((EndpointSecurityManager)this.inputSecureConnections.get(x)).getPeerId().equals(peerId)) {
                EndpointSecurityManager esm = (EndpointSecurityManager)this.inputSecureConnections.get(x);
                return (EndpointSecurityManager)this.inputSecureConnections.get(x);
            }
            ++x;
        }
        return null;
    }

    public EndpointSecurityManager getOutputSecureConnectionManager(String peerId) {
        int x = 0;
        while (x < this.outputSecureConnections.size()) {
            if (((EndpointSecurityManager)this.outputSecureConnections.get(x)).getPeerId().equals(peerId)) {
                return (EndpointSecurityManager)this.outputSecureConnections.get(x);
            }
            ++x;
        }
        return null;
    }

    PartialFile getPartialFile(byte[] hash, FilePushMessage fpm) {
        int x = 0;
        while (x < this.partialFiles.size()) {
            if (WarriorAnt.compareHash(((PartialFile)this.partialFiles.get((int)x)).hash, hash) && ((PartialFile)this.partialFiles.get(x)).getFilePushMessage().equals(fpm)) {
                return (PartialFile)this.partialFiles.get(x);
            }
            ++x;
        }
        return null;
    }

    public EndpointSecurityManager getPendingSecureConnectionRequest(String peerId, SecurityResponseMessage srm) {
        int x = 0;
        while (x < this.pendingSecureRequest.size()) {
            if (((EndpointSecurityManager)this.pendingSecureRequest.get(x)).getPeerId().equals(peerId) && ((EndpointSecurityManager)this.pendingSecureRequest.get(x)).getSecurityMessage().equals(srm.getRequestMessage())) {
                return (EndpointSecurityManager)this.pendingSecureRequest.get(x);
            }
            ++x;
        }
        return null;
    }

    public synchronized ArrayList getServersWithFreeSlots(InetAddress host, int port, InetAddress localhost) {
        Socket local = null;
        try {
            local = new Socket(host, port);
            local.setSoTimeout(3000);
            ObjectInputStream ois = new ObjectInputStream(local.getInputStream());
            ArrayList peers = (ArrayList)ois.readObject();
            int x = peers.size() - 1;
            while (x >= 0) {
                ServerInfo peer = (ServerInfo)peers.get(x);
                if (peer.getAddress().equals(localhost) && peer.getPort().intValue() == this.getServerPort()) {
                    peers.remove(peer);
                }
                --x;
            }
            ois.close();
            return peers;
        }
        catch (Exception e) {
            block6: {
                _logger.error("Failed to get peers infos: " + e.getMessage());
                if (local == null) break block6;
                try {
                    local.close();
                }
                catch (Exception ex) {}
            }
            return null;
        }
    }

    public void getServersWithFreeSlots(long timeToLive) {
        try {
            QueryInetAddressItem qia = new QueryInetAddressItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(qia, timeToLive, ap.getPublicHeader());
            QueryMessage qmLocal = new QueryMessage(qm);
            QueryManager queryManager = new QueryManager(qmLocal, this);
            queryManager = new QueryManager(qmLocal);
            this.propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, queryManager.resultSet);
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
            }
        }
        catch (Exception ex) {
            _logger.error("", ex);
        }
    }

    public static void httpEnabled(boolean enabled) {
        httpRunning = enabled;
    }

    public static boolean isHttpEnabled() {
        return httpRunning;
    }

    private void processControlMessage(ControlMessage cm) throws Exception {
        block10: {
            try {
                if (cm instanceof FileTransferEndControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileTransferEndControlMessage ftecm = (FileTransferEndControlMessage)cm;
                    this.processFileTransferEndControlMessage(ftecm);
                    break block10;
                }
                if (cm instanceof FileTransferErrorControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileTransferErrorControlMessage fterrcm = (FileTransferErrorControlMessage)cm;
                    this.processFileTransferErrorControlMessage(fterrcm);
                    break block10;
                }
                if (cm instanceof FileSizePullErrorControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileSizePullErrorControlMessage fsperrcm = (FileSizePullErrorControlMessage)cm;
                    this.processFileSizePullErrorControlMessage(fsperrcm);
                    break block10;
                }
                if (cm instanceof HttpTransferEndControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    HttpTransferEndControlMessage httpTransferError = (HttpTransferEndControlMessage)cm;
                    this.processHttpTransferEndControlMessage(httpTransferError);
                    break block10;
                }
                throw new Exception("Unexpected Control Message");
            }
            catch (Exception e) {
                _logger.error("", e);
                throw new Exception(this.getId() + ": Error In Processing ControlMessage: id = " + cm.getAck_Id() + " Source: " + cm.getSource() + " Dest: " + cm.getDest());
            }
        }
    }

    private void processFilePartMessage(FilePartMessage fpm) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fpm.getSource());
            if (esm == null) {
                this.propertyChangeSupport.firePropertyChange("securityConnectionError", fpm.getSource(), fpm);
                throw new Exception("No secure connection avaiable with endpoint " + fpm.getSource());
            }
            fpm.decrypt(esm.getCipherDec());
            byte[] hash = fpm.getHash();
            PartialFile part = this.getPartialFile(hash, fpm.getFilePushMessage());
            if (part == null) {
                throw new Exception(this.getId() + ": Partial file is null. Error In Processing FilePartMessage: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest());
            }
            part.appendBytes(fpm.getContent(), fpm.getPartId());
            this.propertyChangeSupport.firePropertyChange("filePartUpdate", null, fpm);
            this.propertyChangeSupport.firePropertyChange("updatePacketCompressionStats", null, new Long(fpm.getContent().length));
        }
        catch (Exception e) {
            _logger.error("", e);
            if (!e.getMessage().equals("No secure connection avaiable with endpoint " + fpm.getSource())) {
                this.propertyChangeSupport.firePropertyChange("filePartError", null, fpm);
            }
            throw new Exception(this.getId() + ": Error In Processing FilePartMessage: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilePullMessage(FilePullMessage fpm) throws Exception {
        List list = this.inServiceFilePullRequests;
        synchronized (list) {
            if (this.inServiceFilePullRequests.size() >= maxPullRequestsToServe) {
                _logger.info("Already serving max number of pull requests.");
                return;
            }
        }
        _logger.info("Running FilePullMessageProcessor. Free slots: " + (maxPullRequestsToServe - this.inServiceFilePullRequests.size()));
        FilePullMessageProcessor fpmp = new FilePullMessageProcessor(this, fpm);
        fpmp.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilePushMessage(FilePushMessage fpm) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fpm.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + fpm.getSource());
            }
            fpm.decrypt(esm.getCipherDec());
            boolean proceed = false;
            List list = this.pendingFilePullRequests;
            synchronized (list) {
                int x = this.pendingFilePullRequests.size() - 1;
                while (x >= 0) {
                    FilePullMessage fpr = (FilePullMessage)this.pendingFilePullRequests.get(x);
                    if (fpr.getDest().equals(fpm.getSource()) && WarriorAnt.compareHash(fpr.getHash(), fpm.getHash())) {
                        List list2 = this.inServiceFilePushRequests;
                        synchronized (list2) {
                            _logger.info(this.getId() + ": Found pending pull request... received serving push!!!");
                            if (this.inServiceFilePushRequests.size() >= maxOwnPullRequestsToTrace) {
                                this.inServiceFilePushRequests.remove(0);
                            }
                            this.inServiceFilePushRequests.add(this.pendingFilePullRequests.get(x));
                            this.pendingFilePullRequests.remove(x);
                            proceed = true;
                        }
                    }
                    --x;
                }
            }
            if (!proceed) {
                _logger.info(this.getId() + ": Not Found pending pull request... ingnoring message.");
                return;
            }
            this.propertyChangeSupport.firePropertyChange("filePushInit", null, fpm);
            _logger.info(this.getId() + ": Creating file: name=" + fpm.getFileName() + " hash=" + Base16.toHexString(fpm.getHash()));
            byte[] hash = fpm.getHash();
            String name = new String(fpm.getFileName());
            PartialFile pf = new PartialFile(name, fpm.getSource(), hash, fpm.getResume(), fpm.getOffset(), fpm, this.propertyChangeSupport);
            if (this.partialFiles.size() > maxPartialFiles) {
                this.partialFiles.remove(0);
            }
            this.partialFiles.add(pf);
        }
        catch (Exception e) {
            _logger.error("", e);
            this.propertyChangeSupport.firePropertyChange("filePushError", null, fpm);
            throw new Exception(this.getId() + ": Error In Processing FilePushMessage: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest());
        }
    }

    private void processFileSizePullErrorControlMessage(FileSizePullErrorControlMessage fsperrcm) throws Exception {
        if (fsperrcm.getControlId() == 0) {
            _logger.info("\n" + this.getId() + ": File size pull aborted from id " + fsperrcm.getSource() + ". File hash = " + Base16.toHexString(fsperrcm.getContent()) + ".\nReason: " + fsperrcm.getMessage());
            this.propertyChangeSupport.firePropertyChange("fileSizePullError", null, fsperrcm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileSizePullMessage(FileSizePullMessage fspm) throws Exception {
        try {
            EndpointSecurityManager esm = this.getInputSecureConnectionManager(fspm.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + fspm.getSource());
            }
            fspm.decrypt(esm.getCipherDec());
            byte[] hash = fspm.getHash();
            File f = new File(fspm.getFileName());
            if (!f.exists()) {
                FileSizePullErrorControlMessage fterrcm = new FileSizePullErrorControlMessage(new Integer(0), hash, "File don't exist");
                fterrcm.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.sendMessage(fterrcm, fspm.getSource(), false, false);
                _logger.debug(this.getId() + ": File " + fspm.getFileName() + " don't exist. Cannot serve pull request from id " + fspm.getSource());
                while (this.myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (this.failedMessages.contains(wm)) {
                    this.failedMessages.remove(wm);
                    fterrcm.decrypt(esm.getCipherDec());
                    _logger.debug(this.getId() + ": Error in sending ControlMessage " + fterrcm.getMessage());
                    return;
                }
                return;
            }
            FileSizePushMessage fsrm = new FileSizePushMessage(f.getName(), hash, new Long(f.length()));
            fsrm.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.sendMessage(fsrm, fspm.getSource(), false, false);
            while (this.myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.failedMessages.contains(wm)) {
                this.failedMessages.remove(wm);
                fsrm.decrypt(esm.getCipherDec());
                _logger.debug(this.getId() + ": Error in sending FileSizePushMessage " + fsrm.getFileName() + " - Cannot serve pull request from id " + fspm.getSource());
                return;
            }
        }
        catch (Exception e) {
            _logger.error("", e);
            List list = this.inServiceFilePullRequests;
            synchronized (list) {
                if (this.inServiceFilePullRequests.contains(fspm)) {
                    this.inServiceFilePullRequests.remove(fspm);
                }
            }
            throw new Exception(this.getId() + ": Error In Processing FileSizePullMessage: id = " + fspm.getAck_Id() + " Source: " + fspm.getSource() + " Dest: " + fspm.getDest());
        }
    }

    private void processFileSizePushMessage(FileSizePushMessage fspm) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fspm.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + fspm.getSource());
            }
            fspm.decrypt(esm.getCipherDec());
            _logger.info("File: name=" + fspm.getFileName() + " hash=" + Base16.toHexString(fspm.getHash()) + " size=" + fspm.getSize());
            this.propertyChangeSupport.firePropertyChange("fileSizePushReceived", null, fspm);
        }
        catch (Exception e) {
            this.propertyChangeSupport.firePropertyChange("fileSizePushError", null, fspm);
            _logger.error("", e);
            throw new Exception(this.getId() + ": Error In Processing FileSizePushMessage: id = " + fspm.getAck_Id() + " Source: " + fspm.getSource() + " Dest: " + fspm.getDest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileTransferEndControlMessage(FileTransferEndControlMessage ftecm) throws Exception {
        if (ftecm.getControlId() == 0) {
            List list = this.inServiceFilePushRequests;
            synchronized (list) {
                int x = this.inServiceFilePushRequests.size() - 1;
                while (x >= 0) {
                    FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                    if (fpr.getDest().equals(ftecm.getSource()) && WarriorAnt.compareHash(fpr.getHash(), ftecm.getContent())) {
                        this.inServiceFilePushRequests.remove(x);
                        _logger.info("\n" + this.getId() + ": File transfer succeded from id " + ftecm.getSource() + "\nFile hash = " + Base16.toHexString(ftecm.getContent()) + "\nFile local name = " + ftecm.getFilePushMessage().getFileName());
                    }
                    --x;
                }
            }
            byte[] hash = ftecm.getContent();
            PartialFile part = this.getPartialFile(hash, ftecm.getFilePushMessage());
            if (part != null) {
                part.finalizeFile();
                this.partialFiles.remove(part);
            } else {
                _logger.warn("Partial null file hash:" + Base16.toHexString(hash) + " " + ftecm.getFilePushMessage().getAck_Id());
            }
            this.propertyChangeSupport.firePropertyChange("filePartDownloadCompleted", null, ftecm.getFilePushMessage());
        } else if (ftecm.getControlId() == 1) {
            List list = this.inServiceFilePushRequests;
            synchronized (list) {
                int x = this.inServiceFilePushRequests.size() - 1;
                while (x >= 0) {
                    FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                    if (fpr.getDest().equals(ftecm.getSource()) && WarriorAnt.compareHash(fpr.getHash(), ftecm.getContent())) {
                        this.inServiceFilePushRequests.remove(x);
                        _logger.info("\n" + this.getId() + ": File transfer aborted from id " + ftecm.getSource() + ". File hash = " + Base16.toHexString(ftecm.getContent()) + ".\nReason: " + ftecm.getMessage());
                        byte[] hash = ftecm.getContent();
                        PartialFile part = this.getPartialFile(hash, ftecm.getFilePushMessage());
                        if (part != null) {
                            this.partialFiles.remove(part);
                        }
                        this.propertyChangeSupport.firePropertyChange("filePartDownloadInterrupted", null, ftecm.getFilePushMessage());
                    }
                    --x;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileTransferErrorControlMessage(FileTransferErrorControlMessage fterrcm) throws Exception {
        if (fterrcm.getControlId() == 0) {
            List list = this.pendingFilePullRequests;
            synchronized (list) {
                int x = this.pendingFilePullRequests.size() - 1;
                while (x >= 0) {
                    FilePullMessage fpr = (FilePullMessage)this.pendingFilePullRequests.get(x);
                    if (fpr.getDest().equals(fterrcm.getSource()) && WarriorAnt.compareHash(fpr.getHash(), fterrcm.getContent())) {
                        this.pendingFilePullRequests.remove(x);
                        _logger.info("\n" + this.getId() + ": File transfer aborted from id " + fterrcm.getSource() + ". File hash = " + Base16.toHexString(fterrcm.getContent()) + ".\nReason: " + fterrcm.getMessage());
                        this.propertyChangeSupport.firePropertyChange("filePartDownloadError", null, fterrcm);
                    }
                    --x;
                }
            }
        }
        if (fterrcm.getControlId() == 1) {
            List list = this.inServiceFilePushRequests;
            synchronized (list) {
                int x = this.inServiceFilePushRequests.size() - 1;
                while (x >= 0) {
                    FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                    if (fpr.getDest().equals(fterrcm.getSource()) && WarriorAnt.compareHash(fpr.getHash(), fterrcm.getContent())) {
                        this.inServiceFilePushRequests.remove(x);
                        _logger.info("\n" + this.getId() + ": File transfer aborted from id " + fterrcm.getSource() + ". File hash = " + Base16.toHexString(fterrcm.getContent()) + ".\nReason: " + fterrcm.getMessage());
                        this.propertyChangeSupport.firePropertyChange("filePartDownloadError", null, fterrcm);
                    }
                    --x;
                }
            }
        }
    }

    private void processHttpRequestMessage(HttpRequestMessage httpRequest) throws Exception {
        try {
            EndpointSecurityManager esm = this.getInputSecureConnectionManager(httpRequest.getSource());
            if (esm == null) {
                this.propertyChangeSupport.firePropertyChange("securityConnectionError", httpRequest.getSource(), httpRequest);
                throw new Exception("No secure connection avaiable with endpoint " + httpRequest.getSource());
            }
            httpRequest.decrypt(esm.getCipherDec());
            HttpRequestHandler requestHandler = new HttpRequestHandler(httpRequest, this);
        }
        catch (Exception e) {
            _logger.error("", e);
            if (!e.getMessage().equals("No secure connection avaiable with endpoint " + httpRequest.getSource())) {
                this.propertyChangeSupport.firePropertyChange("httpRequestError", null, httpRequest);
            }
            throw new Exception(this.getId() + ": Error In Processing httpRequestMessage: id = " + httpRequest.getAck_Id() + " Source: " + httpRequest.getSource() + " Dest: " + httpRequest.getDest());
        }
    }

    private void processHttpResponsePartMessage(HttpResponsePartMessage httpResponse) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(httpResponse.getSource());
            if (esm == null) {
                this.propertyChangeSupport.firePropertyChange("securityConnectionError", httpResponse.getSource(), httpResponse);
                throw new Exception("No secure connection avaiable with endpoint " + httpResponse.getSource());
            }
            httpResponse.decrypt(esm.getCipherDec());
            this.propertyChangeSupport.firePropertyChange("httpResponsePart", null, httpResponse);
        }
        catch (Exception e) {
            _logger.error("", e);
            if (!e.getMessage().equals("No secure connection avaiable with endpoint " + httpResponse.getSource())) {
                this.propertyChangeSupport.firePropertyChange("httpResponseError", null, httpResponse);
            }
            throw new Exception(this.getId() + ": Error In Processing httpRequestMessage: id = " + httpResponse.getAck_Id() + " Source: " + httpResponse.getSource() + " Dest: " + httpResponse.getDest());
        }
    }

    private void processHttpTransferEndControlMessage(HttpTransferEndControlMessage httpResponseEnd) throws Exception {
        if (httpResponseEnd.getControlId() == 0) {
            _logger.debug("\n" + this.getId() + ": Http tranfer ended from id " + httpResponseEnd.getSource() + ".\nReason: " + httpResponseEnd.getMessage());
            this.propertyChangeSupport.firePropertyChange("httpResponseEnd", null, httpResponseEnd);
        }
    }

    void processMessage(Message m, Router r) {
        _logger.debug("Processing message: ID " + m.getAck_Id() + " Type: " + m.getType() + " From: " + m.getSource() + " To: " + m.getDest());
        try {
            if (m.getType() == 1 && m instanceof QueryMessage) {
                this.processQueryMessage((QueryMessage)m, r);
            } else if (m.getType() != 1 && m.getType() != 1) {
                if (m instanceof FilePushMessage) {
                    this.processFilePushMessage((FilePushMessage)m);
                }
                if (m instanceof FileSizePushMessage) {
                    this.processFileSizePushMessage((FileSizePushMessage)m);
                }
                if (m instanceof FilePullMessage) {
                    this.processFilePullMessage((FilePullMessage)m);
                }
                if (m instanceof FileSizePullMessage) {
                    this.processFileSizePullMessage((FileSizePullMessage)m);
                }
                if (m instanceof FilePartMessage) {
                    this.processFilePartMessage((FilePartMessage)m);
                }
                if (m instanceof ControlMessage) {
                    this.processControlMessage((ControlMessage)m);
                }
                if (m instanceof SecurityRequestMessage) {
                    this.processSecurityRequestMessage((SecurityRequestMessage)m);
                }
                if (m instanceof SecurityResponseMessage) {
                    this.processSecurityResponseMessage((SecurityResponseMessage)m);
                }
                if (m instanceof QueryMessage) {
                    this.processQueryMessage((QueryMessage)m, r);
                }
                if (m instanceof HttpRequestMessage) {
                    this.processHttpRequestMessage((HttpRequestMessage)m);
                }
                if (m instanceof HttpResponsePartMessage) {
                    this.processHttpResponsePartMessage((HttpResponsePartMessage)m);
                }
            }
            _logger.debug("Processed message: ID " + m.getAck_Id() + " Type: " + m.getType() + " From: " + m.getSource() + " To: " + m.getDest());
        }
        catch (Exception e) {
            _logger.error(this.getId() + ": Error In Processing message: id = " + m.getAck_Id() + " Source: " + m.getSource() + " Dest: " + m.getDest(), e);
        }
    }

    private void processQueryMessage(QueryMessage qm, Router r) throws Exception {
        block12: {
            try {
                if (qm.getTTL() > (long)maxQueryTimeToLive) {
                    qm.ttl = maxQueryTimeToLive;
                }
                if (qm.getType() == 2 && !qm.getProcessed()) {
                    double mustProcess = Math.random() * 100.0;
                    if (mustProcess < (double)processProbability && !qm.getSource().equals(this.getId())) {
                        if (!this.inTransitMessages.contains(qm) && !qm.getSource().equals(this.getId())) {
                            _logger.debug("Processed Query");
                            QueryResultSenderThread qrst = new QueryResultSenderThread(this, qm, r);
                            qrst.start();
                            _logger.debug(this.getId() + ": Processed query by " + qm.getSource() + ".");
                        }
                    } else {
                        _logger.info("Unprocessed Query");
                    }
                    break block12;
                }
                if (qm.getType() == 1 && qm.getProcessed()) {
                    QueryManager queryManager = new QueryManager(qm);
                    if (qm.getQuery() instanceof QueryInetAddressItem) {
                        _logger.info("Ricevuta parte di query inetAddress");
                        this.propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, queryManager.resultSet);
                    } else if (qm.getQuery() instanceof QueryHttpServerItem) {
                        _logger.info("Ricevuta parte di http server query");
                        this.propertyChangeSupport.firePropertyChange("httpServerQueryCompleted", qm, queryManager.resultSet);
                    } else {
                        this.propertyChangeSupport.firePropertyChange("queryCompleted", qm, queryManager.resultSet);
                        _logger.info("Ricevuta parte di query file");
                    }
                    break block12;
                }
                throw new Exception(this.getId() + ": Error In Processing query. Source: " + qm.getSource());
            }
            catch (Exception e) {
                _logger.error("", e);
                throw new Exception(this.getId() + ": Error In Processing query. Source: " + qm.getSource() + "\nMessage dump: type " + qm.getType() + "  processed: " + qm.getProcessed() + "  delivered: " + qm.getDelivered());
            }
        }
    }

    private void processSecurityRequestMessage(SecurityRequestMessage srm) throws Exception {
        _logger.info("Input secure connections: " + this.inputSecureConnections.size());
        int x = 0;
        while (x < this.inputSecureConnections.size()) {
            EndpointSecurityManager esmTemp = (EndpointSecurityManager)this.inputSecureConnections.get(x);
            _logger.info(esmTemp.getPeerId() + " " + new Date(esmTemp.getLastTimeUsed()).toGMTString());
            ++x;
        }
        _logger.info("End of input secure connection list (last time used order)");
        if (this.inputSecureConnections.size() >= maxSecureConnections) {
            return;
        }
        EndpointSecurityManager esm = new EndpointSecurityManager(this, srm);
    }

    private void processSecurityResponseMessage(SecurityResponseMessage srm) throws Exception {
        EndpointSecurityManager esm;
        boolean found = false;
        int x = this.outputSecureConnections.size() - 1;
        while (x >= 0) {
            esm = (EndpointSecurityManager)this.outputSecureConnections.get(x);
            if (esm.getPeerId().equals(srm.getSource()) && esm.getSecurityMessage().equals(srm.getRequestMessage())) {
                found = true;
            }
            if (found) {
                return;
            }
            --x;
        }
        esm = this.getPendingSecureConnectionRequest(srm.getSource(), srm);
        if (esm != null) {
            esm.processSecurityResponseMessage(srm);
            _logger.info(this.getId() + ": Secure connection created");
            this.propertyChangeSupport.firePropertyChange("secureConnectionCreated", null, srm);
            this.checkScheduledDownloads(esm);
            this.checkScheduledHttpProxy(esm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullFile(String fileName, String fileHash, long offset, long blocks, String peerId, int blockSize, String localFileName, boolean resume) throws Exception {
        EndpointSecurityManager esm = this.getOutputSecureConnectionManager(peerId);
        if (esm == null) {
            throw new Exception("No secure connection avaiable with endpoint " + peerId);
        }
        FilePullMessage frm = new FilePullMessage(fileName, Base16.fromHexString(fileHash), new Long(offset), new Long(blocks), new Integer(blockSize), localFileName, new Boolean(resume));
        List list = this.pendingFilePullRequests;
        synchronized (list) {
            frm.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.sendMessage(frm, peerId, true, false);
            while (this.myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.failedMessages.contains(wm)) {
                frm.decrypt(esm.getCipherDec());
                this.failedMessages.remove(wm);
                _logger.debug(this.getId() + ": Error in sending PullFileMessage " + frm.getFileName() + " - Cannot send pull request to id " + frm.getDest());
                this.propertyChangeSupport.firePropertyChange("filePullRequestError", null, frm);
                return;
            }
            FilePullMessage frmCopia = new FilePullMessage(frm, fileName, Base16.fromHexString(fileHash), new Long(offset), new Long(blocks), new Integer(blockSize), localFileName, new Boolean(resume));
            boolean removed = false;
            int x = this.pendingFilePullRequests.size() - 1;
            while (x >= 0) {
                FilePullMessage fpr = (FilePullMessage)this.pendingFilePullRequests.get(x);
                if (fpr.getDest().equals(frmCopia.getDest()) && WarriorAnt.compareHash(fpr.getHash(), frmCopia.getHash()) && fpr.getLocalFileName().equals(frmCopia.getLocalFileName()) && fpr.getBlocks().equals(frmCopia.getBlocks()) && fpr.getBlockSize().equals(frmCopia.getBlockSize()) && fpr.getOffset().equals(frmCopia.getOffset())) {
                    this.pendingFilePullRequests.remove(x);
                    removed = true;
                }
                --x;
            }
            int x2 = this.inServiceFilePushRequests.size() - 1;
            while (x2 >= 0) {
                FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x2);
                if (fpr.getDest().equals(frmCopia.getDest()) && WarriorAnt.compareHash(fpr.getHash(), frmCopia.getHash()) && fpr.getLocalFileName().equals(frmCopia.getLocalFileName()) && fpr.getBlocks().equals(frmCopia.getBlocks()) && fpr.getBlockSize().equals(frmCopia.getBlockSize()) && fpr.getOffset().equals(frmCopia.getOffset())) {
                    this.inServiceFilePushRequests.remove(x2);
                    removed = true;
                }
                --x2;
            }
            if (!removed && this.pendingFilePullRequests.size() >= maxOwnPullRequestsToTrace) {
                this.pendingFilePullRequests.remove(0);
            }
            this.pendingFilePullRequests.add(frmCopia);
        }
    }

    public void pullFileSize(String fileName, String fileHash, String peerId) throws Exception {
        EndpointSecurityManager esm = this.getOutputSecureConnectionManager(peerId);
        if (esm == null) {
            throw new Exception("No secure connection avaiable with endpoint " + peerId);
        }
        FileSizePullMessage fsrm = new FileSizePullMessage(fileName, Base16.fromHexString(fileHash));
        fsrm.encrypt(esm.getCipherEnc());
        MessageWrapper wm = this.sendMessage(fsrm, peerId, true, false);
        while (this.myMessages.contains(wm)) {
            Thread.sleep(1000L);
        }
        if (this.failedMessages.contains(wm)) {
            this.failedMessages.remove(wm);
            fsrm.decrypt(esm.getCipherDec());
            _logger.debug(this.getId() + ": Error in sending PullFileSizeMessage " + fsrm.getFileName() + " - Cannot send pull request to id " + fsrm.getDest());
            this.propertyChangeSupport.firePropertyChange("fileSizePullError", null, fsrm);
            return;
        }
    }

    public ArrayList removeDeliveredMessagesFromList(ArrayList list) {
        int x = list.size() - 1;
        while (x >= 0) {
            if (!this.myMessages.contains(list.get(x)) && !this.failedMessages.contains(list.get(x))) {
                list.remove(x);
            }
            --x;
        }
        return list;
    }

    public void removeInputSecureConnection(String peerId) {
        int x = this.inputSecureConnections.size() - 1;
        while (x >= 0) {
            if (((EndpointSecurityManager)this.inputSecureConnections.get(x)).getPeerId().equals(peerId)) {
                this.inputSecureConnections.remove(this.inputSecureConnections.get(x));
            }
            --x;
        }
    }

    public void removeOutputSecureConnection(String peerId) {
        int x = this.outputSecureConnections.size() - 1;
        while (x >= 0) {
            if (((EndpointSecurityManager)this.outputSecureConnections.get(x)).getPeerId().equals(peerId)) {
                this.outputSecureConnections.remove(this.outputSecureConnections.get(x));
            }
            --x;
        }
    }

    public void resetCurrentProxy() {
        if (this.httpProxy != null) {
            try {
                if (this.httpProxy.terminate()) {
                    this.httpProxy = null;
                    this.propertyChangeSupport.firePropertyChange("currentProxyChanged", null, this.httpProxy);
                }
            }
            catch (Exception e) {
                _logger.error("Error in stoppoing proxy: " + this.httpProxy.getPort(), e);
            }
        }
    }

    public void scheduleDownload(QueryFileTuple qft) {
        if (this.scheduledDownloads.size() > maxScheduledDownloads) {
            this.scheduledDownloads.remove(0);
        }
        this.scheduledDownloads.add(qft);
    }

    public void scheduleHttpProxy(HttpServerInfo httpServer) {
        if (this.scheduledHttpProxy.size() > maxScheduledHttpProxy) {
            this.scheduledHttpProxy.remove(0);
        }
        this.scheduledHttpProxy.add(httpServer);
    }

    public static void setHttpLocalServerPort(int port) {
        if (port >= 0 && port < 65536) {
            httpLocalServerPort = port;
        }
    }

    public static void setHttpProxyPort(int port) {
        if (port >= 0 && port < 65536) {
            httpProxyPort = port;
        }
    }

    public static void setHttpServerProperties(String homePage, String description) {
        httpHomePage = homePage;
        httpServerDescription = description;
    }

    public void startAddressServer() {
        if (isServer && this.sss != null) {
            this.addressServer = new AddressServer(this);
        }
    }
}

