/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.messages;

import ants.p2p.Message;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;

public class FilePullMessage
extends Message {
    Object blockSize;
    Object blocks;
    Object fileName;
    Object hash;
    Object localFileName;
    Object offset;
    Object resume;

    public FilePullMessage(String fileName, byte[] hash, Long offset, Long blocks, Integer blockSize, String localFileName, Boolean resume) {
        this.fileName = fileName;
        this.hash = hash;
        this.offset = offset;
        this.blocks = blocks;
        this.blockSize = blockSize;
        this.localFileName = localFileName;
        this.resume = resume;
    }

    public FilePullMessage(Message m, String fileName, byte[] hash, Long offset, Long blocks, Integer blockSize, String localFileName, Boolean resume) {
        super(m);
        this.fileName = fileName;
        this.hash = hash;
        this.offset = offset;
        this.blocks = blocks;
        this.blockSize = blockSize;
        this.localFileName = localFileName;
        this.resume = resume;
    }

    public void decrypt(Cipher c) throws Exception {
        this.fileName = (String)((SealedObject)this.fileName).getObject(c);
        this.localFileName = (String)((SealedObject)this.localFileName).getObject(c);
        this.hash = (byte[])((SealedObject)this.hash).getObject(c);
        this.offset = (Long)((SealedObject)this.offset).getObject(c);
        this.blocks = (Long)((SealedObject)this.blocks).getObject(c);
        this.blockSize = (Integer)((SealedObject)this.blockSize).getObject(c);
        this.resume = (Boolean)((SealedObject)this.resume).getObject(c);
    }

    public void encrypt(Cipher c) throws Exception {
        this.fileName = new SealedObject((Serializable)((Object)((String)this.fileName)), c);
        this.localFileName = new SealedObject((Serializable)((Object)((String)this.localFileName)), c);
        this.hash = new SealedObject((Serializable)((byte[])this.hash), c);
        this.offset = new SealedObject((Long)this.offset, c);
        this.blocks = new SealedObject((Long)this.blocks, c);
        this.blockSize = new SealedObject((Integer)this.blockSize, c);
        this.resume = new SealedObject((Boolean)this.resume, c);
    }

    public Integer getBlockSize() {
        if (this.blockSize instanceof Integer) {
            return (Integer)this.blockSize;
        }
        return null;
    }

    public Long getBlocks() {
        if (this.blocks instanceof Long) {
            return (Long)this.blocks;
        }
        return null;
    }

    public String getFileName() {
        if (this.fileName instanceof String) {
            return (String)this.fileName;
        }
        return null;
    }

    public byte[] getHash() {
        if (this.hash instanceof byte[]) {
            return (byte[])this.hash;
        }
        return null;
    }

    public String getLocalFileName() {
        if (this.localFileName instanceof String) {
            return (String)this.localFileName;
        }
        return null;
    }

    public Long getOffset() {
        if (this.offset instanceof Long) {
            return (Long)this.offset;
        }
        return null;
    }

    public Boolean getResume() {
        if (this.resume instanceof Boolean) {
            return (Boolean)this.resume;
        }
        return null;
    }
}

