/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import java.io.Serializable;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;

public class QueryRemoteFileTuple
extends QueryFileTuple {
    Object extendedInfos;
    Object fileHash;
    Object fileLength;
    Object fileName;
    Object lastTimeSeen;

    public QueryRemoteFileTuple(String sessionKey, String fileName, String fileHash, Long fileLength, String extendedInfos, Long lastTimeSeen) {
        super(sessionKey);
        this.fileHash = fileHash;
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.extendedInfos = extendedInfos;
        this.lastTimeSeen = lastTimeSeen;
    }

    public void decrypt(Cipher c) throws Exception {
        this.fileName = (String)((SealedObject)this.fileName).getObject(c);
        this.fileHash = (String)((SealedObject)this.fileHash).getObject(c);
        this.fileLength = (Long)((SealedObject)this.fileLength).getObject(c);
        this.extendedInfos = (String)((SealedObject)this.extendedInfos).getObject(c);
        this.lastTimeSeen = (Long)((SealedObject)this.lastTimeSeen).getObject(c);
    }

    public void encrypt(Cipher c) throws Exception {
        this.fileName = new SealedObject((Serializable)((Object)((String)this.fileName)), c);
        this.fileHash = new SealedObject((Serializable)((Object)((String)this.fileHash)), c);
        this.fileLength = new SealedObject((Long)this.fileLength, c);
        this.extendedInfos = new SealedObject((Serializable)((Object)((String)this.extendedInfos)), c);
        this.lastTimeSeen = new SealedObject((Long)this.lastTimeSeen, c);
    }

    public boolean equals(Object o) {
        if (o instanceof FileTupleGroup) {
            return ((FileTupleGroup)o).getHash().equals(this.getFileHash()) && ((FileTupleGroup)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryCompletedFileTuple) {
            return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryCompletedFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryCompletedFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryPartialFileTuple) {
            return ((QueryPartialFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryPartialFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryPartialFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryRemoteFileTuple) {
            return ((QueryRemoteFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryRemoteFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        return o == this;
    }

    public String getConnectionType() {
        return null;
    }

    public String getExtendedInfos() {
        if (this.extendedInfos instanceof String) {
            return (String)this.extendedInfos;
        }
        return null;
    }

    public String getFileHash() {
        if (this.fileHash instanceof String) {
            return (String)this.fileHash;
        }
        return null;
    }

    public String getFileName() {
        if (this.fileName instanceof String) {
            return (String)this.fileName;
        }
        return null;
    }

    public Integer getFreeSlots() {
        return null;
    }

    public String getOwnerID() {
        return null;
    }

    public Long getSize() {
        if (this.fileLength instanceof Long) {
            return (Long)this.fileLength;
        }
        return null;
    }

    public Long getlastTimeSeen() {
        if (this.lastTimeSeen instanceof Long) {
            return (Long)this.lastTimeSeen;
        }
        return null;
    }

    public String toString() {
        String result = "Owner ID: No Owners        File Name:";
        int mark = result.length();
        if (this.getFileName().length() < FileTupleGroup.maxNameLengthToDisplay) {
            result = result + " " + this.getFileName();
            while (result.length() < mark + FileTupleGroup.maxNameLengthToDisplay) {
                result = result + " ";
            }
        } else {
            result = result + " " + this.getFileName().substring(0, FileTupleGroup.maxNameLengthToDisplay - 1);
        }
        result = result + " [Last seen on: " + new Date(this.getlastTimeSeen()) + "]    " + this.getExtendedInfos();
        System.out.println(this.getExtendedInfos());
        return result;
    }
}

