/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query.security;

import ants.p2p.query.security.MessageHeader;
import ants.p2p.query.security.MessageHeaderRepository;
import ants.p2p.query.security.PublicHeader;
import ants.p2p.query.security.SimmetricProvider;
import ants.p2p.utils.Base16;
import java.io.IOException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AsymmetricProvider {
    MessageHeader mh = null;
    PublicHeader ph = null;

    public AsymmetricProvider(boolean generate) throws Exception {
        if (generate) {
            this.mh = new MessageHeader(220, 205);
            this.storeMessageHeader();
        } else {
            this.loadMessageHeader();
        }
    }

    public AsymmetricProvider(PublicHeader ph) {
        this.ph = ph;
        ph.generateSessionKey();
    }

    public String decryptMessage(String message, String sessionKey) throws Exception {
        if (this.mh != null) {
            return new String(SimmetricProvider.decrypt(sessionKey, Base16.fromHexString(message)));
        }
        throw new Exception("Null Message Header");
    }

    public String encryptMessage(String message) {
        if (this.ph != null) {
            return Base16.toHexString(SimmetricProvider.encrypt(this.ph.getBase16SessionKey(), message.getBytes()));
        }
        return Base16.toHexString(SimmetricProvider.encrypt(this.mh.generatePublicHeader().getBase16SessionKey(), message.getBytes()));
    }

    public Cipher getDecCipher(String encryptedSessionKey) throws Exception {
        String sessionKey = this.mh.decryptSessionKey(encryptedSessionKey);
        SecretKeySpec skeySpec = new SecretKeySpec(Base16.fromHexString(sessionKey), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        return cipher;
    }

    public PublicHeader getPublicHeader() {
        if (this.mh != null) {
            return this.mh.generatePublicHeader();
        }
        return this.ph;
    }

    public void loadMessageHeader() throws IOException, ClassNotFoundException {
        this.mh = MessageHeaderRepository.loadMessageHeader();
    }

    public void storeMessageHeader() throws Exception {
        if (this.mh == null) {
            throw new Exception("Null Message Header");
        }
        MessageHeaderRepository.storeMessageHeader(this.mh);
    }
}

