/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security;

import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.WarriorAnt;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class EndpointSecurityManager
extends Thread
implements Comparable {
    public static final int DHKeyExchangeBits = 512;
    public static final int MinDHKeyExchangeBits = 512;
    static Logger _logger = Logger.getLogger((class$ants$p2p$security$EndpointSecurityManager == null ? (class$ants$p2p$security$EndpointSecurityManager = EndpointSecurityManager.class$("ants.p2p.security.EndpointSecurityManager")) : class$ants$p2p$security$EndpointSecurityManager).getName());
    private byte[] aesKey;
    public static final String cipher = "AES";
    public static final int cipherKeySize = 16;
    static /* synthetic */ Class class$ants$p2p$security$EndpointSecurityManager;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;
    DHParameterSpec dhParamSpec;
    public static final long inactivityTimeout = 1800000L;
    boolean isRequirer;
    long lastTimeUsed = System.currentTimeMillis();
    private WarriorAnt n;
    private Cipher peerCipherDec;
    private Cipher peerCipherEnc;
    private String peerId;
    KeyAgreement peerKeyAgree;
    KeyPair peerKpair;
    PublicKey peerPubKey;
    public static final long refreshInterval = 60000L;
    private Cipher requirerCipherDec;
    private Cipher requirerCipherEnc;
    private String requirerId;
    KeyAgreement requirerKeyAgree;
    KeyPair requirerKpair;
    PublicKey requirerPubKey;
    Message securityMessage;
    private byte[] sharedSecret;
    private BigInteger skip1024Base;
    private BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};

    public EndpointSecurityManager(WarriorAnt n, SecurityRequestMessage srm) throws Exception {
        this.skip1024Base = BigInteger.valueOf(2L);
        this.isRequirer = false;
        this.requirerId = srm.getSource();
        this.peerId = n.getId();
        this.n = n;
        this.securityMessage = new Message(srm);
        this.processSecurityRequestMessage(srm);
        this.start();
    }

    public EndpointSecurityManager(WarriorAnt n, String peerId) throws Exception {
        this.skip1024Base = BigInteger.valueOf(2L);
        this.isRequirer = true;
        this.requirerId = n.getId();
        this.peerId = peerId;
        this.n = n;
        this.sendSecurityRequest();
        this.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public int compareTo(Object o) {
        if (o instanceof EndpointSecurityManager) {
            long compare = this.getLastTimeUsed() - ((EndpointSecurityManager)o).getLastTimeUsed();
            if (compare > 0L) {
                return -1;
            }
            if (compare < 0L) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private void generateDHParameters() throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.isRequirer()) {
            AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
            paramGen.init(512);
            AlgorithmParameters params = paramGen.generateParameters();
            this.dhParamSpec = (DHParameterSpec)params.getParameterSpec(class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = EndpointSecurityManager.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec);
            KeyPairGenerator requirerKpairGen = KeyPairGenerator.getInstance("DH");
            requirerKpairGen.initialize(this.dhParamSpec);
            this.requirerKpair = requirerKpairGen.generateKeyPair();
            this.requirerKeyAgree = KeyAgreement.getInstance("DH");
            this.requirerKeyAgree.init(this.requirerKpair.getPrivate());
            this.requirerPubKey = this.requirerKpair.getPublic();
        } else {
            this.dhParamSpec = new DHParameterSpec(this.skip1024Modulus, this.skip1024Base);
            KeyPairGenerator peerKpairGen = KeyPairGenerator.getInstance("DH");
            peerKpairGen.initialize(this.dhParamSpec);
            this.peerKpair = peerKpairGen.generateKeyPair();
            this.peerKeyAgree = KeyAgreement.getInstance("DH");
            this.peerKeyAgree.init(this.peerKpair.getPrivate());
            this.peerPubKey = this.peerKpair.getPublic();
        }
    }

    public Cipher getCipherDec() {
        this.setLastTimeUsed();
        if (this.isRequirer()) {
            return this.requirerCipherDec;
        }
        return this.peerCipherDec;
    }

    public Cipher getCipherEnc() {
        this.setLastTimeUsed();
        if (this.isRequirer()) {
            return this.requirerCipherEnc;
        }
        return this.peerCipherEnc;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public String getPeerId() {
        if (this.isRequirer()) {
            return this.peerId;
        }
        return this.requirerId;
    }

    public Message getSecurityMessage() {
        return this.securityMessage;
    }

    public boolean isRequirer() {
        return this.isRequirer;
    }

    public void processSecurityRequestMessage(SecurityRequestMessage srm) throws Exception {
        if (this.isRequirer) {
            throw new Exception("Violation of security protocol");
        }
        boolean found = false;
        int x = this.n.inputSecureConnections.size() - 1;
        while (x >= 0) {
            EndpointSecurityManager esm = (EndpointSecurityManager)this.n.inputSecureConnections.get(x);
            if (esm.getPeerId().equals(this.getPeerId()) && esm.getSecurityMessage().equals(srm)) {
                _logger.debug("Keep current " + esm.getPeerId() + " " + esm.getSecurityMessage().getAck_Id());
                _logger.debug(this.peerId + " " + srm.getAck_Id());
                found = true;
            } else if (esm.getPeerId().equals(this.getPeerId()) && !esm.getSecurityMessage().equals(srm)) {
                _logger.debug("Remove old " + esm.getPeerId() + " " + esm.getSecurityMessage().getAck_Id());
                _logger.debug(this.peerId + " " + srm.getAck_Id());
                this.n.inputSecureConnections.remove(x);
            }
            if (found) {
                return;
            }
            --x;
        }
        this.peerCipherEnc = Cipher.getInstance(cipher);
        this.peerCipherDec = Cipher.getInstance(cipher);
        this.skip1024Base = srm.getP();
        this.skip1024Modulus = srm.getG();
        this.generateDHParameters();
        this.requirerPubKey = srm.getRequirerPubkey();
        SecurityResponseMessage answer = new SecurityResponseMessage(this.peerPubKey, new Message(srm));
        this.n.sendMessage(answer, this.requirerId, false, false);
        KeyFactory peerKeyFac = KeyFactory.getInstance("DH");
        this.peerKeyAgree.doPhase(this.requirerPubKey, true);
        this.sharedSecret = this.peerKeyAgree.generateSecret();
        this.aesKey = new byte[16];
        int x2 = 0;
        while (x2 < this.aesKey.length) {
            this.aesKey[x2] = this.sharedSecret[x2];
            ++x2;
        }
        SecretKeySpec clientKeySpec = new SecretKeySpec(this.aesKey, cipher);
        this.peerCipherEnc.init(1, clientKeySpec);
        this.peerCipherDec.init(2, clientKeySpec);
        this.n.inputSecureConnections.add(this);
        Object[] collection = this.n.inputSecureConnections.toArray();
        Arrays.sort(collection);
        this.n.inputSecureConnections = new ArrayList<Object>(Arrays.asList(collection));
    }

    public void processSecurityResponseMessage(SecurityResponseMessage srm) throws Exception {
        if (!this.isRequirer) {
            throw new Exception("Violation of security protocol");
        }
        try {
            this.peerPubKey = srm.getPeerPubkey();
            if (this.peerPubKey.getEncoded().length * 8 < 512) {
                throw new InvalidAlgorithmParameterException("Endpoint security Error: key size < 512");
            }
            KeyFactory serverKeyFac = KeyFactory.getInstance("DH");
            this.requirerKeyAgree.doPhase(this.peerPubKey, true);
            this.sharedSecret = this.requirerKeyAgree.generateSecret();
            this.aesKey = new byte[16];
            int x = 0;
            while (x < this.aesKey.length) {
                this.aesKey[x] = this.sharedSecret[x];
                ++x;
            }
            SecretKeySpec serverKeySpec = new SecretKeySpec(this.aesKey, cipher);
            this.requirerCipherEnc.init(1, serverKeySpec);
            this.requirerCipherDec.init(2, serverKeySpec);
            this.n.pendingSecureRequest.remove(this);
            this.n.outputSecureConnections.add(this);
        }
        catch (Exception e) {
            _logger.error("", e);
        }
    }

    public void run() {
        try {
            while (System.currentTimeMillis() - this.getLastTimeUsed() < 1800000L) {
                EndpointSecurityManager.sleep(60000L);
                _logger.info("Secure connection with " + this.getPeerId() + " has " + (System.currentTimeMillis() - this.getLastTimeUsed()) / 1000L + " inactivity seconds (timout at " + 1800L + ")");
                if (!(this.isRequirer ? !this.n.outputSecureConnections.contains(this) : !this.n.inputSecureConnections.contains(this))) continue;
                return;
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (this.isRequirer()) {
            this.n.removeOutputSecureConnection(this.getPeerId());
            this.n.propertyChangeSupport.firePropertyChange("removedOutputSecureConnection", null, this.getPeerId());
        } else {
            this.n.removeInputSecureConnection(this.getPeerId());
        }
    }

    public void sendSecurityRequest() throws Exception {
        if (!this.isRequirer) {
            throw new Exception("Violation of security protocol");
        }
        try {
            this.generateDHParameters();
            this.requirerCipherEnc = Cipher.getInstance(cipher);
            this.requirerCipherDec = Cipher.getInstance(cipher);
            SecurityRequestMessage srm = new SecurityRequestMessage(this.dhParamSpec.getG(), this.dhParamSpec.getP(), this.requirerPubKey);
            MessageWrapper wm = this.n.sendMessage(srm, this.peerId, false, false);
            this.securityMessage = new Message(wm);
            this.n.pendingSecureRequest.add(this);
            Object[] collection = this.n.pendingSecureRequest.toArray();
            Arrays.sort(collection);
            this.n.pendingSecureRequest = new ArrayList<Object>(Arrays.asList(collection));
        }
        catch (Exception e) {
            _logger.error("", e);
        }
    }

    public void setLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }
}

