/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils;

import ants.p2p.InterruptedDownload;
import ants.p2p.MultipleSourcesDownloadManager;
import ants.p2p.WarriorAnt;
import ants.p2p.gui.SettingsAntPanel;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryHttpServerItem;
import ants.p2p.query.QueryInetAddressItem;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.utils.DigestManager;
import ants.p2p.utils.FileDocument;
import ants.p2p.utils.FileInfos;
import ants.p2p.utils.RemoteFileDocument;
import ants.p2p.utils.RemoteFileInfos;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class BackgroundEngine
extends Thread
implements PropertyChangeListener {
    static Logger _logger;
    public static int broadcastTimeToLive;
    static /* synthetic */ Class class$ants$p2p$utils$BackgroundEngine;
    QueryMessage currentQuery = null;
    static BackgroundEngine instance;
    private boolean loggingOut = false;
    public static int maxRemoteDocsToTrace;
    Hashtable partialFiles = new Hashtable();
    private PropertyChangeSupport propertyChangeSupport;
    public static boolean recursiveExplore;
    public static int refreshRate;
    public Hashtable remoteFilesIndexHash;
    File remoteSharedStore;
    File remoteStoreIndex;
    boolean resetCycle = false;
    public ArrayList sharedDirectories;
    public Hashtable sharedFilesIndexHash;
    public Hashtable sharedFilesIndexName = new Hashtable();
    File store;
    File storeIndex;
    private boolean synchronizingRemote = false;
    boolean terminate = false;
    public static int timesToRemoteCrawling;
    WarriorAnt wa = null;

    static {
        refreshRate = 30000;
        timesToRemoteCrawling = 30;
        maxRemoteDocsToTrace = 10000;
        broadcastTimeToLive = 2000;
        _logger = Logger.getLogger((class$ants$p2p$utils$BackgroundEngine == null ? (class$ants$p2p$utils$BackgroundEngine = BackgroundEngine.class$("ants.p2p.utils.BackgroundEngine")) : class$ants$p2p$utils$BackgroundEngine).getName());
        recursiveExplore = true;
    }

    BackgroundEngine(File f) throws IOException, ClassNotFoundException {
        this.sharedFilesIndexHash = new Hashtable();
        this.remoteFilesIndexHash = new Hashtable();
        this.sharedDirectories = new ArrayList();
        this.store = new File("sharedFiles.ant");
        this.remoteSharedStore = new File("remoteSharedFiles.ant");
        this.storeIndex = new File("sharedIndex");
        this.remoteStoreIndex = new File("remoteSharedIndex");
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.store = f;
        this.initializeIndexes();
        this.setPriority(1);
    }

    BackgroundEngine() throws IOException, ClassNotFoundException {
        this.sharedFilesIndexHash = new Hashtable();
        this.remoteFilesIndexHash = new Hashtable();
        this.sharedDirectories = new ArrayList();
        this.store = new File("sharedFiles.ant");
        this.remoteSharedStore = new File("remoteSharedFiles.ant");
        this.storeIndex = new File("sharedIndex");
        this.remoteStoreIndex = new File("remoteSharedIndex");
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initializeIndexes();
        this.setPriority(1);
    }

    public synchronized void addDirectory(File directory) {
        if (directory.isDirectory() && !this.sharedDirectories.contains(directory)) {
            this.sharedDirectories.add(directory);
            this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
        }
    }

    public void addPartialFile(InterruptedDownload id) {
        this.partialFiles.put(id.getFileHash(), id);
    }

    public void addPartialFile(MultipleSourcesDownloadManager msdm) {
        this.partialFiles.put(msdm.getFileHash(), msdm);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(pcl);
        DigestManager.addPropertyChangeListener(pcl);
    }

    public void addRemoteFile(RemoteFileInfos rfi) {
        try {
            if (this.remoteFilesIndexHash.size() > maxRemoteDocsToTrace) {
                Enumeration keys = this.remoteFilesIndexHash.keys();
                Object toBeRemoved = keys.nextElement();
                this.remoteFilesIndexHash.remove(toBeRemoved);
            }
            if (this.remoteFilesIndexHash.get(rfi.getHash()) != null) {
                RemoteFileInfos localCached = (RemoteFileInfos)this.remoteFilesIndexHash.get(rfi.getHash());
                if (localCached.getLastTimeSeen() < rfi.getLastTimeSeen()) {
                    this.remoteFilesIndexHash.put(rfi.getHash(), rfi);
                    _logger.debug("Added remote " + rfi.getName());
                }
            } else {
                this.remoteFilesIndexHash.put(rfi.getHash(), rfi);
                _logger.debug("Added remote " + rfi.getName());
            }
        }
        catch (Exception ex) {
            _logger.error("Cannot add the remote file", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void forceExternalUpdate() {
        this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
    }

    public static BackgroundEngine getInstance() {
        try {
            if (instance == null) {
                instance = new BackgroundEngine();
                instance.start();
                return instance;
            }
            return instance;
        }
        catch (Exception ex) {
            _logger.error("", ex);
            return null;
        }
    }

    public static BackgroundEngine getInstance(File store) {
        try {
            if (instance == null) {
                instance = new BackgroundEngine(store);
                instance.setPriority(1);
                instance.start();
                return instance;
            }
            return instance;
        }
        catch (Exception ex) {
            _logger.error("", ex);
            return null;
        }
    }

    public Object getPartialFile(String hash) {
        return this.partialFiles.get(hash);
    }

    public QueryPartialFileTuple getPartialFileTuple(String sessionKey, String fileHash, String ownerID, Integer freeSlots, String connectionType) {
        Object partialFile = this.partialFiles.get(fileHash);
        String fileName = null;
        Long fileLength = null;
        Integer blockSize = null;
        Integer blocksPerSource = null;
        String percentage = null;
        String extendedInfos = null;
        boolean[] downloadedBlockGroups = null;
        if (partialFile instanceof MultipleSourcesDownloadManager) {
            MultipleSourcesDownloadManager msdmPartialFile = (MultipleSourcesDownloadManager)partialFile;
            fileName = msdmPartialFile.getFileName();
            fileLength = new Long(msdmPartialFile.getFileSize());
            blockSize = new Integer(msdmPartialFile.getBlockSize());
            blocksPerSource = new Integer(MultipleSourcesDownloadManager.blocksPerSource);
            downloadedBlockGroups = msdmPartialFile.getDownloadedBlockGroups();
            percentage = msdmPartialFile.getPercentage();
            extendedInfos = msdmPartialFile.getExtendedInfos();
        } else if (partialFile instanceof InterruptedDownload) {
            InterruptedDownload idPartialFile = (InterruptedDownload)partialFile;
            fileName = idPartialFile.getFileName();
            fileLength = new Long(idPartialFile.getFileSize());
            blockSize = new Integer(idPartialFile.getBlockSize());
            blocksPerSource = new Integer(MultipleSourcesDownloadManager.blocksPerSource);
            downloadedBlockGroups = idPartialFile.getDownloadedBlockGroups();
            percentage = idPartialFile.getPercentage();
            extendedInfos = idPartialFile.getExtendedInfos();
        }
        if (fileName != null && fileLength != null && blockSize != null && downloadedBlockGroups != null && percentage != null) {
            return new QueryPartialFileTuple(sessionKey, fileName, fileHash, fileLength, blockSize, blocksPerSource, downloadedBlockGroups, ownerID, freeSlots, connectionType, percentage, extendedInfos);
        }
        throw new NullPointerException("Null pointer in QueryPartialFileTuple parameters");
    }

    public Enumeration getPartialFiles() {
        return this.partialFiles.keys();
    }

    private void initializeIndexes() {
        IndexWriter writer;
        IndexWriter writer2;
        int x;
        File[] files;
        if (this.store.exists() && IndexReader.indexExists(this.storeIndex)) {
            try {
                this.load(this.store);
                this.synchronizeLocalIndex();
            }
            catch (Exception e) {
                _logger.error("Error in synchronizing index", e);
                try {
                    files = this.storeIndex.listFiles();
                    x = 0;
                    while (x < files.length) {
                        boolean deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (!deleted) {
                            files[x].deleteOnExit();
                        }
                        ++x;
                    }
                    this.storeIndex.delete();
                    writer2 = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer2.optimize();
                    writer2.close();
                    this.synchronizeLocalIndex();
                }
                catch (Exception ex) {
                    _logger.error("Fatal error in creating index", ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (this.store.exists() && !IndexReader.indexExists(this.storeIndex)) {
            try {
                writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error("Cannot create index", e);
                System.exit(0);
            }
            try {
                this.load(this.store);
                this.synchronizeLocalIndex();
            }
            catch (Exception e) {
                _logger.error("Error in synchronizing index", e);
                try {
                    files = this.storeIndex.listFiles();
                    x = 0;
                    while (x < files.length) {
                        boolean deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (!deleted) {
                            files[x].deleteOnExit();
                        }
                        ++x;
                    }
                    this.storeIndex.delete();
                    writer2 = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer2.optimize();
                    writer2.close();
                    this.synchronizeLocalIndex();
                }
                catch (Exception ex) {
                    _logger.error("Fatal error in creating index", ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (!this.store.exists() && !IndexReader.indexExists(this.storeIndex) || !this.store.exists() && IndexReader.indexExists(this.storeIndex)) {
            try {
                writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error("Cannot create index", e);
                System.exit(0);
            }
        }
        if (this.remoteSharedStore.exists() && IndexReader.indexExists(this.remoteStoreIndex)) {
            try {
                this.loadRemote(this.remoteSharedStore);
                this.synchronizeRemoteIndex(true);
            }
            catch (Exception e) {
                _logger.error("Error in synchronizing index", e);
                try {
                    files = this.remoteStoreIndex.listFiles();
                    x = 0;
                    while (x < files.length) {
                        boolean deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (!deleted) {
                            files[x].deleteOnExit();
                        }
                        ++x;
                    }
                    this.remoteStoreIndex.delete();
                    IndexWriter writer3 = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer3.optimize();
                    writer3.close();
                    this.synchronizeRemoteIndex(true);
                }
                catch (Exception ex) {
                    _logger.error("Fatal error in creating index", ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (this.remoteSharedStore.exists() && !IndexReader.indexExists(this.remoteStoreIndex)) {
            try {
                writer = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error("Cannot create index", e);
                System.exit(0);
            }
            try {
                this.loadRemote(this.remoteSharedStore);
                this.synchronizeRemoteIndex(true);
            }
            catch (Exception e) {
                _logger.error("Error in synchronizing index", e);
                try {
                    files = this.remoteStoreIndex.listFiles();
                    x = 0;
                    while (x < files.length) {
                        boolean deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (!deleted) {
                            files[x].deleteOnExit();
                        }
                        ++x;
                    }
                    this.remoteStoreIndex.delete();
                    IndexWriter writer4 = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer4.optimize();
                    writer4.close();
                    this.synchronizeRemoteIndex(true);
                }
                catch (Exception ex) {
                    _logger.error("Fatal error in creating index", ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (!this.remoteSharedStore.exists() && !IndexReader.indexExists(this.storeIndex) || !this.remoteSharedStore.exists() && IndexReader.indexExists(this.storeIndex)) {
            try {
                writer = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error("Cannot create index", e);
                System.exit(0);
            }
        }
    }

    private void load(File source) throws Exception {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source));
            Object directories = ois.readObject();
            try {
                this.sharedDirectories = this.stringsToPathsArray((ArrayList)directories);
            }
            catch (Exception e) {
                this.sharedDirectories = (ArrayList)directories;
            }
            this.sharedFilesIndexName = (Hashtable)ois.readObject();
            ois.close();
            this.sharedFilesIndexHash = new Hashtable();
            Enumeration fileNames = this.sharedFilesIndexName.keys();
            while (fileNames.hasMoreElements()) {
                FileInfos infos = (FileInfos)this.sharedFilesIndexName.get((String)fileNames.nextElement());
                this.sharedFilesIndexHash.put(infos.getHash(), infos);
            }
        }
        catch (Exception e) {
            _logger.info("Error loading shared files infos");
            _logger.debug("TRACE", e);
            throw e;
        }
    }

    private void loadRemote(File source) throws Exception {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source));
            this.remoteFilesIndexHash = (Hashtable)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            _logger.info("Error loading remote shared files infos");
            _logger.debug("TRACE", e);
            throw e;
        }
    }

    private ArrayList pathsToStringsArray(ArrayList sharedDirectories) {
        Iterator dirs = sharedDirectories.iterator();
        ArrayList<String> sharedPaths = new ArrayList<String>();
        while (dirs.hasNext()) {
            sharedPaths.add(((File)dirs.next()).getAbsolutePath());
        }
        return sharedPaths;
    }

    private synchronized void processCurrentQuery(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("queryCompleted")) {
            QueryMessage eventQuerySource = (QueryMessage)e.getOldValue();
            if (this.currentQuery != null && eventQuerySource.getLocalQueryId() == this.currentQuery.getLocalQueryId() || !(eventQuerySource.getQuery() instanceof QueryInetAddressItem) && !(eventQuerySource.getQuery() instanceof QueryHttpServerItem) && !(eventQuerySource.getQuery() instanceof QueryHashItem) && !(eventQuerySource.getQuery() instanceof QueryRandomItem)) {
                ArrayList resultSet = (ArrayList)e.getNewValue();
                int x = 0;
                while (x < resultSet.size()) {
                    if (resultSet.get(x) != null) {
                        QueryFileTuple qft = (QueryFileTuple)resultSet.get(x);
                        RemoteFileInfos rfi = new RemoteFileInfos(qft);
                        BackgroundEngine.getInstance().addRemoteFile(rfi);
                    }
                    ++x;
                }
                this.storeRemote(this.remoteSharedStore);
                try {
                    this.synchronizeRemoteIndex(false);
                }
                catch (Exception ex) {
                    _logger.error("Error in synchronizing remote index", ex);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        final PropertyChangeEvent event = e;
        Thread processor = new Thread(){

            public void run() {
                BackgroundEngine.this.processCurrentQuery(event);
            }
        };
        processor.setPriority(1);
        processor.start();
    }

    public void recursiveExplore(File directory, ArrayList fileList, Hashtable tempHashtable) {
        File[] files = directory.listFiles();
        if (files != null) {
            int y = 0;
            while (y < files.length) {
                if (files[y].isFile() && !fileList.contains(files[y].getAbsolutePath())) {
                    fileList.add(files[y].getAbsolutePath());
                    tempHashtable.remove(files[y].getAbsolutePath());
                } else if (files[y].isDirectory() && recursiveExplore) {
                    this.recursiveExplore(files[y], fileList, tempHashtable);
                }
                try {
                    BackgroundEngine.sleep(50L);
                }
                catch (InterruptedException ex) {
                }
                ++y;
            }
        }
    }

    public synchronized void removeDirectory(File directory) {
        this.sharedDirectories.remove(directory);
        this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
    }

    public void removePartialFile(String hash) {
        this.partialFiles.remove(hash);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(pcl);
        DigestManager.removePropertyChangeListener(pcl);
    }

    public void resetIndexingCycle() {
        this.resetCycle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int counter = 0;
        while (!this.terminate) {
            this.resetCycle = false;
            try {
                int y;
                boolean changes = false;
                this.propertyChangeSupport.firePropertyChange("fileIndexingCompleted", null, null);
                Thread.sleep(refreshRate);
                this.propertyChangeSupport.firePropertyChange("fileIndexingInit", null, null);
                ArrayList<String> fileList = new ArrayList<String>();
                Hashtable tempHashtable = (Hashtable)this.sharedFilesIndexName.clone();
                int x = 0;
                while (x < this.sharedDirectories.size()) {
                    File[] files = ((File)this.sharedDirectories.get(x)).listFiles();
                    if (files != null) {
                        y = 0;
                        while (y < files.length) {
                            if (files[y].isFile() && !fileList.contains(files[y].getAbsolutePath())) {
                                fileList.add(files[y].getAbsolutePath());
                                tempHashtable.remove(files[y].getAbsolutePath());
                            } else if (files[y].isDirectory() && recursiveExplore) {
                                this.recursiveExplore(files[y], fileList, tempHashtable);
                            }
                            try {
                                BackgroundEngine.sleep(50L);
                            }
                            catch (InterruptedException ex) {
                            }
                            ++y;
                        }
                    }
                    ++x;
                }
                Enumeration toBeRemoved = tempHashtable.keys();
                while (toBeRemoved.hasMoreElements()) {
                    changes = true;
                    String removeKey = (String)toBeRemoved.nextElement();
                    this.sharedFilesIndexHash.remove(((FileInfos)this.sharedFilesIndexName.get(removeKey)).getHash());
                    this.sharedFilesIndexName.remove(removeKey);
                    IndexReader reader = IndexReader.open(this.storeIndex);
                    Term term = new Term("Path", removeKey);
                    int deleted = reader.delete(term);
                    reader.close();
                }
                y = fileList.size() - 1;
                while (y >= 0 && !this.terminate && !this.resetCycle) {
                    IndexWriter writer;
                    FileInfos infos;
                    if (!this.sharedFilesIndexName.containsKey(fileList.get(y))) {
                        changes = true;
                        infos = new FileInfos(new File((String)fileList.get(y)));
                        this.sharedFilesIndexName.put(fileList.get(y), infos);
                        this.sharedFilesIndexHash.put(infos.getHash(), infos);
                        writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                        writer.addDocument(FileDocument.Document(new File((String)fileList.get(y))));
                        writer.close();
                        this.store(this.store);
                        this.propertyChangeSupport.firePropertyChange("fileIndexed", new Integer(fileList.size()), new Integer(y));
                    } else if (((FileInfos)this.sharedFilesIndexName.get(fileList.get(y))).getLastModified() != new File((String)fileList.get(y)).lastModified()) {
                        changes = true;
                        infos = new FileInfos(new File((String)fileList.get(y)));
                        this.sharedFilesIndexName.put(fileList.get(y), infos);
                        this.sharedFilesIndexHash.put(infos.getHash(), infos);
                        writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                        writer.addDocument(FileDocument.Document(new File((String)fileList.get(y))));
                        writer.close();
                        this.store(this.store);
                        this.propertyChangeSupport.firePropertyChange("fileIndexed", new Integer(fileList.size()), new Integer(y));
                    }
                    --y;
                }
                if (changes) {
                    this.store(this.store);
                    if (Logger.getRootLogger().getEffectiveLevel().toInt() <= 10000) {
                        Enumeration visualizeKeys = this.sharedFilesIndexName.keys();
                        Enumeration visualizeValues = this.sharedFilesIndexName.elements();
                        while (visualizeKeys.hasMoreElements()) {
                            _logger.debug(visualizeKeys.nextElement() + ".....");
                            FileInfos fi = (FileInfos)visualizeValues.nextElement();
                            _logger.debug(fi.getHash() + "....." + fi.getLastModified() + "\n");
                        }
                    }
                    this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
                }
                if (this.wa != null && counter == 0) {
                    this.currentQuery = this.wa.doRandomQuery(broadcastTimeToLive);
                }
                counter = (counter + 1) % timesToRemoteCrawling;
            }
            catch (Exception e) {
                _logger.error("Background Indexer Error", e);
                this.propertyChangeSupport.firePropertyChange("fileIndexingCompleted", null, null);
            }
        }
        BackgroundEngine backgroundEngine = this;
        synchronized (backgroundEngine) {
            while (this.synchronizingRemote) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex1) {
                }
            }
            this.loggingOut = true;
        }
    }

    public ArrayList search(String item) {
        try {
            ArrayList<String> results = new ArrayList<String>();
            IndexReader reader = IndexReader.open(this.storeIndex);
            IndexSearcher searcher = new IndexSearcher(reader);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Query query = QueryParser.parse(item, "TextPath", analyzer);
            Hits hits = searcher.search(query);
            int i = 0;
            while (i < hits.length()) {
                Document doc = hits.doc(i);
                String path = doc.get("Path");
                if (!results.contains(path)) {
                    results.add(path);
                }
                ++i;
            }
            query = QueryParser.parse(item, "Contents", analyzer);
            hits = searcher.search(query);
            int i2 = 0;
            while (i2 < hits.length()) {
                Document doc = hits.doc(i2);
                String path = doc.get("Path");
                if (!results.contains(path)) {
                    results.add(path);
                }
                ++i2;
            }
            reader.close();
            return results;
        }
        catch (Exception ex) {
            _logger.error("Invalid query string", ex);
            return new ArrayList();
        }
    }

    public ArrayList searchRemoteFiles(String item) {
        try {
            ArrayList<String> results = new ArrayList<String>();
            IndexReader reader = IndexReader.open(this.remoteStoreIndex);
            IndexSearcher searcher = new IndexSearcher(reader);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Query query = QueryParser.parse(item, "RemoteFileContent", analyzer);
            Hits hits = searcher.search(query);
            int i = 0;
            while (i < hits.length()) {
                Document doc = hits.doc(i);
                String hash = doc.get("RemoteFileHash");
                if (!results.contains(hash)) {
                    results.add(hash);
                }
                ++i;
            }
            reader.close();
            return results;
        }
        catch (Exception ex) {
            _logger.error("Invalid query string", ex);
            return new ArrayList();
        }
    }

    public void setWarriorAnt(WarriorAnt wa) {
        this.wa = wa;
    }

    private void showErrorFrame() {
        final JFrame connectionDialog = new JFrame("ANts Fatal Error");
        connectionDialog.getContentPane().setLayout(new FlowLayout(1));
        connectionDialog.getContentPane().add(new JLabel("A former ANts intance wasn't able to clear Lucene cache, you need to restart ANts."));
        JButton confirmConnection = new JButton("Ok");
        confirmConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                connectionDialog.setVisible(false);
            }
        });
        connectionDialog.getContentPane().add(confirmConnection);
        connectionDialog.pack();
        connectionDialog.setLocation(300, 300);
        SettingsAntPanel.setLookAndFeel(connectionDialog);
        connectionDialog.setVisible(true);
        while (connectionDialog.isVisible()) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex1) {
            }
        }
    }

    private JFrame showWorkingFrame() {
        JFrame connectionDialog = new JFrame("ANts Indexing");
        connectionDialog.getContentPane().setLayout(new FlowLayout(1));
        connectionDialog.getContentPane().add(new JLabel("ANts is synchronizing your index. Please wait..."));
        JButton confirmConnection = new JButton("Exit");
        confirmConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BackgroundEngine.this.terminate(true);
                System.exit(0);
            }
        });
        connectionDialog.getContentPane().add(confirmConnection);
        connectionDialog.pack();
        connectionDialog.setLocation(300, 300);
        SettingsAntPanel.setLookAndFeel(connectionDialog);
        connectionDialog.setVisible(true);
        return connectionDialog;
    }

    private void store(File dest) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dest));
            oos.writeObject(this.pathsToStringsArray(this.sharedDirectories));
            oos.writeObject(this.sharedFilesIndexName);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            _logger.info("Error storing shared files infos", e);
            _logger.debug("TRACE", e);
        }
    }

    private void storeRemote(File dest) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dest));
            oos.writeObject(this.remoteFilesIndexHash);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            _logger.info("Error storing remote shared files infos", e);
            _logger.debug("TRACE", e);
        }
    }

    private ArrayList stringsToPathsArray(ArrayList sharedPaths) {
        Iterator paths = sharedPaths.iterator();
        ArrayList<File> sharedDirectories = new ArrayList<File>();
        while (paths.hasNext()) {
            sharedDirectories.add(new File((String)paths.next()));
        }
        return sharedDirectories;
    }

    private void synchronizeLocalIndex() throws Exception {
        JFrame waitingFrame = this.showWorkingFrame();
        try {
            IndexReader reader = IndexReader.open(this.storeIndex);
            ArrayList filesArray = new ArrayList();
            Enumeration filesEnum = this.sharedFilesIndexName.keys();
            while (filesEnum.hasMoreElements()) {
                filesArray.add(filesEnum.nextElement());
            }
            int i = 0;
            while (i < reader.maxDoc() && !this.terminate) {
                if (!reader.isDeleted(i)) {
                    Document document = reader.document(i);
                    String path = document.get("Path");
                    if (!filesArray.contains(path)) {
                        reader.delete(i);
                    } else {
                        filesArray.remove(path);
                    }
                }
                ++i;
            }
            reader.close();
            IndexWriter writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
            int i2 = 0;
            while (i2 < filesArray.size() && !this.terminate) {
                File curFile = new File((String)filesArray.get(i2));
                if (curFile.exists() && curFile.isFile()) {
                    writer.addDocument(FileDocument.Document(curFile));
                }
                ++i2;
            }
            writer.optimize();
            writer.close();
            waitingFrame.setVisible(false);
        }
        catch (Exception e) {
            waitingFrame.setVisible(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void synchronizeRemoteIndex(boolean showFrame) throws Exception {
        var2_2 = this;
        synchronized (var2_2) {
            if (!this.loggingOut) ** GOTO lbl8
            return;
lbl-1000:
            // 1 sources

            {
                this.wait();
lbl8:
                // 2 sources

                ** while (this.synchronizingRemote)
            }
lbl9:
            // 1 sources

            this.synchronizingRemote = true;
        }
        waitingFrame = null;
        if (showFrame) {
            waitingFrame = this.showWorkingFrame();
        }
        try {
            reader = IndexReader.open(this.remoteStoreIndex);
            remoteFilesArray = new ArrayList<K>();
            remoteFilesEnum = this.remoteFilesIndexHash.keys();
            while (remoteFilesEnum.hasMoreElements()) {
                remoteFilesArray.add(remoteFilesEnum.nextElement());
            }
            i = 0;
            while (i < reader.maxDoc() && !this.terminate) {
                if (!reader.isDeleted(i)) {
                    document = reader.document(i);
                    remoteHash = document.get("RemoteFileHash");
                    if (!remoteFilesArray.contains(remoteHash)) {
                        reader.delete(i);
                    } else {
                        remoteFilesArray.remove(remoteHash);
                    }
                }
                ++i;
            }
            reader.close();
            writer = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), false);
            i = 0;
            while (i < remoteFilesArray.size() && !this.terminate) {
                writer.addDocument(RemoteFileDocument.Document((RemoteFileInfos)this.remoteFilesIndexHash.get(remoteFilesArray.get(i))));
                ++i;
            }
            if (showFrame) {
                writer.optimize();
            }
            writer.close();
            if (showFrame) {
                waitingFrame.setVisible(false);
            }
            var10_14 = this;
            synchronized (var10_14) {
                this.synchronizingRemote = false;
                this.notifyAll();
            }
        }
        catch (Exception e) {
            if (showFrame) {
                waitingFrame.setVisible(false);
            }
            var5_8 = this;
            synchronized (var5_8) {
                this.synchronizingRemote = false;
                this.notifyAll();
            }
            throw e;
        }
    }

    public void terminate(boolean join) {
        this.terminate = true;
        if (join) {
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                _logger.error("BackgroundEngine interrupted", ex);
            }
            instance = null;
        }
    }
}

