/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils;

import ants.p2p.WarriorAnt;
import ants.p2p.query.ServerInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class InetAddressEngine
extends Thread
implements PropertyChangeListener {
    static Logger _logger = Logger.getLogger((class$ants$p2p$utils$InetAddressEngine == null ? (class$ants$p2p$utils$InetAddressEngine = InetAddressEngine.class$("ants.p2p.utils.InetAddressEngine")) : class$ants$p2p$utils$InetAddressEngine).getName());
    public static int broadcastTimeToLive;
    static /* synthetic */ Class class$ants$p2p$utils$InetAddressEngine;
    public static InetAddressEngine instance;
    public static File peersFile;
    public static int peersToMemorize;
    public static int peersToSendback;
    static ArrayList peersWithFreeSlots;
    public static int refreshRate;
    boolean terminate = false;
    static ArrayList trustedPeers;
    public static File trustedPeersFile;
    WarriorAnt warriorAnt;

    static {
        refreshRate = 300000;
        peersToMemorize = 10;
        peersToSendback = 3;
        broadcastTimeToLive = 1000;
        instance = null;
        trustedPeersFile = new File("trustedPeers.ant");
        peersFile = new File("peers.ant");
        peersWithFreeSlots = new ArrayList();
        trustedPeers = new ArrayList();
        if (trustedPeersFile.exists()) {
            InetAddressEngine.loadTrustedPeers();
        }
        if (peersFile.exists()) {
            InetAddressEngine.loadPeers();
        }
    }

    private InetAddressEngine(WarriorAnt warriorAnt) {
        this.warriorAnt = warriorAnt;
        this.warriorAnt.propertyChangeSupport.addPropertyChangeListener(this);
    }

    public static void addTrustedPeer(String inetAddr, int port) {
        ServerInfo sInfo = new ServerInfo("", inetAddr, new Integer(port), "");
        if (!trustedPeers.contains(sInfo)) {
            trustedPeers.add(sInfo);
            InetAddressEngine.storeTrustedPeers();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static boolean contains(int[] indexes, int val) {
        int x = 0;
        while (x < indexes.length) {
            if (indexes[x] == val) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public static InetAddressEngine getInstance() {
        return instance;
    }

    public static InetAddressEngine getInstance(WarriorAnt owner) {
        try {
            instance = new InetAddressEngine(owner);
            instance.setPriority(1);
            instance.start();
            return instance;
        }
        catch (Exception ex) {
            _logger.error("", ex);
            return null;
        }
    }

    public static ArrayList getPeersWithFreeSlots() {
        ArrayList sendBack = new ArrayList();
        int x = 0;
        while (x < peersToSendback && x < peersWithFreeSlots.size()) {
            sendBack.add(peersWithFreeSlots.get(x));
            ++x;
        }
        return sendBack;
    }

    public static ArrayList getRandomPeersWithFreeSlots(int howMany) {
        int[] indexes = new int[peersToSendback];
        Arrays.fill(indexes, -1);
        int x = 0;
        while (x < howMany && x < peersWithFreeSlots.size()) {
            int index = (int)Math.floor(Math.random() * (double)peersWithFreeSlots.size());
            while (InetAddressEngine.contains(indexes, index)) {
                index = (int)Math.floor(Math.random() * (double)peersWithFreeSlots.size());
            }
            indexes[x] = index;
            ++x;
        }
        ArrayList sendBack = new ArrayList();
        int x2 = 0;
        while (x2 < peersToSendback && x2 < peersWithFreeSlots.size()) {
            sendBack.add(peersWithFreeSlots.get(indexes[x2]));
            ++x2;
        }
        return sendBack;
    }

    public static ArrayList getTrustedPeers() {
        return trustedPeers;
    }

    private static void loadPeers() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(peersFile));
            peersWithFreeSlots = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            _logger.error("Cannot load peers");
        }
    }

    private static void loadTrustedPeers() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(trustedPeersFile));
            trustedPeers = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            _logger.error("Cannot load trusted peers");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("inetAddressQueryCompleted")) {
            ArrayList result = (ArrayList)e.getNewValue();
            int x = 0;
            while (x < result.size()) {
                if (!peersWithFreeSlots.contains(result.get(x))) {
                    peersWithFreeSlots.add(0, result.get(x));
                }
                ++x;
            }
            while (peersWithFreeSlots.size() > peersToMemorize) {
                peersWithFreeSlots.remove(peersWithFreeSlots.size() - 1);
            }
            InetAddressEngine.storePeers();
        }
    }

    public static void removeTrustedPeer(ServerInfo sInfo) {
        trustedPeers.remove(sInfo);
        InetAddressEngine.storeTrustedPeers();
    }

    public void run() {
        while (!this.terminate) {
            try {
                _logger.info("Search...");
                this.warriorAnt.getServersWithFreeSlots(broadcastTimeToLive);
                Thread.sleep(refreshRate);
            }
            catch (Exception e) {
                _logger.error("", e);
            }
        }
        _logger.info("InetAddressEngine Terminated");
    }

    private static void storePeers() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(peersFile));
            oos.writeObject(peersWithFreeSlots);
            oos.close();
        }
        catch (IOException e) {
            _logger.error("Cannot store peers", e);
        }
    }

    private static void storeTrustedPeers() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(trustedPeersFile));
            oos.writeObject(trustedPeers);
            oos.close();
        }
        catch (IOException e) {
            _logger.error("Cannot store trusted peers", e);
        }
    }

    public void terminate() {
        this.terminate = true;
    }
}

