/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

import com.bitzi.util.Base32;
import com.bitzi.util.Tiger;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private static final boolean USE_CRYPTIX;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private List nodes = new ArrayList();

    public TigerTree() {
        super("tigertree");
        if (USE_CRYPTIX) {
            try {
                this.tiger = MessageDigest.getInstance("Tiger", "CryptixCrypto");
            }
            catch (NoSuchAlgorithmException nsae) {
                this.tiger = new Tiger();
            }
            catch (NoSuchProviderException nspe) {
                this.tiger = new Tiger();
            }
        } else {
            this.tiger = new Tiger();
        }
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte in) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = in;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte[] in, int offset, int length) {
        int remaining;
        this.byteCount += (long)length;
        while (length >= (remaining = 1024 - this.bufferOffset)) {
            void var4_4;
            System.arraycopy(in, offset, this.buffer, this.bufferOffset, (int)var4_4);
            this.bufferOffset += var4_4;
            this.blockUpdate();
            length -= var4_4;
            offset += var4_4;
            this.bufferOffset = 0;
        }
        System.arraycopy(in, offset, this.buffer, this.bufferOffset, length);
        this.bufferOffset += length;
    }

    protected byte[] engineDigest() {
        byte[] hash = new byte[24];
        try {
            this.engineDigest(hash, 0, 24);
        }
        catch (DigestException e) {
            return null;
        }
        return hash;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        while (this.nodes.size() > 1) {
            ArrayList newNodes = new ArrayList();
            Iterator iter = this.nodes.iterator();
            while (iter.hasNext()) {
                byte[] left = (byte[])iter.next();
                if (iter.hasNext()) {
                    byte[] right = (byte[])iter.next();
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(left, 0, left.length);
                    this.tiger.update(right, 0, right.length);
                    newNodes.add(this.tiger.digest());
                    continue;
                }
                newNodes.add(left);
            }
            this.nodes = newNodes;
        }
        System.arraycopy(this.nodes.get(0), 0, buf, offset, 24);
        this.engineReset();
        return 24;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new ArrayList();
        this.tiger.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 & this.nodes.size() > 0) {
            return;
        }
        this.nodes.add(this.tiger.digest());
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException, NoSuchAlgorithmException {
        if (args.length < 1) {
            System.out.println("You must supply a filename.");
            return;
        }
        TigerTree tt = new TigerTree();
        int i = 0;
        while (i < args.length) {
            int read;
            FileInputStream fis = new FileInputStream(args[i]);
            byte[] in = new byte[1024];
            while ((read = fis.read(in)) > -1) {
                void var4_4;
                tt.update(in, 0, (int)var4_4);
            }
            fis.close();
            byte[] digest = tt.digest();
            String hash = new BigInteger(1, digest).toString(16);
            while (hash.length() < 48) {
                hash = "0" + hash;
            }
            System.out.println("hex:" + hash);
            System.out.println("b32:" + Base32.encode(digest));
            tt.reset();
            ++i;
        }
    }

    static {
        boolean bl = USE_CRYPTIX = CommonUtils.isJava14OrLater() && CommonUtils.isMacOSX() && CommonUtils.isJaguarOrAbove() && !CommonUtils.isPantherOrAbove();
        if (USE_CRYPTIX) {
            try {
                Class<?> clazz = Class.forName("cryptix.jce.provider.CryptixCrypto");
                Object o = clazz.newInstance();
                Security.addProvider((Provider)o);
            }
            catch (ClassNotFoundException e) {
                ErrorService.error(e);
            }
            catch (IllegalAccessException e) {
                ErrorService.error(e);
            }
            catch (InstantiationException e) {
                ErrorService.error(e);
            }
            catch (ExceptionInInitializerError e) {
                ErrorService.error(e);
            }
            catch (SecurityException e) {
                ErrorService.error(e);
            }
            catch (ClassCastException e) {
                ErrorService.error(e);
            }
        }
    }
}

