/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.TreeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class CreationTimeCache {
    private static final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private static CreationTimeCache instance;
    private static FileManager fileManager;
    private final Map URN_TO_TIME_MAP = this.createMap();
    private final SortedMap TIME_TO_URNSET_MAP = new TreeMap(Comparators.inverseLongComparator());

    public static synchronized CreationTimeCache instance() {
        return instance;
    }

    private CreationTimeCache() {
        this.pruneTimes(false);
        this.constructURNMap();
    }

    public synchronized Long getCreationTime(URN urn) {
        return (Long)this.URN_TO_TIME_MAP.get(urn);
    }

    public synchronized void removeTime(URN urn) {
        this.removeURNFromURNSet(urn, (Long)this.URN_TO_TIME_MAP.remove(urn));
    }

    private synchronized void pruneTimes(boolean shouldClearURNSetMap) {
        Iterator iter = this.URN_TO_TIME_MAP.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry currEntry = (Map.Entry)iter.next();
            URN currURN = (URN)currEntry.getKey();
            Long cTime = (Long)currEntry.getValue();
            FileDesc fd = fileManager.getFileDescForUrn(currURN);
            if (fd != null && fd.getFile() != null && fd.getFile().exists()) continue;
            iter.remove();
            if (!shouldClearURNSetMap) continue;
            this.removeURNFromURNSet(currURN, cTime);
        }
    }

    public synchronized void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN urn, long time) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (time <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + time);
        }
        Long cTime = new Long(time);
        this.URN_TO_TIME_MAP.put(urn, cTime);
    }

    public synchronized void commitTime(URN urn) throws IllegalArgumentException {
        if (urn == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long cTime = (Long)this.URN_TO_TIME_MAP.get(urn);
        if (cTime == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        Set urnSet = (Set)this.TIME_TO_URNSET_MAP.get(cTime);
        if (urnSet == null) {
            urnSet = new HashSet();
            this.TIME_TO_URNSET_MAP.put(cTime, urnSet);
        }
        urnSet.add(urn);
    }

    public synchronized List getFiles(int max) throws IllegalArgumentException {
        return this.getFiles(null, max);
    }

    public synchronized List getFiles(QueryRequest request, int max) throws IllegalArgumentException {
        if (max < 1) {
            throw new IllegalArgumentException("bad max = " + max);
        }
        ArrayList urnList = new ArrayList();
        Iterator iter = this.TIME_TO_URNSET_MAP.entrySet().iterator();
        MediaType.Aggregator filter = request == null ? null : MediaType.getAggregator(request);
        List toRemove = null;
        while (iter.hasNext() && urnList.size() < max) {
            Map.Entry currEntry = (Map.Entry)iter.next();
            Set urns = (Set)currEntry.getValue();
            Iterator innerIter = urns.iterator();
            while (urnList.size() < max && innerIter.hasNext()) {
                URN currURN = (URN)innerIter.next();
                FileDesc fd = fileManager.getFileDescForUrn(currURN);
                if (fd == null || fd instanceof IncompleteFileDesc) {
                    if (toRemove == null) {
                        toRemove = new ArrayList();
                    }
                    toRemove.add(currURN);
                    continue;
                }
                if (filter == null) {
                    urnList.add(currURN);
                    continue;
                }
                if (!filter.allow(fd.getName())) continue;
                urnList.add(currURN);
            }
        }
        if (toRemove != null) {
            Iterator removees = toRemove.iterator();
            while (removees.hasNext()) {
                URN currURN = (URN)removees.next();
                this.removeTime(currURN);
            }
        }
        return urnList;
    }

    public synchronized List getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * Loose catch block
     */
    public synchronized void persistCache() {
        block11: {
            ObjectOutputStream oos = null;
            oos = new ObjectOutputStream(new FileOutputStream(CTIME_CACHE_FILE));
            oos.writeObject(this.URN_TO_TIME_MAP);
            Object var4_2 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                break block11;
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (IOException e) {
                    ErrorService.error(e);
                    Object var4_3 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private synchronized void removeURNFromURNSet(URN urn, Long refTime) {
        block2: {
            block1: {
                if (refTime == null) break block1;
                Set urnSet = (Set)this.TIME_TO_URNSET_MAP.get(refTime);
                if (urnSet == null || !urnSet.remove(urn) || urnSet.size() >= 1) break block2;
                this.TIME_TO_URNSET_MAP.remove(refTime);
                break block2;
            }
            Iterator iter = this.TIME_TO_URNSET_MAP.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry currEntry = (Map.Entry)iter.next();
                Set urnSet = (Set)currEntry.getValue();
                if (!urnSet.contains(urn)) continue;
                urnSet.remove(urn);
                if (urnSet.size() >= 1) break;
                iter.remove();
                break;
            }
        }
    }

    private void constructURNMap() {
        Set entries = this.URN_TO_TIME_MAP.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry currEntry = (Map.Entry)iter.next();
            Long cTime = (Long)currEntry.getValue();
            URN urn = (URN)currEntry.getKey();
            if (fileManager.getFileDescForUrn(urn) instanceof IncompleteFileDesc) continue;
            Set urnSet = (Set)this.TIME_TO_URNSET_MAP.get(cTime);
            if (urnSet == null) {
                urnSet = new HashSet();
                this.TIME_TO_URNSET_MAP.put(cTime, urnSet);
            }
            urnSet.add(urn);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map createMap() {
        ois = null;
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(CreationTimeCache.CTIME_CACHE_FILE));
                var2_2 = (Map)ois.readObject();
                var10_4 = null;
                if (ois == null) return var2_2;
            }
            catch (FileNotFoundException e) {
                var3_20 = new HashMap();
                var10_5 = null;
                if (ois == null) return var3_20;
                try {
                    ois.close();
                    return var3_20;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var3_20;
            }
            catch (IOException e) {
                var4_22 = new HashMap();
                var10_6 = null;
                if (ois == null) return var4_22;
                ** try [egrp 2[TRYBLOCK] [7 : 145->152)] { 
lbl27:
                // 1 sources

                ois.close();
                return var4_22;
lbl29:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var4_22;
            }
            catch (ClassNotFoundException e) {
                var5_24 = new HashMap();
                var10_7 = null;
                if (ois == null) return var5_24;
                ** try [egrp 2[TRYBLOCK] [7 : 145->152)] { 
lbl38:
                // 1 sources

                ois.close();
                return var5_24;
lbl40:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var5_24;
            }
            catch (ClassCastException e) {
                var6_26 = new HashMap();
                var10_8 = null;
                if (ois == null) return var6_26;
                ** try [egrp 2[TRYBLOCK] [7 : 145->152)] { 
lbl49:
                // 1 sources

                ois.close();
                return var6_26;
lbl51:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var6_26;
            }
            catch (IndexOutOfBoundsException ioobe) {
                var7_28 = new HashMap();
                var10_9 = null;
                if (ois == null) return var7_28;
                ** try [egrp 2[TRYBLOCK] [7 : 145->152)] { 
lbl60:
                // 1 sources

                ois.close();
                return var7_28;
lbl62:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var7_28;
            }
            catch (SecurityException se) {
                var8_30 = new HashMap();
                var10_10 = null;
                if (ois == null) return var8_30;
                ** try [egrp 2[TRYBLOCK] [7 : 145->152)] { 
lbl71:
                // 1 sources

                ois.close();
                return var8_30;
lbl73:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var8_30;
            }
        }
        catch (Throwable var9_31) {
            var10_11 = null;
            if (ois == null) throw var9_31;
            try {}
            catch (IOException e) {
                throw var9_31;
            }
            ois.close();
            throw var9_31;
        }
        ** try [egrp 2[TRYBLOCK] [7 : 145->152)] { 
lbl87:
        // 1 sources

        ois.close();
        return var2_2;
lbl89:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var2_2;
    }

    static {
        fileManager = RouterService.getFileManager();
        instance = new CreationTimeCache();
    }
}

