/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ForMeReplyHandler
implements ReplyHandler {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$ForMeReplyHandler == null ? (class$com$limegroup$gnutella$ForMeReplyHandler = ForMeReplyHandler.class$("com.limegroup.gnutella.ForMeReplyHandler")) : class$com$limegroup$gnutella$ForMeReplyHandler);
    private static final ReplyHandler INSTANCE = new ForMeReplyHandler();
    static /* synthetic */ Class class$com$limegroup$gnutella$ForMeReplyHandler;

    public static ReplyHandler instance() {
        return INSTANCE;
    }

    private ForMeReplyHandler() {
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler handler) {
        if (pingReply.getHops() <= 1 && handler.getNumMessagesReceived() <= 2 && !handler.isOutgoing() && handler.isKillable() && pingReply.getFiles() < (long)SharingSettings.FREELOADER_FILES.getValue() && (int)(Math.random() * 100.0) > SharingSettings.FREELOADER_ALLOWED.getValue() && handler instanceof ManagedConnection && handler.isStable()) {
            ConnectionManager cm = RouterService.getConnectionManager();
            cm.remove((ManagedConnection)handler);
        }
    }

    public void handleQueryReply(QueryReply reply, ReplyHandler handler) {
        if (handler != null && handler.isPersonalSpam(reply)) {
            return;
        }
        try {
            if (reply.isReplyToMulticastQuery()) {
                if (reply.isTCP()) {
                    return;
                }
                if (reply.getHops() != 1 || reply.getTTL() != 0) {
                    return;
                }
            }
        }
        catch (BadPacketException bpe) {
            return;
        }
        boolean validResponses = this.addXMLToResponses(reply);
        if (!validResponses) {
            return;
        }
        SearchResultHandler resultHandler = RouterService.getSearchResultHandler();
        resultHandler.handleQueryReply(reply);
        DownloadManager dm = RouterService.getDownloadManager();
        dm.handleQueryReply(reply);
    }

    private boolean addXMLToResponses(QueryReply qr) {
        int responsesLength;
        Response[] responses;
        String xmlCollectionString = "";
        try {
            LOG.trace("Trying to do uncompress XML.....");
            byte[] xmlCompressed = qr.getXMLBytes();
            if (xmlCompressed.length > 1) {
                byte[] xmlUncompressed = LimeXMLUtils.uncompress(xmlCompressed);
                xmlCollectionString = new String(xmlUncompressed, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException use) {
            ErrorService.error(use);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (xmlCollectionString == null || xmlCollectionString.equals("")) {
            return true;
        }
        try {
            responses = qr.getResultsArray();
            responsesLength = responses.length;
        }
        catch (BadPacketException bpe) {
            LOG.trace("Unable to get responses", bpe);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("xmlCollectionString = " + xmlCollectionString);
        }
        List allDocsArray = LimeXMLDocumentHelper.getDocuments(xmlCollectionString, responsesLength);
        int i = 0;
        while (i < responsesLength) {
            Response response = responses[i];
            int schema = 0;
            while (schema < allDocsArray.size()) {
                LimeXMLDocument[] metaDocs = (LimeXMLDocument[])allDocsArray.get(schema);
                if (metaDocs != null && metaDocs[i] != null) {
                    response.setDocument(metaDocs[i]);
                    break;
                }
                ++schema;
            }
            ++i;
        }
        return true;
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler handler) {
        if (handler.isPersonalSpam(pushRequest)) {
            return;
        }
        byte[] ip = pushRequest.getIP();
        StringBuffer buf = new StringBuffer();
        buf.append(ByteOrder.ubyte2int(ip[0]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[1]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[2]) + ".");
        buf.append(ByteOrder.ubyte2int(ip[3]) + "");
        String h = buf.toString();
        if (RouterService.getAcceptor().isBannedIP(h)) {
            return;
        }
        int port = pushRequest.getPort();
        if (!NetworkUtils.isValidPort(port)) {
            return;
        }
        int index = (int)pushRequest.getIndex();
        FileManager fm = RouterService.getFileManager();
        if (!fm.isValidIndex(index)) {
            return;
        }
        String req_guid_hexstring = new GUID(pushRequest.getClientGUID()).toString();
        FileDesc desc = fm.get(index);
        if (desc == null) {
            return;
        }
        String file = desc.getName();
        RouterService.getPushManager().acceptPushUpload(file, h, port, index, req_guid_hexstring, pushRequest.isMulticast());
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public void countDroppedMessage() {
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public Set getDomains() {
        return DataUtils.EMPTY_SET;
    }

    public boolean isPersonalSpam(Message m) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isLeafConnection() {
        return !RouterService.isSupernode();
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return true;
    }

    public boolean allowNewPings() {
        return true;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(NetworkUtils.ip2string(RouterService.getAddress()));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public void handleStatisticVM(StatisticVendorMessage vm) {
        Assert.that(false, "ForMeReplyHandler asked to send vendor message");
    }

    public boolean isStable() {
        return true;
    }

    public String getLocalePref() {
        return ApplicationSettings.LANGUAGE.getValue();
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong m) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

