/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.messages.PingReply;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;

public final class HorizonCounter {
    private static final HorizonCounter INSTANCE = new HorizonCounter();
    static long HORIZON_UPDATE_TIME = 600000L;
    private long _lastRefreshHorizonTime = System.currentTimeMillis();
    private boolean _refreshedHorizonStats = false;
    private static final int MAX_PING_REPLIES = 4000;
    private Set _pongs = new HashSet();
    private long _totalHorizonFileSize = 0L;
    private long _numHorizonFiles = 0L;
    private long _numHorizonHosts = 0L;
    private long _nextTotalHorizonFileSize = 0L;
    private long _nextNumHorizonFiles = 0L;
    private long _nextNumHorizonHosts = 0L;

    public static HorizonCounter instance() {
        return INSTANCE;
    }

    public synchronized void addPong(PingReply pong) {
        Endpoint host = new Endpoint(pong.getAddress(), pong.getPort());
        if (this._pongs.size() < 4000 && this._pongs.add(host)) {
            this._nextTotalHorizonFileSize += pong.getKbytes();
            this._nextNumHorizonFiles += pong.getFiles();
            ++this._nextNumHorizonHosts;
        }
    }

    public synchronized void refresh() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._lastRefreshHorizonTime;
        if (elapsed < HORIZON_UPDATE_TIME) {
            return;
        }
        this._lastRefreshHorizonTime = now;
        this._numHorizonHosts = this._nextNumHorizonHosts;
        this._numHorizonFiles = this._nextNumHorizonFiles;
        this._totalHorizonFileSize = this._nextTotalHorizonFileSize;
        this._nextNumHorizonHosts = 0L;
        this._nextNumHorizonFiles = 0L;
        this._nextTotalHorizonFileSize = 0L;
        this._pongs.clear();
        this._refreshedHorizonStats = true;
    }

    public synchronized long getNumHosts() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonHosts;
        }
        return this._nextNumHorizonHosts;
    }

    public synchronized long getNumFiles() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonFiles;
        }
        return this._nextNumHorizonFiles;
    }

    public synchronized long getTotalFileSize() {
        if (this._refreshedHorizonStats) {
            return this._totalHorizonFileSize;
        }
        return this._nextTotalHorizonFileSize;
    }
}

