/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.PingPongSettings;
import com.limegroup.gnutella.util.ManagedThread;

public final class Pinger
implements Runnable {
    private static final Pinger INSTANCE = new Pinger();
    public static final int PING_INTERVAL = 3000;

    public static Pinger instance() {
        return INSTANCE;
    }

    private Pinger() {
    }

    public void start() {
        ManagedThread pingThread = new ManagedThread(this, "pinger thread");
        pingThread.setDaemon(true);
        pingThread.start();
    }

    public void run() {
        try {
            while (true) {
                if (RouterService.isSupernode() && PingPongSettings.PINGS_ACTIVE.getValue()) {
                    RouterService.getMessageRouter().broadcastPingRequest(new PingRequest(3));
                }
                Thread.sleep(3000L);
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }
}

