/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SavedFileManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$SavedFileManager == null ? (class$com$limegroup$gnutella$SavedFileManager = SavedFileManager.class$("com.limegroup.gnutella.SavedFileManager")) : class$com$limegroup$gnutella$SavedFileManager);
    private static SavedFileManager INSTANCE = new SavedFileManager();
    private Set _urns = new HashSet();
    private Set _names = new TreeSet(Comparators.caseInsensitiveStringComparator());
    private volatile boolean _loading = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$SavedFileManager;

    public static SavedFileManager instance() {
        return INSTANCE;
    }

    private SavedFileManager() {
        RouterService.schedule(this, 10000L, 180000L);
    }

    public synchronized void addSavedFile(File f, Set urns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding: " + f + " with: " + urns);
        }
        this._names.add(f.getName());
        Iterator i = urns.iterator();
        while (i.hasNext()) {
            this._urns.add(i.next());
        }
    }

    public synchronized boolean isSaved(URN urn, String name) {
        return urn != null && this._urns.contains(urn) || this._names.contains(name);
    }

    public synchronized boolean isLoading() {
        return this._loading || !RouterService.getFileManager().isLoadFinished();
    }

    public void run() {
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            if (!this.isLoading()) {
                this._loading = true;
                ManagedThread t = new ManagedThread(new Runnable(){

                    public void run() {
                        try {
                            SavedFileManager.this.load();
                            Object var2_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            SavedFileManager.this._loading = false;
                            throw throwable;
                        }
                        SavedFileManager.this._loading = false;
                    }
                }, "SavedFileProcessor");
                t.setDaemon(true);
                t.start();
            }
        }
    }

    private void load() {
        LOG.trace("Loading Saved Files");
        HashSet urns = new HashSet();
        TreeSet names = new TreeSet(Comparators.caseInsensitiveStringComparator());
        File saveDirectory = SharingSettings.getSaveDirectory();
        String[] saved = saveDirectory.list();
        if (saved == null) {
            saved = new String[]{};
        }
        int i = 0;
        while (i < saved.length) {
            String name = saved[i];
            File file = new File(saveDirectory, name);
            if (file.isFile()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loading: " + file);
                }
                names.add(name);
                try {
                    Set fileUrns = FileDesc.calculateAndCacheURN(file);
                    Iterator j = fileUrns.iterator();
                    while (j.hasNext()) {
                        urns.add(j.next());
                    }
                }
                catch (IOException ignored) {
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            ++i;
        }
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            this._names = names;
            this._urns = urns;
        }
        LOG.trace("Finished loading saved Files.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

