/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorCallback;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;

public final class UDPService
implements Runnable {
    private static final UDPService INSTANCE = new UDPService();
    private volatile DatagramSocket _socket;
    private final Object _receiveLock = new Object();
    private final Object _sendLock = new Object();
    private boolean _socketSetOnce = false;
    private final int BUFFER_SIZE = 32768;
    private boolean _acceptedSolicitedIncoming = false;
    private boolean _acceptedUnsolicitedIncoming = false;
    private long _lastUnsolicitedIncomingTime = 0L;
    private long _lastConnectBackTime = System.currentTimeMillis();
    private final Thread UDP_RECEIVE_THREAD;
    private final ProcessingQueue SEND_QUEUE;
    private final GUID CONNECT_BACK_GUID = new GUID(GUID.makeGuid());
    private final GUID SOLICITED_PING_GUID = new GUID(GUID.makeGuid());
    private static final long PING_PERIOD = 85000L;

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - Acceptor.INCOMING_EXPIRE_TIME;
    }

    public static UDPService instance() {
        return INSTANCE;
    }

    private UDPService() {
        this.UDP_RECEIVE_THREAD = new ManagedThread(this, "UDPService-Receiver");
        this.UDP_RECEIVE_THREAD.setDaemon(true);
        this.SEND_QUEUE = new ProcessingQueue("UDPService-Sender");
        RouterService.schedule(new IncomingValidator(), Acceptor.TIME_BETWEEN_VALIDATES, Acceptor.TIME_BETWEEN_VALIDATES);
        RouterService.schedule(new PeriodicPinger(), 0L, 85000L);
    }

    public void start() {
        this.UDP_RECEIVE_THREAD.start();
    }

    public GUID getConnectBackGUID() {
        return this.CONNECT_BACK_GUID;
    }

    public GUID getSolicitedGUID() {
        return this.SOLICITED_PING_GUID;
    }

    DatagramSocket newListeningSocket(int port) throws IOException {
        try {
            return new DatagramSocket(port);
        }
        catch (SocketException se) {
            throw new IOException("socket could not be set on port: " + port);
        }
        catch (SecurityException se) {
            throw new IOException("security exception on port: " + port);
        }
    }

    void setListeningSocket(DatagramSocket datagramSocket) {
        if (this._socket != null) {
            this._socket.close();
        }
        Object object = this._receiveLock;
        synchronized (object) {
            Object object2 = this._sendLock;
            synchronized (object2) {
                if (this._socket == null && datagramSocket != null) {
                    this._socketSetOnce = true;
                }
                if (this._socketSetOnce && datagramSocket == null) {
                    this._socketSetOnce = false;
                }
                this._socket = datagramSocket;
                this._receiveLock.notify();
                this._sendLock.notify();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            byte[] datagramBytes = new byte[32768];
            MessageRouter router = RouterService.getMessageRouter();
            block12: while (true) {
                DatagramPacket datagram = new DatagramPacket(datagramBytes, 32768);
                Object object = this._receiveLock;
                synchronized (object) {
                    while (true) {
                        if (this._socket != null) {
                            try {
                                this._socket.receive(datagram);
                                break;
                            }
                            catch (InterruptedIOException e) {
                                continue block12;
                            }
                            catch (IOException e) {
                                continue block12;
                            }
                        }
                        try {
                            this._receiveLock.wait();
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                    if (!NetworkUtils.isValidAddress(datagram.getAddress()) || !NetworkUtils.isValidPort(datagram.getPort())) continue;
                }
                byte[] data = datagram.getData();
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    Message message = Message.read((InputStream)in, 2);
                    if (message == null) continue;
                    if (!this.isGUESSCapable()) {
                        GUID guid;
                        if (message instanceof PingRequest) {
                            guid = new GUID(message.getGUID());
                            if (this.isValidForIncoming(this.CONNECT_BACK_GUID, guid, datagram)) {
                                this._acceptedUnsolicitedIncoming = true;
                            }
                            this._lastUnsolicitedIncomingTime = System.currentTimeMillis();
                        } else if (message instanceof PingReply && this.isValidForIncoming(this.SOLICITED_PING_GUID, guid = new GUID(message.getGUID()), datagram)) {
                            this._acceptedSolicitedIncoming = true;
                        }
                    }
                    if (message instanceof ReplyNumberVendorMessage) {
                        this._lastUnsolicitedIncomingTime = System.currentTimeMillis();
                    }
                    router.handleUDPMessage(message, datagram);
                }
                catch (IOException e) {
                }
                catch (BadPacketException e) {}
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    private boolean isValidForIncoming(GUID match, GUID guidReceived, DatagramPacket d) {
        if (!match.equals(guidReceived)) {
            return false;
        }
        String host = d.getAddress().getHostAddress();
        return !ConnectionSettings.LOCAL_IS_PRIVATE.getValue() || !RouterService.getConnectionManager().isConnectedTo(host);
    }

    public void send(Message msg, IpPort host) {
        this.send(msg, host.getInetAddress(), host.getPort());
    }

    public void send(Message msg, InetAddress ip, int port) throws IllegalArgumentException {
        this.send(msg, ip, port, ErrorService.getErrorCallback());
    }

    public void send(Message msg, InetAddress ip, int port, ErrorCallback err) throws IllegalArgumentException {
        if (err == null) {
            throw new IllegalArgumentException("Null ErrorCallback");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (ip == null) {
            throw new IllegalArgumentException("Null InetAddress");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("Invalid Port: " + port);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            msg.write(baos);
        }
        catch (IOException e) {
            ErrorService.error(e);
            return;
        }
        byte[] data = baos.toByteArray();
        DatagramPacket dg = new DatagramPacket(data, data.length, ip, port);
        this.SEND_QUEUE.add(new Sender(dg, err));
    }

    public boolean isGUESSCapable() {
        return this.canReceiveUnsolicited() && this.canReceiveSolicited();
    }

    public boolean canReceiveUnsolicited() {
        return this._acceptedUnsolicitedIncoming;
    }

    public boolean canReceiveSolicited() {
        return this._acceptedSolicitedIncoming;
    }

    public boolean isListening() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.getLocalPort() != -1;
    }

    public String toString() {
        return "UDPAcceptor\r\nsocket: " + this._socket;
    }

    private class PeriodicPinger
    implements Runnable {
        private PeriodicPinger() {
        }

        public void run() {
            GUESSEndpoint ep = QueryUnicaster.instance().getUnicastEndpoint();
            if (ep == null) {
                return;
            }
            if (!UDPService.this.canReceiveSolicited() && !UDPService.this.canReceiveUnsolicited()) {
                return;
            }
            PingRequest pr = new PingRequest(UDPService.this.getSolicitedGUID().bytes(), 1, 0);
            UDPService.this.send(pr, ep.getAddress(), ep.getPort());
        }
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            final long currTime = System.currentTimeMillis();
            final MessageRouter mr = RouterService.getMessageRouter();
            ConnectionManager cm = RouterService.getConnectionManager();
            if (UDPService.this._acceptedUnsolicitedIncoming && currTime - UDPService.this._lastUnsolicitedIncomingTime > Acceptor.INCOMING_EXPIRE_TIME || !UDPService.this._acceptedUnsolicitedIncoming && currTime - UDPService.this._lastConnectBackTime > Acceptor.INCOMING_EXPIRE_TIME) {
                final GUID cbGuid = new GUID(GUID.makeGuid());
                final MLImpl ml = new MLImpl(cbGuid);
                mr.registerMessageListener(cbGuid, ml);
                if (cm.sendUDPConnectBackRequests(cbGuid)) {
                    UDPService.this._lastConnectBackTime = System.currentTimeMillis();
                    Runnable checkThread = new Runnable(){

                        public void run() {
                            if (UDPService.this._acceptedUnsolicitedIncoming && UDPService.this._lastUnsolicitedIncomingTime < currTime || !UDPService.this._acceptedUnsolicitedIncoming) {
                                UDPService.this._acceptedUnsolicitedIncoming = ml._gotIncoming;
                            }
                            mr.unregisterMessageListener(cbGuid);
                        }
                    };
                    RouterService.schedule(checkThread, Acceptor.WAIT_TIME_AFTER_REQUESTS, 0L);
                } else {
                    mr.unregisterMessageListener(cbGuid);
                }
            }
        }
    }

    private static class MLImpl
    implements MessageListener {
        public boolean _gotIncoming = false;
        private final GUID _guid;

        public MLImpl(GUID guid) {
            this._guid = guid;
        }

        public void processMessage(Message m) {
            if (m instanceof PingRequest && this._guid.equals(new GUID(m.getGUID()))) {
                this._gotIncoming = true;
            }
        }
    }

    private class Sender
    implements Runnable {
        private final DatagramPacket _dp;
        private final ErrorCallback _err;

        Sender(DatagramPacket dp, ErrorCallback err) {
            this._dp = dp;
            this._err = err;
        }

        public void run() {
            Object object = UDPService.this._sendLock;
            synchronized (object) {
                if (UDPService.this._socket == null) {
                    if (UDPService.this._socketSetOnce) {
                        NullPointerException npe = new NullPointerException("Null UDP Socket!!");
                        ErrorService.error(npe);
                    }
                    return;
                }
                try {
                    UDPService.this._socket.send(this._dp);
                }
                catch (BindException be) {
                }
                catch (NoRouteToHostException nrthe) {
                }
                catch (IOException ioe) {
                    if (this.isIgnoreable(ioe.getMessage())) {
                        return;
                    }
                    String errString = "ip/port: " + this._dp.getAddress() + ":" + this._dp.getPort();
                    this._err.error(ioe, errString);
                }
            }
        }

        private boolean isIgnoreable(String message) {
            if (message == null) {
                return false;
            }
            String msg = message.toLowerCase();
            if (this.scan(msg, 10013, "permission denied")) {
                return true;
            }
            if (this.scan(msg, 10049, "cannot assign requested address")) {
                return true;
            }
            if (this.scan(msg, 10053, "software caused connection abort")) {
                return true;
            }
            if (this.scan(msg, 10054, "connection reset by peer")) {
                return true;
            }
            if (this.scan(msg, 10061, "connection refused")) {
                return true;
            }
            if (this.scan(msg, 10064, "host is down")) {
                return true;
            }
            if (this.scan(msg, 10065, "no route to host")) {
                return true;
            }
            if (this.scan(msg, 10004, "interrupted function call")) {
                return true;
            }
            if (this.scan(msg, 10050, "network is down")) {
                return true;
            }
            if (this.scan(msg, 10052, "network dropped connection on reset")) {
                return true;
            }
            if (this.scan(msg, 10051, "network is unreachable")) {
                return true;
            }
            if (this.scan(msg, 10055, "no buffer space available")) {
                return true;
            }
            if (this.scan(msg, 10060, "connection timed out")) {
                return true;
            }
            if (this.scan(msg, 10035, "resource temporarily unavailable")) {
                return true;
            }
            if (this.scan(msg, 11001, "host not found")) {
                return true;
            }
            if (this.scan(msg, 10091, "network subsystem is unavailable")) {
                return true;
            }
            if (this.scan(msg, 10107, "option unsupported by protocol")) {
                return true;
            }
            return msg.indexOf("operation not permitted") > -1;
        }

        private boolean scan(String msg, int code, String name) {
            if (msg.indexOf("code=" + code) > -1) {
                return true;
            }
            if (msg.indexOf("error: " + code) > -1) {
                return true;
            }
            return msg.indexOf(name) > -1;
        }
    }
}

